/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.plugin;

import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Hashtable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.model.PluginPrerequisiteModel;
import org.eclipse.pde.core.plugin.IMatchRules;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.internal.core.plugin.IdentifiablePluginObject;
import org.w3c.dom.Node;

public class PluginImport
extends IdentifiablePluginObject
implements IPluginImport,
Serializable {
    private int match = 0;
    private boolean reexported = false;
    private boolean optional = false;
    private String version;

    public boolean isValid() {
        return this.getId() != null;
    }

    public int getMatch() {
        return this.match;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isReexported() {
        return this.reexported;
    }

    public boolean isOptional() {
        return this.optional;
    }

    void load(PluginPrerequisiteModel importModel) {
        this.id = importModel.getPlugin();
        this.reexported = importModel.getExport();
        this.version = importModel.getVersion();
        switch (importModel.getMatchByte()) {
            case 1: {
                this.match = 3;
                break;
            }
            case 2: {
                this.match = 1;
                break;
            }
            case 3: {
                this.match = 2;
                break;
            }
            case 4: {
                this.match = 4;
            }
        }
        this.optional = importModel.getOptional();
        this.range = new int[]{importModel.getStartLine(), importModel.getStartLine()};
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof IPluginImport) {
            IPluginImport target = (IPluginImport)obj;
            if (target.getModel().equals(this.getModel())) {
                return false;
            }
            if (target.getId().equals(this.getId()) && target.isReexported() == this.isReexported() && this.stringEqualWithNull(target.getVersion(), this.getVersion()) && target.getMatch() == this.getMatch() && target.isOptional() == this.isOptional()) {
                return true;
            }
        }
        return false;
    }

    void load(Node node, Hashtable lineTable) {
        String id = this.getNodeAttribute(node, "plugin");
        String export = this.getNodeAttribute(node, "export");
        String option = this.getNodeAttribute(node, "optional");
        String version = this.getNodeAttribute(node, "version");
        String match = this.getNodeAttribute(node, "match");
        boolean reexport = export != null && export.toLowerCase().equals("true");
        boolean optional = option != null && option.toLowerCase().equals("true");
        this.match = 0;
        if (match != null) {
            String lmatch = match.toLowerCase();
            if (lmatch.equals("exact")) {
                lmatch = "equivalent";
            }
            int i = 0;
            while (i < IMatchRules.RULE_NAME_TABLE.length) {
                if (lmatch.equals(IMatchRules.RULE_NAME_TABLE[i])) {
                    this.match = i;
                    break;
                }
                ++i;
            }
        }
        this.version = version;
        this.id = id;
        this.reexported = reexport;
        this.optional = optional;
        this.addComments(node);
        this.bindSourceLocation(node, lineTable);
    }

    public void setMatch(int match) throws CoreException {
        this.ensureModelEditable();
        Integer oldValue = new Integer(this.match);
        this.match = match;
        this.firePropertyChanged("match", oldValue, new Integer(match));
    }

    public void setReexported(boolean value) throws CoreException {
        this.ensureModelEditable();
        Boolean oldValue = new Boolean(this.reexported);
        this.reexported = value;
        this.firePropertyChanged("reexported", oldValue, new Boolean(value));
    }

    public void setOptional(boolean value) throws CoreException {
        this.ensureModelEditable();
        Boolean oldValue = new Boolean(this.optional);
        this.optional = value;
        this.firePropertyChanged("optional", oldValue, new Boolean(value));
    }

    public void setVersion(String version) throws CoreException {
        this.ensureModelEditable();
        String oldValue = this.version;
        this.version = version;
        this.firePropertyChanged("version", oldValue, version);
    }

    public void restoreProperty(String name, Object oldValue, Object newValue) throws CoreException {
        if (name.equals("match")) {
            this.setMatch((Integer)newValue);
            return;
        }
        if (name.equals("reexported")) {
            this.setReexported((Boolean)newValue);
            return;
        }
        if (name.equals("optional")) {
            this.setOptional((Boolean)newValue);
            return;
        }
        if (name.equals("version")) {
            this.setVersion(newValue != null ? newValue.toString() : null);
            return;
        }
        super.restoreProperty(name, oldValue, newValue);
    }

    public void write(String indent, PrintWriter writer) {
        this.writeComments(writer);
        writer.print(indent);
        writer.print("<import plugin=\"" + this.getId() + "\"");
        if (this.isReexported()) {
            writer.print(" export=\"true\"");
        }
        if (this.isOptional()) {
            writer.print(" optional=\"true\"");
        }
        if (this.version != null && this.version.length() > 0) {
            writer.print(" version=\"" + this.version + "\"");
        }
        if (this.match != 0) {
            String matchValue = IMatchRules.RULE_NAME_TABLE[this.match];
            writer.print(" match=\"" + matchValue + "\"");
        }
        writer.println("/>");
    }
}

