/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.plugin;

import java.io.PrintWriter;
import java.util.Hashtable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.model.ExtensionPointModel;
import org.eclipse.pde.core.plugin.IFragment;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.internal.core.plugin.IdentifiablePluginObject;
import org.w3c.dom.Node;

public class PluginExtensionPoint
extends IdentifiablePluginObject
implements IPluginExtensionPoint {
    private String schema;
    static final String ID_SEPARATOR = ".";

    public boolean isValid() {
        return this.id != null;
    }

    public String getFullId() {
        IPluginBase pluginBase = this.getPluginModel().getPluginBase();
        String id = pluginBase.getId();
        if (pluginBase instanceof IFragment) {
            id = ((IFragment)pluginBase).getPluginId();
        }
        return String.valueOf(id) + ID_SEPARATOR + this.getId();
    }

    public String getSchema() {
        return this.schema;
    }

    void load(ExtensionPointModel extensionPointModel) {
        this.id = extensionPointModel.getId();
        this.name = extensionPointModel.getName();
        this.schema = extensionPointModel.getSchema();
        int line = extensionPointModel.getStartLine();
        this.range = new int[]{line, line};
    }

    void load(Node node, Hashtable lineTable) {
        this.id = this.getNodeAttribute(node, "id");
        this.name = this.getNodeAttribute(node, "name");
        this.schema = this.getNodeAttribute(node, "schema");
        this.addComments(node);
        this.bindSourceLocation(node, lineTable);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof IPluginExtensionPoint) {
            IPluginExtensionPoint target = (IPluginExtensionPoint)obj;
            if (target.getModel().equals(this.getModel())) {
                return false;
            }
            if (this.stringEqualWithNull(target.getId(), this.getId()) && this.stringEqualWithNull(target.getName(), this.getName()) && this.stringEqualWithNull(target.getSchema(), this.getSchema())) {
                return true;
            }
        }
        return false;
    }

    public void setSchema(String newSchema) throws CoreException {
        this.ensureModelEditable();
        String oldValue = this.schema;
        this.schema = newSchema;
        this.firePropertyChanged("schema", oldValue, this.schema);
    }

    public void restoreProperty(String name, Object oldValue, Object newValue) throws CoreException {
        if (name.equals("schema")) {
            this.setSchema(newValue != null ? newValue.toString() : null);
            return;
        }
        super.restoreProperty(name, oldValue, newValue);
    }

    public void write(String indent, PrintWriter writer) {
        this.writeComments(writer);
        writer.print(indent);
        writer.print("<extension-point");
        if (this.getId() != null) {
            writer.print(" id=\"" + this.getWritableString(this.getId()) + "\"");
        }
        if (this.getName() != null) {
            writer.print(" name=\"" + this.getWritableString(this.getName()) + "\"");
        }
        if (this.getSchema() != null) {
            writer.print(" schema=\"" + this.getSchema() + "\"");
        }
        writer.println("/>");
    }
}

