/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.plugin;

import java.io.PrintWriter;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.model.ConfigurationElementModel;
import org.eclipse.core.runtime.model.ConfigurationPropertyModel;
import org.eclipse.pde.core.plugin.IPluginAttribute;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.internal.core.ischema.ISchema;
import org.eclipse.pde.internal.core.ischema.ISchemaElement;
import org.eclipse.pde.internal.core.plugin.PluginAttribute;
import org.eclipse.pde.internal.core.plugin.PluginExtension;
import org.eclipse.pde.internal.core.plugin.PluginObject;
import org.eclipse.pde.internal.core.plugin.PluginParent;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PluginElement
extends PluginParent
implements IPluginElement {
    private transient ISchemaElement elementInfo;
    private String text;
    static final String ATTRIBUTE_SHIFT = "      ";
    static final String ELEMENT_SHIFT = "   ";
    private Hashtable attributes = new Hashtable();

    public PluginElement() {
    }

    PluginElement(PluginElement element) {
        this.setModel(element.getModel());
        this.setParent(element.getParent());
        this.name = element.getName();
        IPluginAttribute[] atts = element.getAttributes();
        int i = 0;
        while (i < atts.length) {
            PluginAttribute att = (PluginAttribute)atts[i];
            this.attributes.put(att.getName(), att.clone());
            ++i;
        }
        this.text = element.getText();
        this.elementInfo = element.getElementInfo();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof IPluginElement) {
            IPluginElement target = (IPluginElement)obj;
            if (target.getModel().equals(this.getModel())) {
                return false;
            }
            if (target.getAttributeCount() != this.getAttributeCount()) {
                return false;
            }
            IPluginAttribute[] tatts = target.getAttributes();
            int i = 0;
            while (i < tatts.length) {
                IPluginAttribute tatt = tatts[i];
                if (!tatt.equals(this.attributes.get(tatt.getName()))) {
                    return false;
                }
                ++i;
            }
            return super.equals(obj);
        }
        return false;
    }

    public IPluginElement createCopy() {
        return new PluginElement(this);
    }

    public IPluginAttribute getAttribute(String name) {
        return (IPluginAttribute)this.attributes.get(name);
    }

    public IPluginAttribute[] getAttributes() {
        Collection values = this.attributes.values();
        IPluginAttribute[] result = new IPluginAttribute[values.size()];
        return values.toArray(result);
    }

    public int getAttributeCount() {
        return this.attributes.size();
    }

    public ISchemaElement getElementInfo() {
        ISchema schema;
        if (this.elementInfo != null && (schema = this.elementInfo.getSchema()).isDisposed()) {
            this.elementInfo = null;
        }
        if (this.elementInfo == null) {
            PluginExtension extension;
            ISchema schema2;
            IPluginObject parent = this.getParent();
            while (parent != null && !(parent instanceof IPluginExtension)) {
                parent = parent.getParent();
            }
            if (parent != null && (schema2 = (extension = (PluginExtension)parent).getSchema()) != null) {
                this.elementInfo = schema2.findElement(this.getName());
            }
        }
        return this.elementInfo;
    }

    public String getText() {
        return this.text;
    }

    void load(ConfigurationElementModel elementModel) {
        this.name = elementModel.getName();
        ConfigurationPropertyModel[] attributes = elementModel.getProperties();
        if (attributes != null) {
            int i = 0;
            while (i < attributes.length) {
                ConfigurationPropertyModel attribute = attributes[i];
                IPluginAttribute att = this.getModel().getFactory().createAttribute(this);
                ((PluginAttribute)att).load(attribute);
                this.attributes.put(attribute.getName(), att);
                ++i;
            }
        }
        this.text = elementModel.getValue();
        ConfigurationElementModel[] children = elementModel.getSubElements();
        if (children != null) {
            int i = 0;
            while (i < children.length) {
                ConfigurationElementModel child = children[i];
                PluginElement childElement = new PluginElement();
                childElement.setModel(this.getModel());
                this.children.add(childElement);
                childElement.setParent(this);
                childElement.load(child);
                ++i;
            }
        }
        int line = elementModel.getStartLine();
        this.range = new int[]{line, line};
    }

    public void reconnect() {
        super.reconnect();
        this.reconnectAttributes();
    }

    private void reconnectAttributes() {
        Enumeration enumeration = this.attributes.elements();
        while (enumeration.hasMoreElements()) {
            PluginAttribute att = (PluginAttribute)enumeration.nextElement();
            att.setModel(this.getModel());
            att.setParent(this);
            att.setInTheModel(true);
        }
    }

    void load(Node node, Hashtable lineTable) {
        this.name = node.getNodeName();
        NamedNodeMap attributes = node.getAttributes();
        this.bindSourceLocation(node, lineTable);
        int i = 0;
        while (i < attributes.getLength()) {
            Node attribute = attributes.item(i);
            IPluginAttribute att = this.getModel().getFactory().createAttribute(this);
            ((PluginAttribute)att).load(attribute, lineTable);
            ((PluginAttribute)att).setInTheModel(true);
            this.attributes.put(attribute.getNodeName(), att);
            ++i;
        }
        NodeList children = node.getChildNodes();
        int i2 = 0;
        while (i2 < children.getLength()) {
            Node child = children.item(i2);
            if (child.getNodeType() == 1) {
                PluginElement childElement = new PluginElement();
                childElement.setModel(this.getModel());
                childElement.setInTheModel(true);
                this.children.add(childElement);
                childElement.setParent(this);
                childElement.load(child, lineTable);
            } else if (child.getNodeType() == 3 && child.getNodeValue() != null) {
                String text = child.getNodeValue();
                if (PluginObject.isNotEmpty(text = text.trim())) {
                    this.text = text;
                }
            }
            ++i2;
        }
        this.addComments(node);
    }

    public void removeAttribute(String name) throws CoreException {
        this.ensureModelEditable();
        PluginAttribute att = (PluginAttribute)this.attributes.remove(name);
        String oldValue = att.getValue();
        if (att != null) {
            att.setInTheModel(false);
        }
        this.firePropertyChanged("attribute", oldValue, null);
    }

    public void replaceAttributes(Hashtable newAttributes) throws CoreException {
        this.ensureModelEditable();
        Hashtable oldValue = this.attributes;
        this.setAttributesInTheModel(this.attributes, false);
        this.attributes = newAttributes;
        this.setAttributesInTheModel(newAttributes, true);
        this.firePropertyChanged("attributes", oldValue, this.attributes);
    }

    private void setAttributesInTheModel(Hashtable table, boolean value) {
        if (table != null) {
            Enumeration enumeration = table.elements();
            while (enumeration.hasMoreElements()) {
                PluginAttribute att = (PluginAttribute)enumeration.nextElement();
                att.setInTheModel(value);
            }
        }
    }

    public void setAttribute(String name, String value) throws CoreException {
        this.ensureModelEditable();
        if (value == null) {
            this.removeAttribute(name);
            return;
        }
        IPluginAttribute attribute = this.getAttribute(name);
        if (attribute == null) {
            attribute = this.getModel().getFactory().createAttribute(this);
            attribute.setName(name);
            this.attributes.put(name, attribute);
            ((PluginAttribute)attribute).setInTheModel(true);
        }
        attribute.setValue(value);
    }

    public void restoreProperty(String name, Object oldValue, Object newValue) throws CoreException {
        super.restoreProperty(name, oldValue, newValue);
    }

    public void setElementInfo(ISchemaElement newElementInfo) {
        this.elementInfo = newElementInfo;
        if (this.elementInfo == null) {
            Enumeration atts = this.attributes.elements();
            while (atts.hasMoreElements()) {
                PluginAttribute att = (PluginAttribute)atts.nextElement();
                att.setAttributeInfo(null);
            }
        }
    }

    public void setText(String newText) throws CoreException {
        this.ensureModelEditable();
        String oldValue = this.text;
        this.text = newText;
        this.firePropertyChanged("text", oldValue, this.text);
    }

    public void write(String indent, PrintWriter writer) {
        this.writeComments(writer);
        writer.print(indent);
        writer.print("<" + this.getName());
        String newIndent = String.valueOf(indent) + ATTRIBUTE_SHIFT;
        if (!this.attributes.isEmpty()) {
            writer.println();
            Iterator iter = this.attributes.values().iterator();
            while (iter.hasNext()) {
                IPluginAttribute attribute = (IPluginAttribute)iter.next();
                attribute.write(newIndent, writer);
                if (!iter.hasNext()) continue;
                writer.println();
            }
        }
        writer.println(">");
        newIndent = String.valueOf(indent) + ELEMENT_SHIFT;
        IPluginObject[] children = this.getChildren();
        int i = 0;
        while (i < children.length) {
            IPluginElement element = (IPluginElement)children[i];
            element.write(newIndent, writer);
            ++i;
        }
        if (this.getText() != null) {
            writer.println(String.valueOf(newIndent) + this.getWritableString(this.getText()));
        }
        writer.println(String.valueOf(indent) + "</" + this.getName() + ">");
    }
}

