/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.plugin;

import java.util.ArrayList;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.internal.core.plugin.DocumentModel;
import org.eclipse.pde.internal.core.plugin.IDocumentNode;
import org.eclipse.pde.internal.core.plugin.ISourceRange;
import org.w3c.dom.Node;

public class PluginDocumentNode
implements IDocumentNode {
    private IDocumentNode fParentNode;
    private Node fDOMNode;
    private IPluginObject fPluginObjectNode;
    private ArrayList fChildrenList = new ArrayList();
    private boolean fIsErrorNode = false;

    public PluginDocumentNode(Node domNode) {
        this.fDOMNode = domNode;
    }

    public void addChild(IDocumentNode child) {
        this.fChildrenList.add(child);
    }

    public String getText() {
        String result = null;
        if (this.fPluginObjectNode != null) {
            result = this.fPluginObjectNode.getName();
        } else if (this.fDOMNode != null) {
            result = this.fDOMNode.getNodeName();
        }
        return result;
    }

    public IPluginObject getPluginObjectNode() {
        return this.fPluginObjectNode;
    }

    public void setPluginObjectNode(IPluginObject pluginObject) {
        this.fPluginObjectNode = pluginObject;
    }

    public IDocumentNode[] getChildren() {
        IPluginObject object = this.getPluginObjectNode();
        if (object instanceof IPluginImport || object instanceof IPluginExtension || object instanceof IPluginLibrary) {
            return new IDocumentNode[0];
        }
        return this.fChildrenList.toArray(new IDocumentNode[this.fChildrenList.size()]);
    }

    public IDocumentNode getParent() {
        return this.fParentNode;
    }

    public void setParent(IDocumentNode parentNode) {
        this.fParentNode = parentNode;
    }

    public Node getDOMNode() {
        return this.fDOMNode;
    }

    private DocumentModel findDocumentModel() {
        IDocumentNode node = this.fParentNode;
        while (node != null) {
            if (node instanceof DocumentModel) {
                return (DocumentModel)node;
            }
            node = node.getParent();
        }
        return null;
    }

    public ISourceRange getSourceRange() {
        DocumentModel model = this.findDocumentModel();
        if (model != null) {
            return model.getSourceRange(this);
        }
        return null;
    }

    public void setIsErrorNode(boolean isErrorNode) {
        this.fIsErrorNode = isErrorNode;
    }

    public boolean isErrorNode() {
        return this.fIsErrorNode;
    }
}

