/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.plugin;

import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.model.LibraryModel;
import org.eclipse.core.runtime.model.PluginModel;
import org.eclipse.core.runtime.model.PluginPrerequisiteModel;
import org.eclipse.pde.core.osgi.bundle.IBundle;
import org.eclipse.pde.core.plugin.IExtensions;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.internal.core.plugin.AbstractExtensions;
import org.eclipse.pde.internal.core.plugin.PluginImport;
import org.eclipse.pde.internal.core.plugin.PluginLibrary;
import org.w3c.dom.Comment;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class PluginBase
extends AbstractExtensions
implements IPluginBase {
    private Vector libraries = new Vector();
    private Vector imports = new Vector();
    protected Vector requiresComments;
    protected Vector endComments;
    private String providerName;
    private String id;
    private String version;
    private String schemaVersion;
    private boolean valid;

    public String getSchemaVersion() {
        return this.schemaVersion;
    }

    public void setSchemaVersion(String schemaVersion) throws CoreException {
        this.ensureModelEditable();
        String oldValue = this.schemaVersion;
        this.schemaVersion = schemaVersion;
        this.firePropertyChanged("schema-version", oldValue, schemaVersion);
    }

    public void add(IPluginLibrary library) throws CoreException {
        this.ensureModelEditable();
        this.libraries.addElement(library);
        ((PluginLibrary)library).setInTheModel(true);
        ((PluginLibrary)library).setParent(this);
        this.fireStructureChanged(library, 1);
    }

    public void add(IPluginImport iimport) throws CoreException {
        this.ensureModelEditable();
        ((PluginImport)iimport).setInTheModel(true);
        ((PluginImport)iimport).setParent(this);
        this.imports.addElement(iimport);
        this.fireStructureChanged(iimport, 1);
    }

    public IPluginLibrary[] getLibraries() {
        Object[] result = new IPluginLibrary[this.libraries.size()];
        this.libraries.copyInto(result);
        return result;
    }

    public IPluginImport[] getImports() {
        Object[] result = new IPluginImport[this.imports.size()];
        this.imports.copyInto(result);
        return result;
    }

    public IPluginBase getPluginBase() {
        return this;
    }

    public String getProviderName() {
        return this.providerName;
    }

    public String getVersion() {
        return this.version;
    }

    public String getId() {
        return this.id;
    }

    void load(PluginModel pd) {
        this.id = pd.getId();
        this.name = pd.getName();
        this.providerName = pd.getProviderName();
        this.version = pd.getVersion();
        this.schemaVersion = pd.getSchemaVersion();
        this.loadRuntime(pd.getRuntime());
        this.loadExtensions(pd.getDeclaredExtensions());
        this.loadExtensionPoints(pd.getDeclaredExtensionPoints());
        this.loadImports(pd.getRequires());
    }

    public void restoreProperty(String name, Object oldValue, Object newValue) throws CoreException {
        if (name.equals("id")) {
            this.setId(newValue != null ? newValue.toString() : null);
            return;
        }
        if (name.equals("version")) {
            this.setVersion(newValue != null ? newValue.toString() : null);
            return;
        }
        if (name.equals("provider")) {
            this.setProviderName(newValue != null ? newValue.toString() : null);
            return;
        }
        if (name.equals("library_order")) {
            this.swap((IPluginLibrary)oldValue, (IPluginLibrary)newValue);
            return;
        }
        if (name.equals("schema-version")) {
            this.setSchemaVersion(newValue != null ? newValue.toString() : null);
            return;
        }
        super.restoreProperty(name, oldValue, newValue);
    }

    public void load(IPluginBase srcPluginBase) {
        PluginBase base = (PluginBase)srcPluginBase;
        this.range = base.range;
        this.id = base.id;
        this.name = base.name;
        this.providerName = base.providerName;
        this.version = base.version;
        this.schemaVersion = base.schemaVersion;
        this.leadComments = base.leadComments;
        this.requiresComments = base.requiresComments;
        this.endComments = base.endComments;
        super.load(srcPluginBase);
        this.addArrayToVector(this.imports, srcPluginBase.getImports());
        this.addArrayToVector(this.libraries, srcPluginBase.getLibraries());
        this.valid = this.hasRequiredAttributes();
    }

    void load(Node node, Hashtable lineTable) {
    }

    void load(Node node, String schemaVersion, Hashtable lineTable) {
        this.bindSourceLocation(node, lineTable);
        this.schemaVersion = schemaVersion;
        this.id = this.getNodeAttribute(node, "id");
        this.name = this.getNodeAttribute(node, "name");
        this.providerName = this.getNodeAttribute(node, "provider-name");
        if (this.providerName == null) {
            this.providerName = this.getNodeAttribute(node, "vendor");
        }
        this.version = this.getNodeAttribute(node, "version");
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeType() == 1) {
                this.processChild(child, lineTable);
            }
            ++i;
        }
        this.addEndComments(node);
        this.valid = this.hasRequiredAttributes();
    }

    private void addEndComments(Node node) {
        Node prev = node.getLastChild();
        while (prev != null) {
            if (prev.getNodeType() != 3) {
                if (!(prev instanceof Comment)) break;
                String comment = prev.getNodeValue();
                if (this.endComments == null) {
                    this.endComments = new Vector();
                }
                this.endComments.add(0, comment);
            }
            prev = prev.getPreviousSibling();
        }
    }

    void loadRuntime(LibraryModel[] libraryModels) {
        if (libraryModels == null) {
            return;
        }
        int i = 0;
        while (i < libraryModels.length) {
            PluginLibrary library = new PluginLibrary();
            library.setModel(this.getModel());
            library.setInTheModel(true);
            library.setParent(this);
            this.libraries.add(library);
            library.load(libraryModels[i]);
            ++i;
        }
    }

    void loadRuntime(Node node, Hashtable lineTable) {
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeType() == 1 && child.getNodeName().toLowerCase().equals("library")) {
                PluginLibrary library = new PluginLibrary();
                library.setModel(this.getModel());
                library.setInTheModel(true);
                library.setParent(this);
                this.libraries.add(library);
                library.load(child, lineTable);
            }
            ++i;
        }
    }

    void loadImports(PluginPrerequisiteModel[] importModels) {
        if (importModels == null) {
            return;
        }
        int i = 0;
        while (i < importModels.length) {
            PluginPrerequisiteModel importModel = importModels[i];
            PluginImport importElement = new PluginImport();
            importElement.setModel(this.getModel());
            importElement.setInTheModel(true);
            importElement.setParent(this);
            this.imports.add(importElement);
            importElement.load(importModel);
            ++i;
        }
    }

    void loadImports(Node node, Hashtable lineTable) {
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeType() == 1 && child.getNodeName().toLowerCase().equals("import")) {
                PluginImport importElement = new PluginImport();
                importElement.setModel(this.getModel());
                importElement.setInTheModel(true);
                importElement.setParent(this);
                this.imports.add(importElement);
                importElement.load(child, lineTable);
            }
            ++i;
        }
    }

    protected void processChild(Node child, Hashtable lineTable) {
        String name = child.getNodeName().toLowerCase();
        if (name.equals("runtime")) {
            this.loadRuntime(child, lineTable);
            this.addComments(child);
        } else if (name.equals("requires")) {
            this.loadImports(child, lineTable);
            this.requiresComments = this.addComments(child, this.requiresComments);
        } else {
            super.processChild(child, lineTable);
        }
    }

    public void remove(IPluginLibrary library) throws CoreException {
        this.ensureModelEditable();
        this.libraries.removeElement(library);
        ((PluginLibrary)library).setInTheModel(false);
        this.fireStructureChanged(library, 2);
    }

    public void remove(IPluginImport iimport) throws CoreException {
        this.ensureModelEditable();
        this.imports.removeElement(iimport);
        ((PluginImport)iimport).setInTheModel(false);
        this.fireStructureChanged(iimport, 2);
    }

    public void reset() {
        this.libraries = new Vector();
        this.imports = new Vector();
        this.requiresComments = null;
        this.providerName = null;
        this.schemaVersion = null;
        this.version = "";
        this.name = "";
        this.id = "";
        if (this.getModel() != null && this.getModel().getUnderlyingResource() != null) {
            this.name = this.id = this.getModel().getUnderlyingResource().getProject().getName();
            this.version = "0.0.0";
        }
        super.reset();
        this.valid = false;
    }

    public void setProviderName(String providerName) throws CoreException {
        this.ensureModelEditable();
        String oldValue = this.providerName;
        this.providerName = providerName;
        this.firePropertyChanged("provider", oldValue, providerName);
    }

    public void setVersion(String newVersion) throws CoreException {
        this.ensureModelEditable();
        String oldValue = this.version;
        this.version = newVersion;
        this.firePropertyChanged("version", oldValue, this.version);
    }

    public void setId(String newId) throws CoreException {
        this.ensureModelEditable();
        String oldValue = this.id;
        this.id = newId;
        this.firePropertyChanged("id", oldValue, this.id);
    }

    public void internalSetVersion(String newVersion) {
        this.version = newVersion;
    }

    public void swap(IPluginLibrary l1, IPluginLibrary l2) throws CoreException {
        this.ensureModelEditable();
        int index1 = this.libraries.indexOf(l1);
        int index2 = this.libraries.indexOf(l2);
        if (index1 == -1 || index2 == -1) {
            this.throwCoreException("Libraries not in the model");
        }
        this.libraries.setElementAt(l1, index2);
        this.libraries.setElementAt(l2, index1);
        this.firePropertyChanged(this, "library_order", l1, l2);
    }

    protected void writeChildren(String indent, String tag, Object[] children, PrintWriter writer) {
        if (tag.equals("runtime")) {
            this.writeComments(writer);
        }
        super.writeChildren(indent, tag, children, writer);
    }

    public boolean isValid() {
        return this.valid;
    }

    protected boolean hasRequiredAttributes() {
        if (this.name == null) {
            return false;
        }
        if (this.id == null) {
            return false;
        }
        if (this.version == null) {
            return false;
        }
        int i = 0;
        while (i < this.libraries.size()) {
            IPluginLibrary library = (IPluginLibrary)this.libraries.get(i);
            if (!library.isValid()) {
                return false;
            }
            ++i;
        }
        i = 0;
        while (i < this.imports.size()) {
            IPluginImport iimport = (IPluginImport)this.imports.get(i);
            if (!iimport.isValid()) {
                return false;
            }
            ++i;
        }
        return super.hasRequiredAttributes();
    }

    public void load(IBundle bundle, IExtensions extensions) {
        this.load(extensions);
        this.valid = this.hasRequiredAttributes();
    }
}

