/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.plugin;

import java.io.PrintWriter;
import java.util.Hashtable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.model.ConfigurationPropertyModel;
import org.eclipse.pde.core.ISourceObject;
import org.eclipse.pde.core.plugin.IPluginAttribute;
import org.eclipse.pde.internal.core.ischema.ISchema;
import org.eclipse.pde.internal.core.ischema.ISchemaAttribute;
import org.eclipse.pde.internal.core.ischema.ISchemaElement;
import org.eclipse.pde.internal.core.plugin.AttributeChangedEvent;
import org.eclipse.pde.internal.core.plugin.PluginElement;
import org.eclipse.pde.internal.core.plugin.PluginObject;
import org.w3c.dom.Node;

public class PluginAttribute
extends PluginObject
implements IPluginAttribute {
    private String value;
    private transient ISchemaAttribute attributeInfo;

    public PluginAttribute() {
    }

    PluginAttribute(IPluginAttribute attribute) {
        this.setModel(attribute.getModel());
        this.setParent(attribute.getParent());
        this.name = attribute.getName();
        this.value = attribute.getValue();
        this.attributeInfo = ((PluginAttribute)attribute).getAttributeInfo();
    }

    public Object clone() {
        return new PluginAttribute(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof IPluginAttribute) {
            IPluginAttribute target = (IPluginAttribute)obj;
            if (target.getModel().equals(this.getModel())) {
                return false;
            }
            if (this.stringEqualWithNull(this.getName(), target.getName()) && this.stringEqualWithNull(this.getValue(), target.getValue())) {
                return true;
            }
        }
        return false;
    }

    public ISchemaAttribute getAttributeInfo() {
        PluginElement element;
        ISchemaElement elementInfo;
        ISchema schema;
        if (this.attributeInfo != null && (schema = this.attributeInfo.getSchema()).isDisposed()) {
            this.attributeInfo = null;
        }
        if (this.attributeInfo == null && (elementInfo = (element = (PluginElement)this.getParent()).getElementInfo()) != null) {
            this.attributeInfo = elementInfo.getAttribute(this.getName());
        }
        return this.attributeInfo;
    }

    public String getValue() {
        return this.value;
    }

    void load(ConfigurationPropertyModel attributeModel) {
        this.name = attributeModel.getName();
        this.value = attributeModel.getValue();
    }

    void load(Node node, Hashtable lineTable) {
        this.name = node.getNodeName();
        this.value = node.getNodeValue();
        if (this.getParent() instanceof ISourceObject) {
            ISourceObject pobj = (ISourceObject)((Object)this.getParent());
            int start = pobj.getStartLine();
            int stop = pobj.getStopLine();
            if (start != -1 && stop != -1) {
                this.range = new int[]{start, stop};
            }
        }
    }

    public void setAttributeInfo(ISchemaAttribute newAttributeInfo) {
        this.attributeInfo = newAttributeInfo;
    }

    public void setValue(String newValue) throws CoreException {
        this.ensureModelEditable();
        String oldValue = this.value;
        this.value = newValue;
        AttributeChangedEvent e = new AttributeChangedEvent((Object)this.getParent(), this, oldValue, newValue);
        this.fireModelChanged(e);
    }

    public void write(String indent, PrintWriter writer) {
        if (this.value == null) {
            return;
        }
        writer.print(indent);
        writer.print(String.valueOf(this.getName()) + "=\"" + this.getWritableString(this.value) + "\"");
    }
}

