/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.plugin;

import java.io.PrintWriter;
import java.util.Hashtable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.model.PluginDescriptorModel;
import org.eclipse.core.runtime.model.PluginModel;
import org.eclipse.pde.core.plugin.IPlugin;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.internal.core.plugin.PluginBase;
import org.w3c.dom.Node;

public class Plugin
extends PluginBase
implements IPlugin {
    private String className;

    public String getClassName() {
        return this.className;
    }

    public IPlugin getPlugin() {
        return this;
    }

    void load(PluginModel pm) {
        PluginDescriptorModel pd = (PluginDescriptorModel)pm;
        this.className = pd.getPluginClass();
        super.load(pm);
    }

    public void load(IPluginBase srcPluginBase) {
        PluginBase base = (PluginBase)srcPluginBase;
        this.load(base);
    }

    void load(PluginBase srcPluginBase) {
        this.className = ((Plugin)srcPluginBase).className;
        super.load(srcPluginBase);
    }

    void load(Node node, String schemaVersion, Hashtable lineTable) {
        this.className = this.getNodeAttribute(node, "class");
        super.load(node, schemaVersion, lineTable);
    }

    public void reset() {
        this.className = null;
        super.reset();
    }

    public void setClassName(String newClassName) throws CoreException {
        this.ensureModelEditable();
        String oldValue = this.className;
        this.className = newClassName;
        this.firePropertyChanged("class_name", oldValue, this.className);
    }

    public void restoreProperty(String name, Object oldValue, Object newValue) throws CoreException {
        if (name.equals("class_name")) {
            this.setClassName(newValue != null ? newValue.toString() : null);
            return;
        }
        super.restoreProperty(name, oldValue, newValue);
    }

    public void write(String indent, PrintWriter writer) {
        writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        if (this.getSchemaVersion() != null) {
            writer.print("<?eclipse version=\"");
            writer.print(this.getSchemaVersion());
            writer.println("\"?>");
        }
        writer.print("<plugin");
        if (this.getId() != null) {
            writer.println();
            writer.print("   id=\"" + this.getId() + "\"");
        }
        if (this.getName() != null) {
            writer.println();
            writer.print("   name=\"" + this.getWritableString(this.getName()) + "\"");
        }
        if (this.getVersion() != null) {
            writer.println();
            writer.print("   version=\"" + this.getVersion() + "\"");
        }
        if (this.getProviderName() != null) {
            writer.println();
            writer.print("   provider-name=\"" + this.getWritableString(this.getProviderName()) + "\"");
        }
        if (this.getClassName() != null) {
            writer.println();
            writer.print("   class=\"" + this.getClassName() + "\"");
        }
        writer.println(">");
        writer.println();
        String firstIndent = "   ";
        Object[] children = this.getLibraries();
        this.writeChildren(firstIndent, "runtime", children, writer);
        children = this.getImports();
        if (children.length > 0) {
            this.writeComments(writer, this.requiresComments);
            this.writeChildren(firstIndent, "requires", children, writer);
            writer.println();
        }
        if ((children = this.getExtensionPoints()).length > 0) {
            writer.println();
        }
        int i = 0;
        while (i < children.length) {
            ((IPluginExtensionPoint)children[i]).write(firstIndent, writer);
            ++i;
        }
        children = this.getExtensions();
        if (children.length > 0) {
            writer.println();
        }
        i = 0;
        while (i < children.length) {
            ((IPluginExtension)children[i]).write(firstIndent, writer);
            ++i;
        }
        writer.println();
        this.writeComments(writer, this.endComments);
        writer.println("</plugin>");
    }
}

