/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.plugin;

import java.io.PrintWriter;
import java.util.Hashtable;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.internal.core.plugin.AbstractExtensions;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Extensions
extends AbstractExtensions {
    private boolean valid;

    void load(Extensions srcPluginBase) {
        this.range = srcPluginBase.range;
        super.load(srcPluginBase);
        this.valid = this.hasRequiredAttributes();
    }

    public void load(IPluginBase srcPluginBase) {
        this.load(srcPluginBase);
    }

    void load(Node node, Hashtable lineTable) {
        this.bindSourceLocationOrig(node, lineTable);
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeType() == 1) {
                this.processChild(child, lineTable);
            }
            ++i;
        }
        this.valid = this.hasRequiredAttributes();
    }

    public void reset() {
        super.reset();
        this.valid = false;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void write(String indent, PrintWriter writer) {
        writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        writer.print("<bundle>");
        writer.println();
        String firstIndent = "   ";
        IPluginObject[] children = this.getExtensionPoints();
        if (children.length > 0) {
            writer.println();
        }
        int i = 0;
        while (i < children.length) {
            children[i].write(firstIndent, writer);
            ++i;
        }
        children = this.getExtensions();
        if (children.length > 0) {
            writer.println();
        }
        i = 0;
        while (i < children.length) {
            ((IPluginExtension)children[i]).write(firstIndent, writer);
            ++i;
        }
        writer.println();
        writer.println("</bundle>");
    }
}

