/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.plugin;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.pde.internal.core.plugin.IDocumentNode;
import org.eclipse.pde.internal.core.plugin.ISourceRange;
import org.eclipse.pde.internal.core.plugin.PluginDocumentNode;
import org.eclipse.pde.internal.core.plugin.SourceRange;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class DocumentModelHandler
extends DefaultHandler
implements LexicalHandler {
    private org.w3c.dom.Document fDocument;
    private IDocument fTextDocument;
    private FindReplaceDocumentAdapter fFindReplaceAdapter;
    private Locator fLocator;
    private Hashtable fLineTable;
    private Element fRootElement;
    private IDocumentNode fModelRoot;
    private String fSchemaVersion;
    private Stack fDocumentNodeStack = new Stack();

    public DocumentModelHandler(InputStream stream) {
        try {
            this.createTextDocument(stream);
        }
        catch (Exception exception) {}
        this.fLineTable = new Hashtable();
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        Element element = this.createDOMElement(uri, localName, qName, attributes);
        PluginDocumentNode node = new PluginDocumentNode(element);
        if (this.fRootElement == null || this.fDocumentNodeStack.isEmpty()) {
            this.fRootElement = element;
            this.fModelRoot = node;
            this.fDocument.appendChild(this.fRootElement);
        } else {
            PluginDocumentNode parent = (PluginDocumentNode)this.fDocumentNodeStack.peek();
            parent.getDOMNode().appendChild(element);
            parent.addChild(node);
            node.setParent(parent);
        }
        this.fLineTable.put(node, this.createRange(qName));
        this.fDocumentNodeStack.push(node);
    }

    private Element createDOMElement(String uri, String localName, String qName, Attributes attributes) {
        Element element = this.fDocument.createElement(qName);
        int i = 0;
        while (i < attributes.getLength()) {
            element.setAttribute(attributes.getQName(i), attributes.getValue(i));
            ++i;
        }
        return element;
    }

    private ISourceRange createRange(String name) {
        SourceRange range = new SourceRange();
        try {
            int offset = this.getStartOffset(name);
            range.setOffset(offset);
            range.setStartLine(this.fTextDocument.getLineOfOffset(offset) + 1);
        }
        catch (BadLocationException badLocationException) {}
        return range;
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        ISourceRange range = (ISourceRange)this.fLineTable.get(this.fDocumentNodeStack.pop());
        int line = this.fLocator.getLineNumber();
        range.setEndLine(line);
        try {
            range.setLength(this.fTextDocument.getLineOffset(line) - range.getOffset());
        }
        catch (BadLocationException badLocationException) {}
    }

    public void setDocumentLocator(Locator locator) {
        this.fLocator = locator;
    }

    public void startDocument() throws SAXException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            this.fDocument = factory.newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException parserConfigurationException) {}
    }

    public void processingInstruction(String target, String data) throws SAXException {
        ProcessingInstruction instruction = this.fDocument.createProcessingInstruction(target, data);
        if ("eclipse".equals(target)) {
            this.fSchemaVersion = "3.0";
        }
        this.fDocument.appendChild(instruction);
    }

    public void characters(char[] characters, int start, int length) throws SAXException {
        StringBuffer buff = new StringBuffer();
        int i = 0;
        while (i < length) {
            buff.append(characters[start + i]);
            ++i;
        }
        if (buff.length() > 0) {
            Text text = this.fDocument.createTextNode(buff.toString());
            if (this.fRootElement == null) {
                this.fDocument.appendChild(text);
            } else {
                PluginDocumentNode node = (PluginDocumentNode)this.fDocumentNodeStack.peek();
                node.getDOMNode().appendChild(text);
            }
        }
    }

    public Node getDocumentElement() {
        if (this.fDocument != null && this.fDocument.getDocumentElement() != null) {
            this.fDocument.getDocumentElement().normalize();
            return this.fDocument.getDocumentElement();
        }
        return null;
    }

    public org.w3c.dom.Document getDocument() {
        return this.fDocument;
    }

    public Hashtable getLineTable() {
        return this.fLineTable;
    }

    private void createTextDocument(InputStream stream) {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            StringBuffer buffer = new StringBuffer();
            while (reader.ready()) {
                buffer.append((char)reader.read());
            }
            this.fTextDocument = new Document(buffer.toString());
            this.fFindReplaceAdapter = new FindReplaceDocumentAdapter(this.fTextDocument);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {}
    }

    private int getStartOffset(String elementName) throws BadLocationException {
        int lineNumber = this.fLocator.getLineNumber();
        int colNumber = this.fLocator.getColumnNumber();
        if (colNumber < 0) {
            colNumber = this.getLastCharColumn(lineNumber);
        }
        int offset = this.fTextDocument.getLineOffset(lineNumber - 1) + colNumber - 1;
        IRegion region = this.fFindReplaceAdapter.search(offset, "<" + elementName, false, false, false, false);
        return region.getOffset();
    }

    private int getLastCharColumn(int line) throws BadLocationException {
        String lineDelimiter = this.fTextDocument.getLineDelimiter(line - 1);
        int lineDelimiterLength = lineDelimiter != null ? lineDelimiter.length() : 0;
        return this.fTextDocument.getLineLength(line - 1) - lineDelimiterLength;
    }

    public void endCDATA() throws SAXException {
    }

    public void endDTD() throws SAXException {
    }

    public void startCDATA() throws SAXException {
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < length) {
            buffer.append(ch[start + i]);
            ++i;
        }
        Comment comment = this.fDocument.createComment(buffer.toString());
        if (this.fRootElement == null || this.fDocumentNodeStack.isEmpty()) {
            this.fDocument.appendChild(comment);
        } else {
            PluginDocumentNode node = (PluginDocumentNode)this.fDocumentNodeStack.peek();
            node.getDOMNode().appendChild(comment);
        }
    }

    public void endEntity(String name) throws SAXException {
    }

    public void startEntity(String name) throws SAXException {
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
    }

    public void reset(InputStream stream) {
        this.createTextDocument(stream);
        this.fRootElement = null;
        this.fModelRoot = null;
        this.fSchemaVersion = null;
        this.fDocumentNodeStack.clear();
        this.fLineTable.clear();
    }

    public String getSchemaVersion() {
        return this.fSchemaVersion;
    }

    public IDocumentNode getModelRoot() {
        return this.fModelRoot;
    }

    public void fatalError(SAXParseException e) throws SAXException {
        this.generateErrorElementHierarchy();
    }

    private void generateErrorElementHierarchy() {
        while (!this.fDocumentNodeStack.isEmpty()) {
            ((PluginDocumentNode)this.fDocumentNodeStack.pop()).setIsErrorNode(true);
        }
    }

    public void error(SAXParseException e) throws SAXException {
        this.generateErrorElementHierarchy();
    }

    public String getText() {
        return this.fTextDocument == null ? "" : this.fTextDocument.get();
    }
}

