/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.plugin;

import java.io.InputStream;
import java.io.StringReader;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.core.IEditable;
import org.eclipse.pde.core.ModelChangedEvent;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.plugin.AbstractModelUpdateStrategy;
import org.eclipse.pde.internal.core.plugin.AbstractPluginModelBase;
import org.eclipse.pde.internal.core.plugin.DocumentModelChangeEvent;
import org.eclipse.pde.internal.core.plugin.DocumentModelHandler;
import org.eclipse.pde.internal.core.plugin.IDocumentNode;
import org.eclipse.pde.internal.core.plugin.ISourceRange;
import org.eclipse.pde.internal.core.plugin.PluginBase;
import org.eclipse.pde.internal.core.plugin.PluginDocumentNode;
import org.eclipse.pde.internal.core.plugin.TicketManager;
import org.eclipse.pde.internal.core.plugin.XMLCore;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class DocumentModel
implements IDocumentNode {
    private SAXParser fParser;
    private DocumentModelHandler fHandler;
    private TicketManager fTicketManager = new TicketManager();
    private IDocumentNode fRootNode;
    private AbstractPluginModelBase fPluginModelBase;
    private Map fContentLineTable;

    public DocumentModel(AbstractPluginModelBase pluginModelBase) {
        this.fPluginModelBase = pluginModelBase;
    }

    public void setRootNode(IDocumentNode root) {
        this.fRootNode = root;
        if (this.fRootNode != null) {
            this.fRootNode.setParent(this);
        }
    }

    public IDocumentNode getRootNode() {
        return this.fRootNode;
    }

    public IDocumentNode[] getChildren() {
        return new IDocumentNode[]{this.fRootNode};
    }

    public IDocumentNode getParent() {
        return null;
    }

    public void setParent(IDocumentNode parentNode) {
        throw new UnsupportedOperationException();
    }

    public ISourceRange getSourceRange() {
        throw new UnsupportedOperationException();
    }

    public ISourceRange getSourceRange(IDocumentNode node) {
        ISourceRange result = null;
        if (this.fContentLineTable != null) {
            result = (ISourceRange)this.fContentLineTable.get(node);
        }
        return result;
    }

    public TicketManager getTicketManager() {
        return this.fTicketManager;
    }

    public void load(InputStream stream, boolean outOfSync) throws CoreException {
        AbstractPluginModelBase abstractPluginModelBase = this.fPluginModelBase;
        synchronized (abstractPluginModelBase) {
            this.getTicketManager().buyTicket();
            this.load(stream, outOfSync, true);
        }
    }

    public void reload(InputStream stream, boolean outOfSync) throws CoreException {
        AbstractPluginModelBase abstractPluginModelBase = this.fPluginModelBase;
        synchronized (abstractPluginModelBase) {
            this.load(stream, outOfSync, false);
        }
    }

    private void load(InputStream stream, boolean outOfSync, boolean initialRun) throws CoreException {
        AbstractPluginModelBase abstractPluginModelBase = this.fPluginModelBase;
        synchronized (abstractPluginModelBase) {
            AbstractModelUpdateStrategy updateStrategy = this.reconcile(stream, outOfSync, initialRun);
            if (updateStrategy != null) {
                updateStrategy.run();
                if (!updateStrategy.isSuccessful()) {
                    this.fPluginModelBase.throwParseErrorsException(null);
                }
            }
        }
    }

    public AbstractModelUpdateStrategy reconcile(InputStream stream, final boolean outOfSync, final boolean initialRun) {
        AbstractPluginModelBase abstractPluginModelBase = this.fPluginModelBase;
        synchronized (abstractPluginModelBase) {
            if (!this.getTicketManager().isTicketValid()) {
                this.getTicketManager().removeTicket();
                return null;
            }
            boolean success = true;
            try {
                if (this.fParser == null) {
                    this.fParser = SAXParserFactory.newInstance().newSAXParser();
                }
                if (this.fHandler == null) {
                    this.fHandler = new DocumentModelHandler(stream);
                } else {
                    this.fHandler.reset(stream);
                }
                this.fParser.setProperty("http://xml.org/sax/properties/lexical-handler", this.fHandler);
                this.fParser.parse(new InputSource(new StringReader(this.fHandler.getText())), (DefaultHandler)this.fHandler);
            }
            catch (Exception exception) {
                success = false;
            }
            final PluginBase tmpPluginBase = (PluginBase)this.fPluginModelBase.createPluginBase();
            tmpPluginBase.setModel(this.fPluginModelBase);
            Node documentElement = this.fHandler.getDocumentElement();
            if (documentElement != null) {
                tmpPluginBase.load(documentElement, this.fHandler.getSchemaVersion(), this.fHandler.getLineTable());
            }
            DocumentModel.load(tmpPluginBase, this.fHandler.getModelRoot());
            AbstractModelUpdateStrategy result = new AbstractModelUpdateStrategy(this, success){

                public void update() {
                    PluginBase pluginBase = ((DocumentModel)DocumentModel.this).fPluginModelBase.pluginBase;
                    if (pluginBase == null) {
                        pluginBase = (PluginBase)DocumentModel.this.fPluginModelBase.createPluginBase();
                        pluginBase.setModel(DocumentModel.this.fPluginModelBase);
                        ((DocumentModel)DocumentModel.this).fPluginModelBase.pluginBase = pluginBase;
                    }
                    pluginBase.reset();
                    if (this.isSuccessful()) {
                        pluginBase.load(tmpPluginBase);
                    }
                    if (!outOfSync) {
                        DocumentModel.this.fPluginModelBase.updateTimeStamp();
                    }
                    if (!initialRun) {
                        DocumentModel.this.fPluginModelBase.fireModelChanged(new ModelChangedEvent(99, new Object[]{pluginBase}, null));
                        if (DocumentModel.this.fPluginModelBase instanceof IEditable && DocumentModel.this.fPluginModelBase.isEditable()) {
                            ((IEditable)((Object)DocumentModel.this.fPluginModelBase)).setDirty(false);
                        }
                    }
                    DocumentModel.this.fPluginModelBase.setLoaded(this.isSuccessful());
                    DocumentModel.this.setRootNode(DocumentModel.this.fHandler.getModelRoot());
                    DocumentModel.this.fContentLineTable = DocumentModel.this.fHandler.getLineTable();
                    XMLCore.getDefault().notifyDocumentModelListeners(new DocumentModelChangeEvent(DocumentModel.this));
                }
            };
            return result;
        }
    }

    static void load(PluginBase tmpPluginBase, IDocumentNode docNode) {
        IDocumentNode docRootNode = docNode;
        if (docRootNode instanceof PluginDocumentNode) {
            PluginDocumentNode pluginDocNode = (PluginDocumentNode)docRootNode;
            pluginDocNode.setPluginObjectNode(tmpPluginBase);
            if (pluginDocNode.getChildren() != null) {
                int iExtension = 0;
                int iExtensionPoint = 0;
                int iImport = 0;
                int iLibrary = 0;
                IDocumentNode[] children = pluginDocNode.getChildren();
                int i = 0;
                while (i < children.length) {
                    if (children[i] instanceof PluginDocumentNode) {
                        PluginDocumentNode currentDocNode = (PluginDocumentNode)children[i];
                        String name = currentDocNode.getDOMNode().getNodeName().toLowerCase();
                        if (name.equals("extension")) {
                            currentDocNode.setPluginObjectNode(tmpPluginBase.getExtensions()[iExtension++]);
                        } else if (name.equals("extension-point")) {
                            currentDocNode.setPluginObjectNode(tmpPluginBase.getExtensionPoints()[iExtensionPoint++]);
                        } else if (name.equals("runtime")) {
                            iLibrary = DocumentModel.processRuntime(tmpPluginBase, currentDocNode, iLibrary);
                        } else if (name.equals("requires")) {
                            iImport = DocumentModel.processRequires(tmpPluginBase, currentDocNode, iImport);
                        }
                    }
                    ++i;
                }
            }
        }
    }

    static int processRuntime(PluginBase pluginBase, PluginDocumentNode docNode, int iLibrary) {
        if (docNode.getChildren() != null) {
            IDocumentNode[] children = docNode.getChildren();
            int i = 0;
            while (i < children.length) {
                PluginDocumentNode currentDocNode;
                String name;
                if (children[i] instanceof PluginDocumentNode && (name = (currentDocNode = (PluginDocumentNode)children[i]).getDOMNode().getNodeName().toLowerCase()).equals("library")) {
                    currentDocNode.setPluginObjectNode(pluginBase.getLibraries()[iLibrary++]);
                }
                ++i;
            }
        }
        return iLibrary;
    }

    static int processRequires(PluginBase pluginBase, PluginDocumentNode docNode, int iImport) {
        if (docNode.getChildren() != null) {
            IDocumentNode[] children = docNode.getChildren();
            int i = 0;
            while (i < children.length) {
                PluginDocumentNode currentDocNode;
                String name;
                if (children[i] instanceof PluginDocumentNode && (name = (currentDocNode = (PluginDocumentNode)children[i]).getDOMNode().getNodeName().toLowerCase()).equals("import")) {
                    currentDocNode.setPluginObjectNode(pluginBase.getImports()[iImport++]);
                }
                ++i;
            }
        }
        return iImport;
    }

    public IPluginModelBase getModel() {
        return this.fPluginModelBase;
    }
}

