/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.plugin;

import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.model.ExtensionModel;
import org.eclipse.core.runtime.model.ExtensionPointModel;
import org.eclipse.core.runtime.model.PluginFragmentModel;
import org.eclipse.core.runtime.model.PluginModel;
import org.eclipse.pde.core.plugin.IExtensions;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.internal.core.plugin.PluginExtension;
import org.eclipse.pde.internal.core.plugin.PluginExtensionPoint;
import org.eclipse.pde.internal.core.plugin.PluginObject;
import org.w3c.dom.Node;

public abstract class AbstractExtensions
extends PluginObject
implements IExtensions {
    private Vector extensions = new Vector();
    private Vector extensionPoints = new Vector();

    public void add(IPluginExtension extension) throws CoreException {
        this.ensureModelEditable();
        this.extensions.addElement(extension);
        ((PluginExtension)extension).setInTheModel(true);
        ((PluginExtension)extension).setParent(this);
        this.fireStructureChanged(extension, 1);
    }

    public void add(IPluginExtensionPoint extensionPoint) throws CoreException {
        this.ensureModelEditable();
        this.extensionPoints.addElement(extensionPoint);
        ((PluginExtensionPoint)extensionPoint).setInTheModel(true);
        ((PluginExtensionPoint)extensionPoint).setParent(this);
        this.fireStructureChanged(extensionPoint, 1);
    }

    public IPluginExtensionPoint[] getExtensionPoints() {
        Object[] result = new IPluginExtensionPoint[this.extensionPoints.size()];
        this.extensionPoints.copyInto(result);
        return result;
    }

    public IPluginExtension[] getExtensions() {
        Object[] result = new IPluginExtension[this.extensions.size()];
        this.extensions.copyInto(result);
        return result;
    }

    void load(PluginModel pd) {
        this.loadExtensions(pd.getDeclaredExtensions());
        this.loadExtensionPoints(pd.getDeclaredExtensionPoints());
    }

    public void restoreProperty(String name, Object oldValue, Object newValue) throws CoreException {
        if (name.equals("extension_order")) {
            this.swap((IPluginExtension)oldValue, (IPluginExtension)newValue);
            return;
        }
        super.restoreProperty(name, oldValue, newValue);
    }

    public void load(IExtensions srcExtensions) {
        this.addArrayToVector(this.extensions, srcExtensions.getExtensions());
        this.addArrayToVector(this.extensionPoints, srcExtensions.getExtensionPoints());
    }

    protected void addArrayToVector(Vector vector, Object[] array) {
        int i = 0;
        while (i < array.length) {
            Object obj = array[i];
            if (obj instanceof PluginObject) {
                ((PluginObject)obj).setParent(this);
            }
            vector.add(obj);
            ++i;
        }
    }

    void loadExtensionPoints(ExtensionPointModel[] extensionPointModels) {
        if (extensionPointModels == null) {
            return;
        }
        int i = 0;
        while (i < extensionPointModels.length) {
            ExtensionPointModel extensionPointModel = extensionPointModels[i];
            PluginModel parent = extensionPointModel.getParent();
            if (!(parent instanceof PluginFragmentModel)) {
                PluginExtensionPoint extensionPoint = new PluginExtensionPoint();
                extensionPoint.setModel(this.getModel());
                extensionPoint.setInTheModel(true);
                extensionPoint.setParent(this);
                this.extensionPoints.add(extensionPoint);
                extensionPoint.load(extensionPointModel);
            }
            ++i;
        }
    }

    void loadExtensions(ExtensionModel[] extensionModels) {
        if (extensionModels == null) {
            return;
        }
        int i = 0;
        while (i < extensionModels.length) {
            ExtensionModel extensionModel = extensionModels[i];
            PluginModel parent = extensionModel.getParent();
            if (!(parent instanceof PluginFragmentModel)) {
                PluginExtension extension = new PluginExtension();
                extension.setModel(this.getModel());
                extension.setInTheModel(true);
                extension.setParent(this);
                this.extensions.add(extension);
                extension.load(extensionModel);
            }
            ++i;
        }
    }

    protected void processChild(Node child, Hashtable lineTable) {
        String name = child.getNodeName().toLowerCase();
        if (name.equals("extension")) {
            PluginExtension extension = new PluginExtension();
            extension.setModel(this.getModel());
            extension.setParent(this);
            this.extensions.add(extension);
            extension.setInTheModel(true);
            extension.load(child, lineTable);
        } else if (name.equals("extension-point")) {
            PluginExtensionPoint point = new PluginExtensionPoint();
            point.setModel(this.getModel());
            point.setParent(this);
            point.setInTheModel(true);
            this.extensionPoints.add(point);
            point.load(child, lineTable);
        }
    }

    public void remove(IPluginExtension extension) throws CoreException {
        this.ensureModelEditable();
        this.extensions.removeElement(extension);
        ((PluginExtension)extension).setInTheModel(false);
        this.fireStructureChanged(extension, 2);
    }

    public void remove(IPluginExtensionPoint extensionPoint) throws CoreException {
        this.ensureModelEditable();
        this.extensionPoints.removeElement(extensionPoint);
        ((PluginExtensionPoint)extensionPoint).setInTheModel(false);
        this.fireStructureChanged(extensionPoint, 2);
    }

    public void reset() {
        this.extensions = new Vector();
        this.extensionPoints = new Vector();
    }

    public int getExtensionCount() {
        return this.extensions.size();
    }

    public int getIndexOf(IPluginExtension e) {
        return this.extensions.indexOf(e);
    }

    public void swap(IPluginExtension e1, IPluginExtension e2) throws CoreException {
        this.ensureModelEditable();
        int index1 = this.extensions.indexOf(e1);
        int index2 = this.extensions.indexOf(e2);
        if (index1 == -1 || index2 == -1) {
            this.throwCoreException("Extensions not in the model");
        }
        this.extensions.setElementAt(e1, index2);
        this.extensions.setElementAt(e2, index1);
        this.firePropertyChanged(this, "extension_order", e1, e2);
    }

    protected void writeChildren(String indent, String tag, Object[] children, PrintWriter writer) {
        writer.println(String.valueOf(indent) + "<" + tag + ">");
        int i = 0;
        while (i < children.length) {
            IPluginObject obj = (IPluginObject)children[i];
            obj.write(String.valueOf(indent) + "   ", writer);
            ++i;
        }
        writer.println(String.valueOf(indent) + "</" + tag + ">");
    }

    protected boolean hasRequiredAttributes() {
        int i = 0;
        while (i < this.extensions.size()) {
            IPluginExtension extension = (IPluginExtension)this.extensions.get(i);
            if (!extension.isValid()) {
                return false;
            }
            ++i;
        }
        i = 0;
        while (i < this.extensionPoints.size()) {
            IPluginExtensionPoint expoint = (IPluginExtensionPoint)this.extensionPoints.get(i);
            if (!expoint.isValid()) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

