/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.osgi.bundle;

import java.util.StringTokenizer;
import org.eclipse.pde.core.plugin.IFragment;

public class FragmentUtil {
    private String pluginId;
    private String pluginVersion;
    private int match;

    public FragmentUtil() {
    }

    public FragmentUtil(String value) {
        if (value != null) {
            this.setHeader(value);
        }
    }

    public FragmentUtil(IFragment fragment) {
        this.pluginId = fragment.getPluginId();
        this.pluginVersion = fragment.getPluginVersion();
        this.match = fragment.getRule();
    }

    public String getPluginId() {
        return this.pluginId;
    }

    public void setPluginId(String pluginId) {
        this.pluginId = pluginId;
    }

    public String getPluginVersion() {
        return this.pluginVersion;
    }

    public void setPluginVersion(String pluginVersion) {
        this.pluginVersion = pluginVersion;
    }

    public int getMatch() {
        return this.match;
    }

    public void setMatch(int match) {
        this.match = match;
    }

    public String getHeader() {
        if (this.pluginId == null) {
            return null;
        }
        StringBuffer hostBundle = new StringBuffer();
        hostBundle.append(this.pluginId);
        if (this.pluginVersion != null) {
            hostBundle.append("; version=");
            hostBundle.append(this.pluginVersion);
            if (this.match != 0) {
                hostBundle.append("; match=");
                hostBundle.append(this.getEquivalentRule(this.match));
            }
        }
        return hostBundle.toString();
    }

    public void setHeader(String header) {
        int loc;
        StringTokenizer stok = new StringTokenizer(header, ";");
        if (stok.hasMoreTokens()) {
            this.pluginId = stok.nextToken().trim();
        }
        if (stok.hasMoreTokens()) {
            String vtoken = stok.nextToken().trim();
            loc = vtoken.indexOf(61);
            this.pluginVersion = vtoken.substring(loc + 1).trim();
        }
        if (stok.hasMoreTokens()) {
            String mtoken = stok.nextToken().trim();
            loc = mtoken.indexOf(61);
            String matchName = mtoken.substring(loc + 1).trim();
            this.match = this.getEquivalentRule(matchName);
        }
    }

    private int getEquivalentRule(String name) {
        if (name != null) {
            String mname = name.toLowerCase();
            if (mname.equals("perfect")) {
                return 3;
            }
            if (mname.equals("equivalent")) {
                return 1;
            }
            if (mname.equals("compatible")) {
                return 2;
            }
            if (mname.equals("greaterthan-or-equal")) {
                return 4;
            }
        }
        return 0;
    }

    private String getEquivalentRule(int rule) {
        String ruleName;
        switch (rule) {
            case 3: {
                ruleName = "perfect";
                break;
            }
            case 1: {
                ruleName = "equivalent";
                break;
            }
            case 2: {
                ruleName = "compatible";
                break;
            }
            case 4: {
                ruleName = "greaterthan-or-equal";
                break;
            }
            default: {
                ruleName = null;
            }
        }
        return ruleName;
    }
}

