/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.osgi.bundle;

import java.io.InputStream;
import java.net.URL;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.core.IEditableModel;
import org.eclipse.pde.core.build.IBuildModel;
import org.eclipse.pde.core.osgi.bundle.IBundleModel;
import org.eclipse.pde.core.osgi.bundle.IBundlePluginBase;
import org.eclipse.pde.core.osgi.bundle.IBundlePluginModelBase;
import org.eclipse.pde.core.plugin.IExtensionsModel;
import org.eclipse.pde.core.plugin.IExtensionsModelFactory;
import org.eclipse.pde.core.plugin.IPluginAttribute;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.core.plugin.IPluginModelFactory;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.internal.core.AbstractModel;
import org.eclipse.pde.internal.core.osgi.bundle.BundlePluginBase;
import org.eclipse.pde.internal.core.plugin.PluginImport;
import org.eclipse.pde.internal.core.plugin.PluginLibrary;

public abstract class BundlePluginModelBase
extends AbstractModel
implements IBundlePluginModelBase,
IPluginModelFactory {
    private IBundleModel bundleModel;
    private IExtensionsModel extensionsModel;
    private IBundlePluginBase bundlePluginBase;
    private IBuildModel buildModel;
    private boolean enabled;

    public IBundleModel getBundleModel() {
        return this.bundleModel;
    }

    public IResource getUnderlyingResource() {
        return this.bundleModel.getUnderlyingResource();
    }

    public IExtensionsModel getExtensionsModel() {
        return this.extensionsModel;
    }

    public void dispose() {
        if (this.bundleModel != null) {
            if (this.bundlePluginBase != null) {
                this.bundleModel.removeModelChangedListener(this.bundlePluginBase);
            }
            this.bundleModel.dispose();
            this.bundleModel = null;
        }
        if (this.extensionsModel != null) {
            this.extensionsModel.dispose();
            this.extensionsModel = null;
        }
        super.dispose();
    }

    public void save() {
        IEditableModel emodel;
        if (this.bundleModel != null && this.bundleModel instanceof IEditableModel && (emodel = (IEditableModel)((Object)this.bundleModel)).isDirty()) {
            emodel.save();
        }
        if (this.extensionsModel != null && this.extensionsModel instanceof IEditableModel && (emodel = (IEditableModel)((Object)this.extensionsModel)).isDirty()) {
            emodel.save();
        }
    }

    public void setBundleModel(IBundleModel bundleModel) {
        if (this.bundleModel != null && this.bundlePluginBase != null) {
            this.bundleModel.removeModelChangedListener(this.bundlePluginBase);
        }
        this.bundleModel = bundleModel;
        if (this.bundlePluginBase != null) {
            bundleModel.addModelChangedListener(this.bundlePluginBase);
        }
    }

    public void setExtensionsModel(IExtensionsModel extensionsModel) {
        this.extensionsModel = extensionsModel;
    }

    public IBuildModel getBuildModel() {
        return this.buildModel;
    }

    public void setBuildModel(IBuildModel buildModel) {
        this.buildModel = buildModel;
    }

    public IPluginBase getPluginBase() {
        return this.getPluginBase(true);
    }

    public IPluginBase getPluginBase(boolean createIfMissing) {
        if (this.bundlePluginBase == null && createIfMissing) {
            this.bundlePluginBase = (BundlePluginBase)this.createPluginBase();
            if (this.bundleModel != null) {
                this.bundleModel.addModelChangedListener(this.bundlePluginBase);
            }
            this.loaded = true;
        }
        return this.bundlePluginBase;
    }

    public IPluginModelFactory getPluginFactory() {
        return this;
    }

    public IExtensionsModelFactory getFactory() {
        if (this.extensionsModel != null) {
            return this.extensionsModel.getFactory();
        }
        return null;
    }

    public String getInstallLocation() {
        if (this.bundleModel != null) {
            return this.bundleModel.getInstallLocation();
        }
        return null;
    }

    public URL getNLLookupLocation() {
        return null;
    }

    public String getResourceString(String key) {
        return key;
    }

    public boolean isEditable() {
        return true;
    }

    public boolean isInSync() {
        return !(this.bundleModel != null && !this.bundleModel.isInSync() || this.extensionsModel != null && !this.extensionsModel.isInSync());
    }

    public boolean isValid() {
        return !(this.bundleModel != null && !this.bundleModel.isValid() || this.extensionsModel != null && !this.extensionsModel.isValid());
    }

    public void load() throws CoreException {
    }

    public void load(InputStream source, boolean outOfSync) throws CoreException {
    }

    public void reload(InputStream source, boolean outOfSync) throws CoreException {
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    protected void updateTimeStamp() {
    }

    public IPluginImport createImport() {
        PluginImport iimport = new PluginImport();
        iimport.setModel(this);
        iimport.setParent(this.getPluginBase());
        return iimport;
    }

    public IPluginLibrary createLibrary() {
        PluginLibrary library = new PluginLibrary();
        library.setModel(this);
        library.setParent(this.getPluginBase());
        return library;
    }

    public IPluginAttribute createAttribute(IPluginElement element) {
        if (this.extensionsModel != null) {
            return this.extensionsModel.getFactory().createAttribute(element);
        }
        return null;
    }

    public IPluginElement createElement(IPluginObject parent) {
        if (this.extensionsModel != null) {
            return this.extensionsModel.getFactory().createElement(parent);
        }
        return null;
    }

    public IPluginExtension createExtension() {
        if (this.extensionsModel != null) {
            return this.extensionsModel.getFactory().createExtension();
        }
        return null;
    }

    public IPluginExtensionPoint createExtensionPoint() {
        if (this.extensionsModel != null) {
            return this.extensionsModel.getFactory().createExtensionPoint();
        }
        return null;
    }

    public boolean isReconcilingModel() {
        return false;
    }

    public boolean isBundleModel() {
        return true;
    }
}

