/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.osgi.bundle;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchResultCollector;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.ISearchPattern;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.osgi.bundle.IBundle;
import org.eclipse.pde.core.osgi.bundle.IBundleModel;
import org.eclipse.pde.core.osgi.bundle.IBundlePluginBase;
import org.eclipse.pde.core.osgi.bundle.IBundlePluginModelBase;
import org.eclipse.pde.core.plugin.IExtensions;
import org.eclipse.pde.core.plugin.IExtensionsModel;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.core.plugin.ISharedPluginModel;
import org.eclipse.pde.internal.core.ModelEntry;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PluginModelManager;

public class BundlePluginBase
extends PlatformObject
implements IBundlePluginBase {
    private IBundlePluginModelBase model;
    private ArrayList libraries;
    private ArrayList imports;

    public void reset() {
        this.libraries = null;
        this.imports = null;
    }

    public String getSchemaVersion() {
        return "3.0";
    }

    public void setSchemaVersion(String value) throws CoreException {
    }

    public void modelChanged(IModelChangedEvent event) {
        if (event.getChangeType() == 99) {
            this.reset();
        } else if (event.getChangeType() == 3) {
            String header = event.getChangedProperty();
            if (header.equals("Import-Package") || header.equals("Require-Bundle")) {
                this.imports = null;
            } else if (header.equals("Bundle-ClassPath")) {
                this.libraries = null;
            }
        }
    }

    public IBundle getBundle() {
        if (this.model != null) {
            IBundleModel bmodel = this.model.getBundleModel();
            return bmodel != null ? bmodel.getBundle() : null;
        }
        return null;
    }

    public ISharedPluginModel getModel() {
        return this.model;
    }

    void setModel(IBundlePluginModelBase model) {
        this.model = model;
    }

    public IExtensions getExtensionsRoot() {
        if (this.model != null) {
            IExtensionsModel emodel = this.model.getExtensionsModel();
            return emodel != null ? emodel.getExtensions() : null;
        }
        return null;
    }

    public void add(IPluginLibrary library) throws CoreException {
        IBundle bundle = this.getBundle();
        if (bundle == null) {
            return;
        }
        if (this.libraries != null) {
            this.libraries.add(library);
        }
        String libName = library.getName();
        String cp = bundle.getHeader("Bundle-ClassPath");
        cp = cp == null ? libName : String.valueOf(cp) + ", " + libName;
        bundle.setHeader("Bundle-ClassPath", cp);
    }

    public void remove(IPluginLibrary library) throws CoreException {
        this.throwException("Cannot remove library from BundlePlugin");
    }

    public void add(IPluginImport pluginImport) throws CoreException {
        IBundle bundle = this.getBundle();
        if (bundle == null) {
            return;
        }
        if (this.imports != null) {
            this.imports.add(pluginImport);
        }
        String rname = pluginImport.getId();
        String header = bundle.getHeader("Require-Bundle");
        header = header == null ? rname : String.valueOf(header) + ", " + rname;
        bundle.setHeader("Require-Bundle", header);
    }

    public void remove(IPluginImport pluginImport) throws CoreException {
        this.throwException("Cannot remove import from BundlePlugin");
    }

    public IPluginLibrary[] getLibraries() {
        if (this.libraries == null) {
            this.libraries = new ArrayList();
            StringTokenizer stok = new StringTokenizer(this.getSafeHeader("Bundle-ClassPath"), ",");
            while (stok.hasMoreTokens()) {
                String token = stok.nextToken().trim();
                try {
                    IPluginLibrary library = this.model.createLibrary();
                    library.setName(token);
                    library.setExported(true);
                    this.libraries.add(library);
                }
                catch (CoreException e) {
                    PDECore.logException(e);
                }
            }
        }
        return this.libraries.toArray(new IPluginLibrary[this.libraries.size()]);
    }

    public IPluginImport[] getImports() {
        if (this.imports == null) {
            this.imports = new ArrayList();
            HashSet uniqueIds = new HashSet();
            this.addImportsFromRequiredBundles(this.imports, uniqueIds);
            if (this.imports.size() == 0) {
                this.addImportsFromImportedPackages(this.imports, uniqueIds);
            }
        }
        return this.imports.toArray(new IPluginImport[this.imports.size()]);
    }

    private void addImportsFromRequiredBundles(ArrayList imports, Set uniqueIds) {
        StringTokenizer stok = new StringTokenizer(this.getSafeHeader("Require-Bundle"), ",");
        while (stok.hasMoreTokens()) {
            String token = stok.nextToken().trim();
            try {
                if (uniqueIds.contains(token)) continue;
                IPluginImport iimport = this.model.createImport();
                iimport.setId(token);
                uniqueIds.add(token);
                imports.add(iimport);
            }
            catch (CoreException e) {
                PDECore.logException(e);
            }
        }
    }

    private void addImportsFromImportedPackages(ArrayList imports, Set uniqueIds) {
        StringTokenizer stok = new StringTokenizer(this.getSafeHeader("Import-Package"), ",");
        while (stok.hasMoreTokens()) {
            String packageName = stok.nextToken().trim();
            try {
                String owningPluginId = this.findOwningPluginId(packageName);
                if (owningPluginId == null || uniqueIds.contains(owningPluginId)) continue;
                uniqueIds.add(owningPluginId);
                IPluginImport iimport = this.model.createImport();
                iimport.setId(owningPluginId);
                imports.add(iimport);
            }
            catch (CoreException e) {
                PDECore.logException(e);
            }
        }
    }

    private String findOwningPluginId(String packageName) {
        ISearchPattern pattern = SearchEngine.createSearchPattern((String)packageName, (int)2, (int)0, (boolean)true);
        if (pattern == null) {
            return null;
        }
        PluginModelManager mmng = PDECore.getDefault().getModelManager();
        ModelEntry[] entries = mmng.getEntries();
        ArrayList<IJavaProject> projects = new ArrayList<IJavaProject>();
        int i = 0;
        while (i < entries.length) {
            IJavaProject jproject;
            ModelEntry entry = entries[i];
            IPluginModelBase model = entry.getActiveModel();
            IResource resource = model.getUnderlyingResource();
            if (resource != null && (jproject = JavaCore.create((IProject)resource.getProject())) != null) {
                projects.add(jproject);
            }
            ++i;
        }
        if (projects.size() == 0) {
            return null;
        }
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])((IJavaElement[])projects.toArray(new IJavaProject[projects.size()])), (boolean)false);
        final IProject[] result = new IProject[]{null};
        IJavaSearchResultCollector collector = new IJavaSearchResultCollector(){

            public void aboutToStart() {
            }

            public void accept(IResource resource, int start, int end, IJavaElement enclosingElement, int accuracy) throws CoreException {
                if (resource != null && result[0] == null) {
                    result[0] = resource.getProject();
                }
            }

            public void done() {
            }

            public IProgressMonitor getProgressMonitor() {
                return null;
            }
        };
        SearchEngine searchEngine = new SearchEngine();
        try {
            ModelEntry entry;
            searchEngine.search(PDECore.getWorkspace(), pattern, scope, collector);
            if (result[0] != null && (entry = mmng.findEntry(result[0])) != null) {
                return entry.getId();
            }
        }
        catch (JavaModelException e) {
            PDECore.logException(e);
        }
        return null;
    }

    public String getProviderName() {
        IBundle bundle = this.getBundle();
        if (bundle == null) {
            return null;
        }
        return bundle.getHeader("Bundle-Vendor");
    }

    public String getVersion() {
        IBundle bundle = this.getBundle();
        if (bundle == null) {
            return null;
        }
        return bundle.getHeader("Bundle-Version");
    }

    public void setProviderName(String providerName) throws CoreException {
        IBundle bundle = this.getBundle();
        if (bundle != null) {
            bundle.setHeader("Bundle-Vendor", providerName);
        }
    }

    public void setVersion(String version) throws CoreException {
        IBundle bundle = this.getBundle();
        if (bundle != null) {
            bundle.setHeader("Bundle-Version", version);
        }
    }

    public void swap(IPluginLibrary l1, IPluginLibrary l2) throws CoreException {
        this.throwException("Cannot swap libraries in BundlePlugin");
    }

    public void load(IBundle bundle, IExtensions extensions) {
    }

    public void add(IPluginExtension extension) throws CoreException {
        IExtensions extensions = this.getExtensionsRoot();
        if (extensions == null) {
            return;
        }
        extensions.add(extension);
    }

    public void add(IPluginExtensionPoint point) throws CoreException {
        IExtensions extensions = this.getExtensionsRoot();
        if (extensions == null) {
            return;
        }
        extensions.add(point);
    }

    public IPluginExtensionPoint[] getExtensionPoints() {
        IExtensions extensions = this.getExtensionsRoot();
        if (extensions == null) {
            return new IPluginExtensionPoint[0];
        }
        return extensions.getExtensionPoints();
    }

    public IPluginExtension[] getExtensions() {
        IExtensions extensions = this.getExtensionsRoot();
        if (extensions == null) {
            return new IPluginExtension[0];
        }
        return extensions.getExtensions();
    }

    public void remove(IPluginExtension extension) throws CoreException {
        IExtensions extensions = this.getExtensionsRoot();
        if (extensions != null) {
            extensions.remove(extension);
        }
    }

    public void remove(IPluginExtensionPoint extensionPoint) throws CoreException {
        IExtensions extensions = this.getExtensionsRoot();
        if (extensions != null) {
            extensions.remove(extensionPoint);
        }
    }

    public void swap(IPluginExtension e1, IPluginExtension e2) throws CoreException {
        IExtensions extensions = this.getExtensionsRoot();
        if (extensions != null) {
            extensions.swap(e1, e2);
        }
    }

    public void load(IExtensions plugin) {
    }

    public String getId() {
        IBundle bundle = this.getBundle();
        if (bundle == null) {
            return null;
        }
        String id = bundle.getHeader("Bundle-GlobalName");
        if (id == null) {
            id = bundle.getHeader("Bundle-Name");
        }
        return id;
    }

    public void setId(String id) throws CoreException {
        IBundle bundle = this.getBundle();
        if (bundle != null) {
            bundle.setHeader("Bundle-Name", id);
            bundle.setHeader("Bundle-GlobalName", id);
        }
    }

    public IPluginModelBase getPluginModel() {
        return this.model;
    }

    public String getName() {
        IBundle bundle = this.getBundle();
        if (bundle == null) {
            return null;
        }
        return bundle.getHeader("Bundle-Description");
    }

    public boolean isInTheModel() {
        return this.model != null;
    }

    public String getTranslatedName() {
        return this.getName();
    }

    public IPluginObject getParent() {
        return null;
    }

    public IPluginBase getPluginBase() {
        return this;
    }

    public String getResourceString(String key) {
        return key;
    }

    public void setName(String name) throws CoreException {
        IBundle bundle = this.getBundle();
        if (bundle != null) {
            bundle.setHeader("Bundle-Description", name);
        }
    }

    public boolean isValid() {
        IBundle bundle = this.getBundle();
        IExtensions extensions = this.getExtensionsRoot();
        return bundle != null && bundle.isValid() && (extensions == null || extensions.isValid());
    }

    public void write(String indent, PrintWriter writer) {
    }

    private void throwException(String message) throws CoreException {
        Status status = new Status(4, "org.eclipse.pde.core", 0, message, null);
        throw new CoreException((IStatus)status);
    }

    private String getSafeHeader(String key) {
        String value = this.getBundle().getHeader(key);
        return value != null ? value : "";
    }
}

