/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.osgi.bundle;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.pde.core.ModelChangedEvent;
import org.eclipse.pde.core.osgi.bundle.IBundle;
import org.eclipse.pde.core.osgi.bundle.IBundleModel;
import org.eclipse.pde.internal.core.AbstractModel;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.osgi.bundle.Bundle;

public abstract class BundleModel
extends AbstractModel
implements IBundleModel {
    protected Bundle bundle;

    public IBundle getBundle() {
        if (!this.isLoaded()) {
            this.load();
        }
        return this.bundle;
    }

    public IBundle getBundle(boolean createIfMissing) {
        if (this.bundle == null && createIfMissing) {
            this.bundle = new Bundle();
            this.bundle.setModel(this);
            this.loaded = true;
        }
        return this.getBundle();
    }

    public String getInstallLocation() {
        return null;
    }

    public abstract void load();

    public boolean isFragmentModel() {
        IBundle bundle = this.getBundle();
        return bundle != null && bundle.getHeader("Host-Bundle") != null;
    }

    public void load(InputStream source, boolean outOfSync) {
        try {
            BufferedReader reader;
            if (this.bundle == null) {
                this.bundle = new Bundle();
                this.bundle.setModel(this);
            }
            try {
                reader = new BufferedReader(new InputStreamReader(source, "UTF8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                reader = new BufferedReader(new InputStreamReader(source));
            }
            this.readManifest(reader);
            if (!outOfSync) {
                this.updateTimeStamp();
            }
            this.loaded = true;
        }
        catch (CoreException e) {
            PDECore.log(e);
        }
    }

    private void readManifest(BufferedReader reader) throws CoreException {
        String header = null;
        StringBuffer value = new StringBuffer(256);
        boolean firstLine = true;
        try {
            while (true) {
                int colon;
                String line;
                if ((line = reader.readLine()) == null || line.length() == 0) {
                    if (!firstLine) {
                        this.bundle.processHeader(header, value.toString().trim());
                    }
                    break;
                }
                if (line.charAt(0) == ' ') {
                    if (firstLine) {
                        this.throwException("Error in manifest at line " + line, null);
                    }
                    value.append(line.substring(1));
                    continue;
                }
                if (!firstLine) {
                    this.bundle.processHeader(header, value.toString().trim());
                    value.setLength(0);
                }
                if ((colon = line.indexOf(58)) == -1) {
                    this.throwException("Error in manifest at line " + line, null);
                }
                header = line.substring(0, colon);
                value.append(line.substring(colon + 1));
                firstLine = false;
            }
        }
        catch (IOException e) {
            String message = "Error while parsing bundle manifest in " + this.getInstallLocation();
            this.throwException(message, e);
        }
    }

    private void throwException(String message, Throwable e) throws CoreException {
        Status status = new Status(4, "org.eclipse.pde.core", 0, message, e);
        throw new CoreException((IStatus)status);
    }

    public void reload(InputStream source, boolean outOfSync) {
        if (this.bundle != null) {
            this.bundle.reset();
        } else {
            this.bundle = new Bundle();
            this.bundle.setModel(this);
        }
        this.load(source, outOfSync);
        this.fireModelChanged(new ModelChangedEvent(99, new Object[0], null));
    }

    public boolean isReconcilingModel() {
        return false;
    }
}

