/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.osgi.bundle;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.pde.core.ModelChangedEvent;
import org.eclipse.pde.core.osgi.bundle.IBundle;
import org.eclipse.pde.core.plugin.IFragment;
import org.eclipse.pde.core.plugin.IPlugin;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.osgi.OSGiWorkspaceModelManager;
import org.eclipse.pde.internal.core.osgi.bundle.BundleObject;
import org.eclipse.pde.internal.core.osgi.bundle.FragmentUtil;

public class Bundle
extends BundleObject
implements IBundle {
    private Hashtable headers = new Hashtable();

    public String getHeader(String key) {
        return (String)this.headers.get(key);
    }

    public void setHeader(String key, String value) throws CoreException {
        this.ensureModelEditable();
        String oldValue = this.getHeader(key);
        if (value == null) {
            this.headers.remove(key);
        } else {
            this.headers.put(key, value);
        }
        this.getModel().fireModelChanged(new ModelChangedEvent(this, key, oldValue, value));
    }

    public void processHeader(String name, String value) {
        if (value != null) {
            this.headers.put(name, value);
        }
    }

    public void reset() {
        this.headers.clear();
    }

    public boolean isValid() {
        return this.headers.containsValue("Bundle-Name") && this.headers.containsValue("Bundle-Description") && this.headers.containsValue("Bundle-Version");
    }

    public void load(IPluginBase plugin, IProgressMonitor monitor) {
        this.reset();
        monitor.beginTask("", 2);
        Bundle.load(this.headers, plugin, monitor);
    }

    public static void load(Dictionary d, IPluginBase plugin, IProgressMonitor monitor) {
        d.put("Legacy", "true");
        d.put("Bundle-Name", plugin.getId());
        d.put("Bundle-GlobalName", plugin.getId());
        d.put("Bundle-Description", plugin.getName());
        d.put("Bundle-Vendor", plugin.getProviderName());
        d.put("Bundle-Version", plugin.getVersion());
        if (plugin instanceof IFragment) {
            Bundle.loadFragment(d, (IFragment)plugin);
        } else {
            Bundle.loadPlugin(d, (IPlugin)plugin);
        }
        Bundle.loadLibraries(d, plugin.getLibraries(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        Bundle.loadImports(d, plugin.getImports(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        if (plugin.getModel().getUnderlyingResource() != null) {
            Bundle.loadExports(d, plugin.getModel().getUnderlyingResource().getProject());
        }
    }

    private static boolean loadPlugin(Dictionary d, IPlugin plugin) {
        String pluginClass = plugin.getClassName();
        if (pluginClass != null) {
            d.put("Bundle-Activator", pluginClass);
            return true;
        }
        return false;
    }

    private static void loadFragment(Dictionary d, IFragment fragment) {
        FragmentUtil futil = new FragmentUtil(fragment);
        d.put("Host-Bundle", futil.getHeader());
    }

    private static void loadLibraries(Dictionary d, IPluginLibrary[] libraries, IProgressMonitor monitor) {
        StringBuffer classpath = new StringBuffer();
        int i = 0;
        while (i < libraries.length) {
            IPluginLibrary library = libraries[i];
            String name = library.getName();
            if (i > 0) {
                classpath.append(",");
            }
            classpath.append(name);
            ++i;
        }
        d.put("Bundle-ClassPath", classpath.toString());
    }

    private static void loadImports(Dictionary d, IPluginImport[] imports, IProgressMonitor monitor) {
        StringBuffer requires = new StringBuffer();
        boolean hasRuntime = false;
        int i = 0;
        while (i < imports.length) {
            IPluginImport iimport = imports[i];
            String id = iimport.getId();
            if (id.equals("org.eclipse.core.runtime")) {
                hasRuntime = true;
            }
            String version = iimport.getVersion();
            if (i > 0) {
                requires.append(", ");
            }
            requires.append(id);
            ++i;
        }
        if (!hasRuntime) {
            if (requires.length() > 0) {
                requires.append(", ");
            }
            requires.append("org.eclipse.core.runtime");
        }
        d.put("Require-Bundle", requires.toString());
    }

    private static void loadExports(Dictionary d, IProject project) {
        if (!OSGiWorkspaceModelManager.isJavaPluginProject(project)) {
            return;
        }
        IJavaProject javaProject = JavaCore.create((IProject)project);
        StringBuffer provides = new StringBuffer();
        int added = 0;
        try {
            IPackageFragmentRoot[] roots = javaProject.getPackageFragmentRoots();
            int i = 0;
            while (i < roots.length) {
                IPackageFragmentRoot root = roots[i];
                if (!root.isArchive() || !root.isExternal()) {
                    IJavaElement[] children = root.getChildren();
                    int j = 0;
                    while (j < children.length) {
                        IPackageFragment packageChild;
                        IJavaElement child = children[j];
                        if (child instanceof IPackageFragment && (packageChild = (IPackageFragment)child).containsJavaResources()) {
                            String name = packageChild.getElementName();
                            if (added > 0) {
                                provides.append(", ");
                            }
                            provides.append(name);
                            ++added;
                        }
                        ++j;
                    }
                }
                ++i;
            }
            if (added > 0) {
                d.put("Provide-Package", provides.toString());
            }
        }
        catch (JavaModelException e) {
            PDECore.logException(e);
        }
    }

    public void write(String indent, PrintWriter writer) {
        Enumeration enumeration = this.headers.keys();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            String value = (String)this.headers.get(key);
            if (this.isCommaSeparated(key)) {
                StringTokenizer stok = new StringTokenizer(value, ",");
                ArrayList<String> list = new ArrayList<String>();
                while (stok.hasMoreTokens()) {
                    list.add(stok.nextToken().trim());
                }
                this.writeEntry(key, list, writer);
                continue;
            }
            this.writeEntry(key, value, writer);
        }
    }

    private void writeEntry(String key, Collection value, PrintWriter out) {
        if (value == null || value.size() == 0) {
            return;
        }
        if (value.size() == 1) {
            out.println(String.valueOf(key) + ": " + value.iterator().next());
            return;
        }
        key = String.valueOf(key) + ": ";
        out.println(key);
        out.print(' ');
        boolean first = true;
        Iterator i = value.iterator();
        while (i.hasNext()) {
            if (first) {
                first = false;
            } else {
                out.println(',');
                out.print(' ');
            }
            out.print(i.next());
        }
        out.println();
    }

    private void writeEntry(String key, String value, PrintWriter out) {
        if (value != null && value.length() > 0) {
            out.println(String.valueOf(key) + ": " + value);
        }
    }

    private boolean isCommaSeparated(String key) {
        int i = 0;
        while (i < IBundle.COMMA_SEPARATED_KEYS.length) {
            if (IBundle.COMMA_SEPARATED_KEYS[i].equals(key)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

