/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.osgi;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.pde.core.IAlternativeRuntimeSupport;
import org.eclipse.pde.core.IExternalModelManager;
import org.eclipse.pde.core.IWorkspaceModelManager;
import org.eclipse.pde.core.osgi.bundle.IBundlePluginModelBase;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.osgi.OSGiExternalModelManager;
import org.eclipse.pde.internal.core.osgi.OSGiWorkspaceModelManager;
import org.eclipse.pde.internal.core.osgi.bundle.BundlePluginModelBase;

public class OSGiRuntimeSupport
implements IAlternativeRuntimeSupport {
    IWorkspaceModelManager workspaceModelManager;
    IExternalModelManager externalModelManager;

    public IWorkspaceModelManager getWorkspaceModelManager() {
        if (this.workspaceModelManager == null) {
            this.workspaceModelManager = new OSGiWorkspaceModelManager();
        }
        return this.workspaceModelManager;
    }

    public IExternalModelManager getExternalModelManager() {
        if (this.externalModelManager == null) {
            this.externalModelManager = new OSGiExternalModelManager();
        }
        return this.externalModelManager;
    }

    public IPath getPluginLocation(IPluginModelBase model) {
        String location = model.getInstallLocation();
        IResource resource = model.getUnderlyingResource();
        if (resource != null && resource.isLinked()) {
            location = model instanceof IBundlePluginModelBase ? resource.getLocation().removeLastSegments(2).addTrailingSeparator().toString() : resource.getLocation().removeLastSegments(1).addTrailingSeparator().toString();
        }
        return new Path(location).addTrailingSeparator();
    }

    public void shutdown() {
        if (this.externalModelManager != null) {
            this.externalModelManager.shutdown();
            this.externalModelManager = null;
        }
        if (this.workspaceModelManager != null) {
            this.workspaceModelManager.shutdown();
            this.workspaceModelManager = null;
        }
    }

    public IPath getTransientSitePath(IPluginModelBase model) {
        IResource resource;
        boolean bundle = false;
        if (model instanceof BundlePluginModelBase) {
            bundle = true;
        }
        if ((resource = model.getUnderlyingResource()) != null) {
            IPath realPath = resource.getLocation();
            return realPath.removeLastSegments(bundle ? 4 : 3);
        }
        Path path = new Path(model.getInstallLocation());
        return path.removeLastSegments(2);
    }

    public boolean isRelevantJavaProject(IProject project) {
        return OSGiWorkspaceModelManager.isJavaPluginProject(project) || OSGiWorkspaceModelManager.isJavaBundleProject(project);
    }
}

