/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.osgi;

import java.io.File;
import java.io.FileFilter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.core.boot.BootLoader;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.pde.core.IExternalModelManager;
import org.eclipse.pde.core.IModelProviderEvent;
import org.eclipse.pde.core.IModelProviderListener;
import org.eclipse.pde.core.plugin.IFragment;
import org.eclipse.pde.core.plugin.IFragmentModel;
import org.eclipse.pde.core.plugin.IPlugin;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.core.plugin.IPluginModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.EclipseHomeInitializer;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PluginPathFinder;
import org.eclipse.pde.internal.core.RegistryLoader;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;

public class OSGiExternalModelManager
implements IExternalModelManager {
    private Vector models = new Vector();
    private Vector fmodels = new Vector();
    private Vector listeners = new Vector();
    private boolean initialized;

    public static String computeDefaultPlatformPath() {
        URL installURL = BootLoader.getInstallURL();
        IPath ppath = new Path(installURL.getFile()).removeTrailingSeparator();
        return OSGiExternalModelManager.getCorrectPath(ppath.toOSString());
    }

    /*
     * Unable to fully structure code
     */
    private static String getCorrectPath(String path) {
        buf = new StringBuffer();
        i = 0;
        while (i < path.length()) {
            block3: {
                c = path.charAt(i);
                if (BootLoader.getOS().equals("win32") && i == 0 && c == '/') break block3;
                if (c != '%' || i + 2 >= path.length()) ** GOTO lbl-1000
                c1 = path.charAt(i + 1);
                c2 = path.charAt(i + 2);
                if (c1 == '2' && c2 == '0') {
                    i += 2;
                    buf.append(" ");
                } else lbl-1000:
                // 2 sources

                {
                    buf.append(c);
                }
            }
            ++i;
        }
        return buf.toString();
    }

    public static IPath getEclipseHome(IProgressMonitor monitor) {
        Preferences preferences = PDECore.getDefault().getPluginPreferences();
        return new Path(preferences.getString("platform_path"));
    }

    private void ensureLoaded() {
        if (!this.initialized) {
            this.loadModels((IProgressMonitor)new NullProgressMonitor());
        }
    }

    public void addModelProviderListener(IModelProviderListener listener) {
        this.listeners.add(listener);
    }

    private Vector createSavedList(String saved) {
        Vector<String> result = new Vector<String>();
        StringTokenizer stok = new StringTokenizer(saved);
        while (stok.hasMoreTokens()) {
            result.add(stok.nextToken());
        }
        return result;
    }

    public void enableAll() {
        this.enableAll(true);
    }

    private void enableAll(boolean loadIfNeeded) {
        if (loadIfNeeded) {
            this.ensureLoaded();
        }
        int i = 0;
        while (i < this.models.size()) {
            ((IPluginModel)this.models.get(i)).setEnabled(true);
            ++i;
        }
        i = 0;
        while (i < this.fmodels.size()) {
            ((IFragmentModel)this.fmodels.get(i)).setEnabled(true);
            ++i;
        }
    }

    public IPluginExtensionPoint findExtensionPoint(String fullID) {
        if (fullID == null || fullID.length() == 0) {
            return null;
        }
        int lastDot = fullID.lastIndexOf(46);
        if (lastDot == -1) {
            return null;
        }
        String pluginID = fullID.substring(0, lastDot);
        IPlugin plugin = this.findPlugin(pluginID);
        if (plugin == null) {
            return null;
        }
        String pointID = fullID.substring(lastDot + 1);
        IPluginExtensionPoint[] points = plugin.getExtensionPoints();
        int i = 0;
        while (i < points.length) {
            IPluginExtensionPoint point = points[i];
            if (point.getId().equals(pointID)) {
                return point;
            }
            ++i;
        }
        return null;
    }

    public IPlugin findPlugin(String id) {
        this.ensureLoaded();
        int i = 0;
        while (i < this.models.size()) {
            IPlugin plugin = ((IPluginModel)this.models.get(i)).getPlugin();
            if (plugin.getId().equals(id)) {
                return plugin;
            }
            ++i;
        }
        return null;
    }

    public void fireModelProviderEvent(IModelProviderEvent e) {
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            IModelProviderListener listener = (IModelProviderListener)iter.next();
            listener.modelsChanged(e);
        }
    }

    public IFragmentModel[] getFragmentModels() {
        this.ensureLoaded();
        return this.fmodels.toArray(new IFragmentModel[this.fmodels.size()]);
    }

    public IFeatureModel[] getFeatureModels() {
        return new IFeatureModel[0];
    }

    public IFragment[] getFragmentsFor(String pluginID, String pluginVersion) {
        this.ensureLoaded();
        ArrayList<IFragment> result = new ArrayList<IFragment>();
        int i = 0;
        while (i < this.fmodels.size()) {
            IFragment fragment = ((IFragmentModel)this.fmodels.get(i)).getFragment();
            if (PDECore.compare(fragment.getPluginId(), fragment.getPluginVersion(), pluginID, pluginVersion, fragment.getRule())) {
                result.add(fragment);
            }
            ++i;
        }
        return result.toArray(new IFragment[result.size()]);
    }

    public IPluginModelBase[] getAllModels() {
        this.ensureLoaded();
        IPluginModelBase[] allModels = new IPluginModelBase[this.models.size() + this.fmodels.size()];
        System.arraycopy(this.getPluginModels(), 0, allModels, 0, this.models.size());
        System.arraycopy(this.getFragmentModels(), 0, allModels, this.models.size(), this.fmodels.size());
        return allModels;
    }

    public IPluginModelBase[] getAllEnabledModels() {
        this.ensureLoaded();
        ArrayList<IPluginModelBase> result = new ArrayList<IPluginModelBase>();
        int i = 0;
        while (i < this.models.size()) {
            IPluginModelBase model = (IPluginModelBase)this.models.get(i);
            if (model.isEnabled()) {
                result.add(model);
            }
            ++i;
        }
        i = 0;
        while (i < this.fmodels.size()) {
            IPluginModelBase fmodel = (IPluginModelBase)this.fmodels.get(i);
            if (fmodel.isEnabled()) {
                result.add(fmodel);
            }
            ++i;
        }
        return result.toArray(new IPluginModelBase[result.size()]);
    }

    public IPluginModel[] getPluginModels() {
        this.ensureLoaded();
        return this.models.toArray(new IPluginModel[this.models.size()]);
    }

    public boolean hasEnabledModels() {
        this.ensureLoaded();
        int i = 0;
        while (i < this.models.size()) {
            if (((IPluginModel)this.models.get(i)).isEnabled()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void initializeAllModels() {
        Preferences pref = PDECore.getDefault().getPluginPreferences();
        String saved = pref.getString("checkedPlugins");
        if (saved.equals("[savedAll]")) {
            this.enableAll(false);
        } else if (!saved.equals("[savedNone]")) {
            Vector list = this.createSavedList(saved);
            int i = 0;
            while (i < this.models.size()) {
                IPluginModel model;
                model.setEnabled(!list.contains((model = (IPluginModel)this.models.get(i)).getPlugin().getId()));
                ++i;
            }
            i = 0;
            while (i < this.fmodels.size()) {
                IFragmentModel fmodel;
                fmodel.setEnabled(!list.contains((fmodel = (IFragmentModel)this.fmodels.get(i)).getFragment().getId()));
                ++i;
            }
        }
    }

    private void loadModels(IProgressMonitor monitor) {
        Preferences pref = PDECore.getDefault().getPluginPreferences();
        String[] pluginPaths = PluginPathFinder.getPluginPaths(pref.getString("platform_path"));
        RegistryLoader.reload(pluginPaths, this.models, this.fmodels, monitor);
        this.initialized = true;
        this.initializeAllModels();
        EclipseHomeInitializer.resetEclipseHomeVariables();
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void removeModelProviderListener(IModelProviderListener listener) {
        this.listeners.remove(listener);
    }

    public void resetModels(Vector models, Vector fmodels) {
        this.models = models;
        this.fmodels = fmodels;
    }

    public void shutdown() {
        int disabled = 0;
        StringBuffer saved = new StringBuffer();
        int i = 0;
        while (i < this.models.size()) {
            IPluginModel model = (IPluginModel)this.models.get(i);
            if (!model.isEnabled()) {
                ++disabled;
                if (saved.length() > 0) {
                    saved.append(" ");
                }
                saved.append(model.getPlugin().getId());
            }
            ++i;
        }
        i = 0;
        while (i < this.fmodels.size()) {
            IFragmentModel fmodel = (IFragmentModel)this.fmodels.get(i);
            if (!fmodel.isEnabled()) {
                ++disabled;
                if (saved.length() > 0) {
                    saved.append(" ");
                }
                saved.append(fmodel.getFragment().getId());
            }
            ++i;
        }
        Preferences pref = PDECore.getDefault().getPluginPreferences();
        if (disabled == 0) {
            pref.setValue("checkedPlugins", "[savedAll]");
        } else if (disabled == this.models.size() + this.fmodels.size()) {
            pref.setValue("checkedPlugins", "[savedNone]");
        } else {
            pref.setValue("checkedPlugins", saved.toString());
        }
        PDECore.getDefault().savePluginPreferences();
        this.initialized = false;
    }

    private static boolean isTargetOSGi() {
        IPath home = OSGiExternalModelManager.getEclipseHome(null);
        File homeDir = home.toFile();
        File pluginsDir = new File(homeDir, "plugins");
        if (!pluginsDir.exists()) {
            return false;
        }
        File[] osgiPlugins = pluginsDir.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.getName().startsWith("org.eclipse.osgi");
            }
        });
        return osgiPlugins.length > 0;
    }
}

