/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.osgi;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.model.PluginModel;
import org.eclipse.osgi.service.resolver.PlatformAdmin;
import org.eclipse.osgi.service.resolver.StateObjectFactory;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.plugin.ExternalFragmentModel;
import org.eclipse.pde.internal.core.plugin.ExternalPluginModel;
import org.eclipse.pde.internal.core.plugin.ExternalPluginModelBase;

public class BundleLoader {
    public static MultiStatus loadFromDirectories(Vector result, Vector fresult, String[] pluginPaths, boolean resolve, boolean useCache, IProgressMonitor monitor) {
        PlatformAdmin admin = PDECore.getDefault().acquirePlatform();
        StateObjectFactory factory = admin.getFactory();
        factory.createState();
        long[] id = new long[1];
        int i = 0;
        while (i < pluginPaths.length) {
            String pluginPath = pluginPaths[i];
            BundleLoader.parseDirectory(pluginPath, id);
            ++i;
        }
        return null;
    }

    private static void parseDirectory(String path, long[] id) {
        File dir = new File(path);
        File[] pdirs = dir.listFiles();
        int i = 0;
        while (i < pdirs.length) {
            File pdir = pdirs[i];
            if (pdir.isDirectory()) {
                File file = new File(pdir, "META-INF/MANIFEST.MF");
                if (file.exists()) {
                    long l = id[0];
                    id[0] = l + 1L;
                    BundleLoader.parseBundleManifest(file, l);
                } else {
                    file = new File(dir, "plugin.xml");
                    if (file.exists()) {
                        BundleLoader.parsePluginManifest(file, false);
                    } else {
                        file = new File(dir, "fragment.xml");
                        if (file.exists()) {
                            BundleLoader.parsePluginManifest(file, true);
                        }
                    }
                }
            }
            ++i;
        }
    }

    private static void parseBundleManifest(File file, long id) {
        System.out.println("Bundle: " + file.getPath());
    }

    private static void parsePluginManifest(File file, boolean fragment) {
        System.out.println(String.valueOf(fragment ? "Plugin: " : "Fragment: ") + file.getPath());
    }

    private static void processPluginModels(Vector result, PluginModel[] models, boolean isFragment, IProgressMonitor monitor) {
        monitor.beginTask("", models.length);
        int i = 0;
        while (i < models.length) {
            ExternalPluginModelBase model = BundleLoader.processPluginModel(models[i], isFragment);
            if (model.isLoaded()) {
                result.add(model);
            }
            monitor.worked(1);
            ++i;
        }
    }

    public static ExternalPluginModelBase processPluginModel(PluginModel registryModel, boolean isFragment) {
        ExternalPluginModelBase model = null;
        model = isFragment ? new ExternalFragmentModel() : new ExternalPluginModel();
        String location = registryModel.getLocation();
        try {
            String localLocation = new URL(location).getFile();
            IPath path = new Path(localLocation).removeTrailingSeparator();
            if (path.getDevice() != null) {
                path = path.setDevice(path.getDevice().toUpperCase());
            }
            model.setInstallLocation(path.toOSString());
            model.getPluginBase();
        }
        catch (MalformedURLException malformedURLException) {
            model.setInstallLocation(location);
        }
        model.load(registryModel);
        if (model.isLoaded()) {
            model.getPluginBase();
        }
        return model;
    }

    public static void reload(String[] pluginPaths, Vector result, Vector fresult, IProgressMonitor monitor) {
        MultiStatus errors = BundleLoader.loadFromDirectories(result, fresult, pluginPaths, true, true, monitor);
        if (errors != null && errors.getChildren().length > 0) {
            ResourcesPlugin.getPlugin().getLog().log((IStatus)errors);
        }
    }
}

