/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.PDECore;

public class TracingOptionsManager {
    private Properties template;

    private void createTemplate() {
        this.template = new Properties();
        IPluginModelBase[] models = PDECore.getDefault().getModelManager().getPlugins();
        int i = 0;
        while (i < models.length) {
            this.addToTemplate(models[i]);
            ++i;
        }
    }

    private void addToTemplate(IPluginModelBase model) {
        Properties modelOptions = this.getOptions(model);
        if (modelOptions == null) {
            return;
        }
        Enumeration<Object> enumeration = modelOptions.keys();
        while (enumeration.hasMoreElements()) {
            String key = enumeration.nextElement().toString();
            String value = modelOptions.getProperty(key);
            if (key == null || value == null) continue;
            this.template.setProperty(key, value);
        }
    }

    private Properties getOptions(IPluginModelBase model) {
        InputStream stream = this.openInputStream(model);
        if (stream != null) {
            Properties modelOptions = new Properties();
            try {
                modelOptions.load(stream);
                stream.close();
                return modelOptions;
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    public Hashtable getTemplateTable(String pluginId) {
        if (this.template == null) {
            this.createTemplate();
        }
        Hashtable<String, Object> defaults = new Hashtable<String, Object>();
        Enumeration<Object> enumeration = this.template.keys();
        while (enumeration.hasMoreElements()) {
            String key = enumeration.nextElement().toString();
            if (!this.belongsTo(key, pluginId)) continue;
            defaults.put(key, this.template.get(key));
        }
        return defaults;
    }

    private boolean belongsTo(String option, String pluginId) {
        Path path = new Path(option);
        String firstSegment = path.segment(0);
        return pluginId.equalsIgnoreCase(firstSegment);
    }

    public Properties getTracingOptions(Map storedOptions) {
        Properties defaults = this.getTracingTemplateCopy();
        if (storedOptions != null) {
            Iterator iter = storedOptions.keySet().iterator();
            while (iter.hasNext()) {
                String key = iter.next().toString();
                if (!defaults.containsKey(key)) continue;
                defaults.setProperty(key, (String)storedOptions.get(key));
            }
        }
        return defaults;
    }

    public Properties getTracingTemplateCopy() {
        if (this.template == null) {
            this.createTemplate();
        }
        return (Properties)this.template.clone();
    }

    public static boolean isTraceable(IPluginModelBase model) {
        if (model.getUnderlyingResource() != null) {
            IProject project = model.getUnderlyingResource().getProject();
            IPath path = project.getFullPath().append(".options");
            IFile file = project.getWorkspace().getRoot().getFile(path);
            return file.exists();
        }
        String location = model.getInstallLocation();
        String fileName = String.valueOf(location) + File.separator + ".options";
        File file = new File(fileName);
        return file.exists();
    }

    private InputStream openInputStream(IPluginModelBase model) {
        if (model.getUnderlyingResource() != null) {
            IProject project = model.getUnderlyingResource().getProject();
            IPath path = project.getFullPath().append(".options");
            IFile file = project.getWorkspace().getRoot().getFile(path);
            if (file.exists()) {
                try {
                    return file.getContents();
                }
                catch (CoreException coreException) {}
            }
        } else {
            String fileName = String.valueOf(model.getInstallLocation()) + File.separator + ".options";
            File file = new File(fileName);
            try {
                return new FileInputStream(file);
            }
            catch (FileNotFoundException fileNotFoundException) {}
        }
        return null;
    }

    public void reset() {
        this.template = null;
    }

    private void save(String fileName, Properties properties) {
        try {
            FileOutputStream stream = new FileOutputStream(fileName);
            properties.store(stream, "Master Tracing Options");
            stream.flush();
            stream.close();
        }
        catch (IOException e) {
            PDECore.logException(e);
        }
    }

    public void save(String filename, Map map) {
        this.save(filename, this.getTracingOptions(map));
    }
}

