/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.model.Factory;
import org.eclipse.core.runtime.model.PluginRegistryModel;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDERegistryCacheReader;
import org.eclipse.pde.internal.core.PDERegistryCacheWriter;

public class TargetPlatformRegistryLoader {
    private static final String CACHE_FILE = ".registry";
    private static final String KEY_SCANNING_PROBLEMS = "ExternalModelManager.scanningProblems";
    private PluginRegistryModel registryModel;
    private static boolean DEBUG = false;
    private long code;

    static {
        String value = Platform.getDebugOption((String)"org.eclipse.pde.core/cache");
        if (value != null && value.equalsIgnoreCase("true")) {
            DEBUG = true;
        }
    }

    public MultiStatus load(URL[] urls, boolean resolve, boolean useCache, IProgressMonitor monitor) {
        long start;
        Factory factory;
        MultiStatus errors;
        block7: {
            MultiStatus multiStatus;
            errors = new MultiStatus(PDECore.getPluginId(), 1, PDECore.getResourceString(KEY_SCANNING_PROBLEMS), null);
            factory = new Factory(errors);
            start = System.currentTimeMillis();
            try {
                monitor.beginTask("", 5);
                if (!resolve || !useCache) break block7;
                this.code = this.computePluginsTimestamp(urls);
                monitor.worked(1);
                this.loadFromCache(urls, factory, errors);
                monitor.worked(1);
                if (this.registryModel == null) break block7;
                multiStatus = errors;
                Object var10_10 = null;
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                monitor.done();
                throw throwable;
            }
            monitor.done();
            return multiStatus;
        }
        this.registryModel = PluginRegistryModel.parsePlugins((URL[])urls, (Factory)factory);
        monitor.worked(1);
        IStatus resolveStatus = null;
        if (resolve) {
            resolveStatus = this.registryModel.resolve(true, false);
            monitor.worked(1);
            if (resolveStatus != null) {
                errors.merge(resolveStatus);
            }
            if (useCache) {
                this.saveCache(errors);
                monitor.worked(1);
            }
        }
        if (DEBUG) {
            System.out.println("Total time elapsed: " + (System.currentTimeMillis() - start) + "ms");
        }
        MultiStatus multiStatus = errors;
        Object var10_11 = null;
        monitor.done();
        return multiStatus;
    }

    public PluginRegistryModel getRegistry() {
        return this.registryModel;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadFromCache(URL[] urls, Factory factory, MultiStatus errors) {
        File cacheFile = this.getCacheFile();
        if (!cacheFile.exists()) {
            return;
        }
        try {
            DataInputStream input = new DataInputStream(new BufferedInputStream(new FileInputStream(cacheFile)));
            try {
                long start = System.currentTimeMillis();
                PDERegistryCacheReader cacheReader = new PDERegistryCacheReader(factory, this.code);
                this.registryModel = cacheReader.readPluginRegistry(input, urls, DEBUG);
                if (DEBUG) {
                    System.out.println("Read registry cache: " + (System.currentTimeMillis() - start) + "ms");
                }
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                input.close();
                throw throwable;
            }
            {
                Object var9_12 = null;
                input.close();
            }
        }
        catch (IOException ioe) {
            Status status = new Status(4, "org.eclipse.pde.core", 2, "Unable to read plug-in cache", (Throwable)ioe);
            errors.merge((IStatus)status);
        }
        if (this.registryModel == null) {
            cacheFile.delete();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void saveCache(MultiStatus errors) {
        try {
            File file = this.getCacheFile();
            if (file.exists()) {
                return;
            }
            DataOutputStream output = null;
            try {
                output = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
            }
            catch (IOException ioe) {
                String message = "Unable to create cache.";
                Status status = new Status(4, "org.eclipse.pde.core", 0, message, (Throwable)ioe);
                errors.merge((IStatus)status);
                return;
            }
            try {
                long start = System.currentTimeMillis();
                PDERegistryCacheWriter cacheWriter = new PDERegistryCacheWriter(this.code);
                cacheWriter.writePluginRegistry(this.registryModel, output);
                if (DEBUG) {
                    System.out.println("Wrote registry: " + (System.currentTimeMillis() - start) + "ms");
                }
            }
            catch (Throwable throwable) {
                Object var7_13 = null;
                output.close();
                throw throwable;
            }
            {
                Object var7_14 = null;
                output.close();
                return;
            }
        }
        catch (IOException e) {
            String message = "Unable to write registry.";
            Status status = new Status(4, "org.eclipse.pde.core", 2, message, (Throwable)e);
            errors.merge((IStatus)status);
            if (!DEBUG) return;
            System.out.println(status.getMessage());
        }
    }

    private File getCacheFile() {
        IPath location = PDECore.getDefault().getStateLocation();
        IPath filePath = location.append(CACHE_FILE);
        return new File(filePath.toOSString());
    }

    private long computePluginsTimestamp(URL[] urls) {
        long result = 0L;
        int i = 0;
        while (i < urls.length) {
            File directory = new File(urls[i].getFile().toString().replace('/', File.separatorChar));
            if (directory.exists() && directory.isDirectory()) {
                File[] files = directory.listFiles();
                int j = 0;
                while (j < files.length) {
                    File manifest = new File(String.valueOf(files[j].getAbsolutePath()) + File.separatorChar + "plugin.xml");
                    if (!manifest.exists()) {
                        manifest = new File(String.valueOf(files[j].getAbsolutePath()) + File.separatorChar + "fragment.xml");
                    }
                    if (manifest.exists()) {
                        result ^= (long)manifest.getAbsolutePath().hashCode() ^ manifest.lastModified() ^ manifest.length();
                    }
                    ++j;
                }
            }
            ++i;
        }
        return result;
    }
}

