/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.TreeMap;
import java.util.Vector;
import org.eclipse.core.boot.BootLoader;
import org.eclipse.core.boot.IPlatformConfiguration;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.core.runtime.Status;
import org.eclipse.pde.core.IAlternativeRuntimeSupport;
import org.eclipse.pde.core.plugin.IFragmentModel;
import org.eclipse.pde.core.plugin.IPluginModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.Choice;
import org.eclipse.pde.internal.core.CoreArraySorter;
import org.eclipse.pde.internal.core.ExternalModelManager;
import org.eclipse.pde.internal.core.IEnvironmentVariables;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PluginModelManager;
import org.eclipse.pde.internal.core.feature.ExternalFeatureModel;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;

public class TargetPlatform
implements IEnvironmentVariables {
    private static final String BOOT_ID = "org.eclipse.core.boot";

    public static File createPropertiesFile() throws CoreException {
        return TargetPlatform.createPropertiesFile(TargetPlatform.getVisibleModels(), null);
    }

    public static URL[] createPluginPath() throws CoreException {
        return TargetPlatform.createPluginPath(TargetPlatform.getVisibleModels());
    }

    public static URL[] createPluginPath(IPluginModelBase[] models) throws CoreException {
        URL[] urls = new URL[models.length];
        int i = 0;
        while (i < urls.length) {
            IPluginModelBase model = models[i];
            String urlName = TargetPlatform.createURL(model);
            try {
                urls[i] = new URL(urlName);
            }
            catch (MalformedURLException e) {
                PDECore.logException(e);
                return new URL[0];
            }
            ++i;
        }
        return urls;
    }

    private static IPluginModelBase[] getVisibleModels() {
        Vector result = new Vector();
        PluginModelManager manager = PDECore.getDefault().getModelManager();
        TargetPlatform.addFromList(result, manager.getPlugins());
        IPluginModelBase[] array = result.toArray(new IPluginModelBase[result.size()]);
        return array;
    }

    private static void addFromList(Vector result, IPluginModelBase[] list) {
        int i = 0;
        while (i < list.length) {
            IPluginModelBase model = list[i];
            if (model.isEnabled()) {
                result.add(list[i]);
            }
            ++i;
        }
    }

    /*
     * Exception decompiling
     */
    public static File createPropertiesFile(IPluginModelBase[] plugins, IPath data) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [1 : 180->183)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static File createPlatformConfigurationArea(TreeMap pluginMap, IPath data, String primaryFeatureId) throws CoreException {
        try {
            File configDir = TargetPlatform.createWorkingDirectory(data);
            if (PDECore.getDefault().getModelManager().isOSGiRuntime()) {
                TargetPlatform.createConfigIniFile(configDir, pluginMap, primaryFeatureId);
            }
            File configFile = new File(configDir, "platform.cfg");
            TargetPlatform.savePlatformConfiguration(configFile, pluginMap, primaryFeatureId);
            return configFile;
        }
        catch (CoreException e) {
            throw e;
        }
        catch (Exception e) {
            String message = e.getMessage();
            if (message == null || message.length() == 0) {
                message = PDECore.getResourceString("TargetPlatform.exceptionThrown");
            }
            throw new CoreException((IStatus)new Status(4, PDECore.getPluginId(), 4, message, (Throwable)e));
        }
    }

    private static void createConfigIniFile(File configDir, TreeMap pluginMap, String primaryFeatureId) {
        File file = new File(configDir, "config.ini");
        try {
            FileOutputStream stream = new FileOutputStream(file);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)stream, "8859_1");
            BufferedWriter bWriter = new BufferedWriter(writer);
            bWriter.write("#Eclipse Runtime Configuration File");
            bWriter.newLine();
            bWriter.write("osgi.installLocation=file:" + ExternalModelManager.getEclipseHome(null).toString());
            bWriter.newLine();
            String splashPath = TargetPlatform.getLocation(primaryFeatureId, pluginMap);
            if (splashPath != null) {
                bWriter.write("osgi.splashPath=" + splashPath);
                bWriter.newLine();
            }
            bWriter.write("osgi.framework=" + TargetPlatform.getLocation("org.eclipse.osgi", pluginMap));
            bWriter.newLine();
            StringBuffer buffer = new StringBuffer();
            buffer.append(String.valueOf(TargetPlatform.getOSGiLocation("org.eclipse.osgi.services", pluginMap)) + ",");
            buffer.append(String.valueOf(TargetPlatform.getOSGiLocation("org.eclipse.osgi.util", pluginMap)) + ",");
            buffer.append(String.valueOf(TargetPlatform.getOSGiLocation("org.eclipse.core.runtime", pluginMap)) + "@2,");
            buffer.append(String.valueOf(TargetPlatform.getOSGiLocation("org.eclipse.update.configurator", pluginMap)) + "@3");
            bWriter.write("osgi.bundles=" + buffer.toString());
            bWriter.newLine();
            bWriter.write("eof=eof");
            bWriter.flush();
            bWriter.close();
        }
        catch (IOException e) {
            PDECore.logException(e);
        }
    }

    private static String getLocation(String id, TreeMap pluginMap) {
        IPluginModelBase model = (IPluginModelBase)pluginMap.get(id);
        if (model == null) {
            return null;
        }
        IPath path = null;
        IResource resource = model.getUnderlyingResource();
        path = resource != null && resource.isLinked() ? resource.getLocation().removeLastSegments(1).addTrailingSeparator() : new Path(model.getInstallLocation()).addTrailingSeparator();
        return "file:" + path.toString();
    }

    private static String getOSGiLocation(String id, TreeMap pluginMap) {
        return "reference:" + TargetPlatform.getLocation(id, pluginMap);
    }

    public static File createWorkingDirectory(IPath data) {
        String dataSuffix = TargetPlatform.createDataSuffix(data);
        IPath statePath = PDECore.getDefault().getStateLocation();
        File dir = new File(statePath.toOSString());
        if (dataSuffix.length() > 0 && !(dir = new File(dir, dataSuffix)).exists()) {
            dir.mkdir();
        }
        return dir;
    }

    private static void savePlatformConfiguration(File configFile, TreeMap pluginMap, String primaryFeatureId) throws IOException, CoreException, MalformedURLException {
        PluginVersionIdentifier bootVid;
        PluginVersionIdentifier breakVid;
        String version;
        ArrayList sites = new ArrayList();
        IAlternativeRuntimeSupport altRuntime = PDECore.getDefault().getRuntimeSupport();
        Iterator iter = pluginMap.values().iterator();
        while (iter.hasNext()) {
            IPluginModelBase model = (IPluginModelBase)iter.next();
            IPath sitePath = altRuntime.getTransientSitePath(model);
            TargetPlatform.addToSite(sitePath, model, sites);
        }
        IPluginModelBase bootModel = (IPluginModelBase)pluginMap.get(BOOT_ID);
        URL configURL = new URL("file:" + configFile.getPath());
        IPlatformConfiguration platformConfiguration = BootLoader.getPlatformConfiguration(null);
        TargetPlatform.createConfigurationEntries(platformConfiguration, bootModel, sites);
        TargetPlatform.createFeatureEntries(platformConfiguration, pluginMap, primaryFeatureId);
        platformConfiguration.refresh();
        platformConfiguration.save(configURL);
        if (bootModel != null && (version = bootModel.getPluginBase().getVersion()) != null && (breakVid = new PluginVersionIdentifier("2.0.3")).isGreaterThan(bootVid = new PluginVersionIdentifier(version))) {
            TargetPlatform.repairConfigurationVersion(configURL);
        }
    }

    private static void repairConfigurationVersion(URL url) throws IOException {
        File file = new File(url.getFile());
        if (file.exists()) {
            Properties p = new Properties();
            FileInputStream fis = new FileInputStream(file);
            p.load(fis);
            p.setProperty("version", "1.0");
            fis.close();
            FileOutputStream fos = new FileOutputStream(file);
            p.store(fos, new Date().toString());
            fos.close();
        }
    }

    private static void addToSite(IPath path, IPluginModelBase model, ArrayList sites) {
        int i = 0;
        while (i < sites.size()) {
            LocalSite localSite = (LocalSite)sites.get(i);
            if (localSite.getPath().equals((Object)path)) {
                localSite.add(model);
                return;
            }
            ++i;
        }
        LocalSite localSite = new LocalSite(path);
        localSite.add(model);
        sites.add(localSite);
    }

    private static void createConfigurationEntries(IPlatformConfiguration config, IPluginModelBase bootModel, ArrayList sites) throws CoreException, MalformedURLException {
        int i = 0;
        while (i < sites.size()) {
            LocalSite localSite = (LocalSite)sites.get(i);
            String[] plugins = localSite.getRelativePluginList();
            int policy = 0;
            IPlatformConfiguration.ISitePolicy sitePolicy = config.createSitePolicy(policy, plugins);
            IPlatformConfiguration.ISiteEntry siteEntry = config.createSiteEntry(localSite.getURL(), sitePolicy);
            config.configureSite(siteEntry);
            ++i;
        }
        if (!PDECore.getDefault().getModelManager().isOSGiRuntime()) {
            IPath bootPath = TargetPlatform.getPluginLocation(bootModel);
            URL bootURL = new URL("file:" + bootPath.toOSString());
            config.setBootstrapPluginLocation(BOOT_ID, bootURL);
        }
        config.isTransient(true);
    }

    private static IPath getPluginLocation(IPluginModelBase model) {
        return PDECore.getDefault().getRuntimeSupport().getPluginLocation(model);
    }

    private static void createFeatureEntries(IPlatformConfiguration config, TreeMap pluginMap, String primaryFeatureId) throws MalformedURLException {
        IPath targetPath = ExternalModelManager.getEclipseHome(null);
        if (primaryFeatureId == null) {
            return;
        }
        IFeatureModel featureModel = TargetPlatform.loadPrimaryFeatureModel(targetPath, primaryFeatureId);
        if (featureModel == null) {
            return;
        }
        IFeature feature = featureModel.getFeature();
        String featureVersion = feature.getVersion();
        String pluginId = primaryFeatureId;
        IPluginModelBase primaryPlugin = (IPluginModelBase)pluginMap.get(pluginId);
        if (primaryPlugin == null) {
            return;
        }
        IPath pluginPath = TargetPlatform.getPluginLocation(primaryPlugin);
        URL pluginURL = new URL("file:" + pluginPath.toString());
        URL[] root = new URL[]{pluginURL};
        IPlatformConfiguration.IFeatureEntry featureEntry = config.createFeatureEntry(primaryFeatureId, featureVersion, pluginId, primaryPlugin.getPluginBase().getVersion(), true, null, root);
        config.configureFeatureEntry(featureEntry);
        featureModel.dispose();
    }

    private static IFeatureModel loadPrimaryFeatureModel(IPath targetPath, String featureId) {
        File mainFeatureDir = targetPath.append("features").toFile();
        if (!mainFeatureDir.exists() || !mainFeatureDir.isDirectory()) {
            return null;
        }
        File[] featureDirs = mainFeatureDir.listFiles();
        PluginVersionIdentifier bestVid = null;
        File bestDir = null;
        int i = 0;
        while (i < featureDirs.length) {
            int loc;
            File featureDir = featureDirs[i];
            String name = featureDir.getName();
            if (featureDir.isDirectory() && name.startsWith(featureId) && (loc = name.lastIndexOf("_")) != -1) {
                String version = name.substring(loc + 1);
                PluginVersionIdentifier vid = new PluginVersionIdentifier(version);
                if (bestVid == null || vid.isGreaterThan(bestVid)) {
                    bestVid = vid;
                    bestDir = featureDir;
                }
            }
            ++i;
        }
        if (bestVid == null) {
            return null;
        }
        File manifest = new File(bestDir, "feature.xml");
        ExternalFeatureModel model = new ExternalFeatureModel();
        model.setInstallLocation(bestDir.getAbsolutePath());
        FileInputStream stream = null;
        boolean error = false;
        try {
            stream = new FileInputStream(manifest);
            model.load(stream, false);
        }
        catch (Exception exception) {
            error = true;
        }
        if (stream != null) {
            try {
                ((InputStream)stream).close();
            }
            catch (IOException iOException) {}
        }
        if (error || !model.isLoaded()) {
            return null;
        }
        return model;
    }

    private static String getKey(IPluginModelBase model) {
        if (model.isLoaded()) {
            return model.getPluginBase().getId();
        }
        IResource resource = model.getUnderlyingResource();
        if (resource != null) {
            return resource.getProject().getName();
        }
        return model.getInstallLocation();
    }

    private static String createDataSuffix(IPath data) {
        if (data == null) {
            return "";
        }
        String suffix = data.toOSString();
        suffix = suffix.replace(File.separatorChar, '_');
        return suffix.replace(':', '_');
    }

    private static String createURL(IPluginModelBase model) {
        String linkedURL = TargetPlatform.createLinkedURL(model);
        if (linkedURL != null) {
            return linkedURL;
        }
        String prefix = "file:" + model.getInstallLocation() + File.separator;
        if (model instanceof IPluginModel) {
            return String.valueOf(prefix) + "plugin.xml";
        }
        if (model instanceof IFragmentModel) {
            return String.valueOf(prefix) + "fragment.xml";
        }
        return "";
    }

    private static String createLinkedURL(IPluginModelBase model) {
        IResource resource = model.getUnderlyingResource();
        if (resource == null || !resource.isLinked()) {
            return null;
        }
        return "file:" + resource.getLocation().toOSString();
    }

    public static String getOS() {
        return TargetPlatform.getProperty("org.eclipse.pde.ui.os");
    }

    public static String getWS() {
        return TargetPlatform.getProperty("org.eclipse.pde.ui.ws");
    }

    public static String getNL() {
        return TargetPlatform.getProperty("org.eclipse.pde.ui.nl");
    }

    public static String getOSArch() {
        return TargetPlatform.getProperty("org.eclipse.pde.ui.arch");
    }

    private static String getProperty(String key) {
        return PDECore.getDefault().getPluginPreferences().getString(key);
    }

    private static Choice[] getKnownChoices(String[] values) {
        Choice[] choices = new Choice[values.length];
        int i = 0;
        while (i < choices.length) {
            choices[i] = new Choice(values[i], values[i]);
            ++i;
        }
        return choices;
    }

    public static Choice[] getOSChoices() {
        return TargetPlatform.getKnownChoices(BootLoader.knownOSValues());
    }

    public static Choice[] getWSChoices() {
        return TargetPlatform.getKnownChoices(BootLoader.knownWSValues());
    }

    public static Choice[] getNLChoices() {
        Locale[] locales = Locale.getAvailableLocales();
        Object[] choices = new Choice[locales.length];
        int i = 0;
        while (i < locales.length) {
            Locale locale = locales[i];
            choices[i] = new Choice(locale.toString(), String.valueOf(locale.toString()) + " - " + locale.getDisplayName());
            ++i;
        }
        CoreArraySorter.INSTANCE.sortInPlace(choices);
        return choices;
    }

    public static Choice[] getArchChoices() {
        return TargetPlatform.getKnownChoices(BootLoader.knownOSArchValues());
    }

    static class LocalSite {
        private ArrayList plugins;
        private IPath path;

        public LocalSite(IPath path) {
            this.path = path;
            this.plugins = new ArrayList();
        }

        public IPath getPath() {
            return this.path;
        }

        public URL getURL() throws MalformedURLException {
            return new URL("file:" + this.path.addTrailingSeparator().toString());
        }

        public void add(IPluginModelBase model) {
            this.plugins.add(model);
        }

        public String[] getRelativePluginList() {
            String[] list = new String[this.plugins.size()];
            int i = 0;
            while (i < this.plugins.size()) {
                IPluginModelBase model = (IPluginModelBase)this.plugins.get(i);
                IPath location = TargetPlatform.getPluginLocation(model);
                if ((location = location.append(model.isFragmentModel() ? "fragment.xml" : "plugin.xml")).segmentCount() > 3) {
                    location = location.removeFirstSegments(location.segmentCount() - 3);
                }
                list[i] = location.setDevice(null).makeRelative().toString();
                ++i;
            }
            return list;
        }
    }
}

