/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.io.File;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.internal.core.ICoreConstants;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.SourceLocation;

public class SourceLocationManager
implements ICoreConstants {
    private ArrayList userLocations = null;
    private ArrayList extensionLocations = null;
    private ArrayList orphanedExtensionLocations = null;

    public SourceLocationManager() {
        this.initializeClasspathVariables(null);
    }

    public ArrayList getUserLocationArray() {
        this.initializeUserLocations();
        return this.userLocations;
    }

    public SourceLocation[] getUserLocations() {
        this.initializeUserLocations();
        return this.getLocations(this.userLocations);
    }

    public SourceLocation[] getExtensionLocations() {
        this.initializeExtensionLocations();
        return this.getLocations(this.extensionLocations);
    }

    private SourceLocation[] getLocations(ArrayList list) {
        return list.toArray(new SourceLocation[list.size()]);
    }

    public File findSourceFile(IPluginBase pluginBase, IPath sourcePath) {
        IPath relativePath = this.getRelativePath(pluginBase, sourcePath);
        SearchResult result = this.findSourceLocation(pluginBase, relativePath);
        if (result != null) {
            return result.file;
        }
        return null;
    }

    public IPath findVariableRelativePath(IPluginBase pluginBase, IPath sourcePath) {
        IPath relativePath = this.getRelativePath(pluginBase, sourcePath);
        SearchResult result = this.findSourceLocation(pluginBase, relativePath);
        if (result != null) {
            Path path = new Path(result.loc.getName());
            return path.append(relativePath);
        }
        return null;
    }

    private IPath getRelativePath(IPluginBase pluginBase, IPath sourcePath) {
        PluginVersionIdentifier vid = new PluginVersionIdentifier(pluginBase.getVersion());
        String pluginDir = String.valueOf(pluginBase.getId()) + "_" + vid.toString();
        Path locationRelativePath = new Path(pluginDir);
        return locationRelativePath.append(sourcePath);
    }

    public SearchResult findSourceLocation(IPluginBase pluginBase, IPath relativePath) {
        this.initialize();
        SearchResult result = this.findSourceFile(this.extensionLocations, relativePath);
        if (result != null) {
            return result;
        }
        return this.findSourceFile(this.userLocations, relativePath);
    }

    private SearchResult findSourceFile(ArrayList list, IPath sourcePath) {
        int i = 0;
        while (i < list.size()) {
            SearchResult result;
            SourceLocation location = (SourceLocation)list.get(i);
            if (location.isEnabled() && (result = this.findSourcePath(location, sourcePath)) != null) {
                return result;
            }
            ++i;
        }
        return null;
    }

    private SearchResult findSourcePath(SourceLocation location, IPath sourcePath) {
        IPath locationPath = location.getPath();
        IPath fullPath = locationPath.append(sourcePath);
        File file = fullPath.toFile();
        if (file.exists()) {
            return new SearchResult(location, file);
        }
        return null;
    }

    private void initialize() {
        this.initializeUserLocations();
        this.initializeExtensionLocations();
    }

    private void initializeUserLocations() {
        this.userLocations = new ArrayList();
        String pref = PDECore.getDefault().getPluginPreferences().getString("source_locations");
        if (pref.length() > 0) {
            this.parseSavedSourceLocations(pref, this.userLocations);
        }
    }

    public void initializeClasspathVariables(IProgressMonitor monitor) {
        this.initialize();
        String[] variableNames = JavaCore.getClasspathVariableNames();
        ArrayList tasks = new ArrayList();
        this.addOrphanedLocations(variableNames, tasks);
        this.addNewOrChangedLocations(variableNames, tasks);
        if (tasks.size() == 0) {
            return;
        }
        String[] names = new String[tasks.size()];
        IPath[] paths = new IPath[tasks.size()];
        int i = 0;
        while (i < tasks.size()) {
            VariableTask task = (VariableTask)tasks.get(i);
            names[i] = task.name;
            paths[i] = task.path;
            ++i;
        }
        try {
            JavaCore.setClasspathVariables((String[])names, (IPath[])paths, (IProgressMonitor)monitor);
            this.orphanedExtensionLocations = null;
        }
        catch (JavaModelException e) {
            PDECore.log(e);
        }
    }

    private SourceLocation parseSourceLocation(String text) {
        if ((text = text.trim()).length() == 0) {
            return null;
        }
        String name = "";
        boolean enabled = true;
        int atLoc = text.indexOf(64);
        if (atLoc < 1) {
            return null;
        }
        name = text.substring(0, atLoc);
        String path = "";
        int commaLoc = text.lastIndexOf(44);
        if (commaLoc != -1) {
            if (text.length() > commaLoc + 1) {
                enabled = !text.substring(commaLoc + 1).equals("f");
            }
            path = text.substring(atLoc + 1, commaLoc);
        } else if (text.length() > atLoc + 2) {
            path = text.substring(atLoc + 1);
        }
        if (path.length() == 0) {
            return null;
        }
        return new SourceLocation(name, (IPath)new Path(path), enabled);
    }

    private void initializeExtensionLocations() {
        this.extensionLocations = new ArrayList();
        String pref = PDECore.getDefault().getPluginPreferences().getString("ext_locations");
        SourceLocation[] storedLocations = this.getSavedSourceLocations(pref);
        IPluginExtension[] extensions = this.getRegisteredSourceExtensions();
        int i = 0;
        while (i < extensions.length) {
            IPluginObject[] children = extensions[i].getChildren();
            int j = 0;
            while (j < children.length) {
                if (children[j].getName().equals("location")) {
                    IPluginElement element = (IPluginElement)children[j];
                    String pathValue = element.getAttribute("path").getValue();
                    SourceLocation location = new SourceLocation(this.getComputedName(extensions[i], pathValue), (IPath)new Path(String.valueOf(extensions[i].getModel().getInstallLocation()) + '/' + pathValue), true);
                    location.setEnabled(this.getSavedState(location.getName(), storedLocations));
                    location.setUserDefined(false);
                    if (!this.extensionLocations.contains(location)) {
                        this.extensionLocations.add(location);
                    }
                }
                ++j;
            }
            ++i;
        }
        this.computeOrphanedLocations(storedLocations);
    }

    private String getComputedName(IPluginExtension extension, String pathValue) {
        String name = String.valueOf(((IPluginBase)extension.getParent()).getId()) + "_" + pathValue;
        return name.replace('.', '_').toUpperCase();
    }

    private void addOrphanedLocations(String[] variables, ArrayList tasks) {
        if (this.orphanedExtensionLocations == null) {
            return;
        }
        int i = 0;
        while (i < this.orphanedExtensionLocations.size()) {
            SourceLocation orphanedLocation = (SourceLocation)this.orphanedExtensionLocations.get(i);
            if (this.isOnTheList(orphanedLocation.getName(), variables)) {
                tasks.add(new VariableTask(orphanedLocation.getName(), null));
            }
            ++i;
        }
    }

    private void addNewOrChangedLocations(String[] variables, ArrayList tasks) {
        this.addNewOrChangedLocations(variables, this.extensionLocations, tasks);
        this.addNewOrChangedLocations(variables, this.userLocations, tasks);
    }

    private void addNewOrChangedLocations(String[] variables, ArrayList locations, ArrayList tasks) {
        int i = 0;
        while (i < locations.size()) {
            SourceLocation location = (SourceLocation)locations.get(i);
            IPath varPath = JavaCore.getClasspathVariable((String)location.getName());
            IPath locPath = location.getPath();
            if (varPath == null || !varPath.equals((Object)locPath)) {
                tasks.add(new VariableTask(location.getName(), location.getPath()));
            }
            ++i;
        }
    }

    private boolean isOnTheList(String name, String[] list) {
        int i = 0;
        while (i < list.length) {
            if (name.equals(list[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean getSavedState(String name, SourceLocation[] list) {
        int i = 0;
        while (i < list.length) {
            SourceLocation saved = list[i];
            if (name.equals(saved.getName())) {
                return saved.isEnabled();
            }
            ++i;
        }
        return true;
    }

    private void parseSavedSourceLocations(String text, ArrayList entries) {
        text = text.replace(File.pathSeparatorChar, ';');
        StringTokenizer stok = new StringTokenizer(text, ";");
        while (stok.hasMoreTokens()) {
            String token = stok.nextToken();
            SourceLocation location = this.parseSourceLocation(token);
            if (location == null) continue;
            entries.add(location);
        }
    }

    private SourceLocation[] getSavedSourceLocations(String text) {
        if (text == null || text.length() == 0) {
            return new SourceLocation[0];
        }
        ArrayList entries = new ArrayList();
        this.parseSavedSourceLocations(text, entries);
        return entries.toArray(new SourceLocation[entries.size()]);
    }

    private void computeOrphanedLocations(SourceLocation[] storedLocations) {
        if (this.orphanedExtensionLocations != null) {
            this.orphanedExtensionLocations.clear();
        }
        int i = 0;
        while (i < storedLocations.length) {
            SourceLocation storedLoc = storedLocations[i];
            boolean found = false;
            int j = 0;
            while (j < this.extensionLocations.size()) {
                SourceLocation loc = (SourceLocation)this.extensionLocations.get(j);
                if (storedLoc.getName().equals(loc.getName())) {
                    found = true;
                    break;
                }
                ++j;
            }
            if (!found) {
                if (this.orphanedExtensionLocations == null) {
                    this.orphanedExtensionLocations = new ArrayList();
                }
                this.orphanedExtensionLocations.add(storedLoc);
            }
            ++i;
        }
    }

    private IPluginExtension[] getRegisteredSourceExtensions() {
        Vector<IPluginExtension> result = new Vector<IPluginExtension>();
        IPluginModelBase[] models = PDECore.getDefault().getExternalModelManager().getAllModels();
        int i = 0;
        while (i < models.length) {
            IPluginExtension[] extensions = models[i].getPluginBase().getExtensions();
            int j = 0;
            while (j < extensions.length) {
                IPluginExtension extension = extensions[j];
                if (extension.getPoint().equals(String.valueOf(PDECore.getPluginId()) + ".source")) {
                    result.add(extension);
                }
                ++j;
            }
            ++i;
        }
        return result.toArray(new IPluginExtension[result.size()]);
    }

    public void reinitializeClasspathVariables(IProgressMonitor monitor) {
        SourceLocation location;
        int i = 0;
        while (i < this.extensionLocations.size()) {
            location = (SourceLocation)this.extensionLocations.get(i);
            IPath path = JavaCore.getClasspathVariable((String)location.getName());
            if (path != null && path.equals((Object)location.getPath())) {
                JavaCore.removeClasspathVariable((String)location.getName(), (IProgressMonitor)monitor);
            }
            ++i;
        }
        this.initializeExtensionLocations();
        try {
            i = 0;
            while (i < this.extensionLocations.size()) {
                location = (SourceLocation)this.extensionLocations.get(i);
                JavaCore.setClasspathVariable((String)location.getName(), (IPath)location.getPath(), (IProgressMonitor)monitor);
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {}
    }

    class VariableTask {
        String name;
        IPath path;

        public VariableTask(String name, IPath path) {
            this.name = name;
            this.path = path;
        }
    }

    class SearchResult {
        SourceLocation loc;
        File file;

        SearchResult(SourceLocation loc, File file) {
            this.loc = loc;
            this.file = file;
        }
    }
}

