/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.ClasspathUtilCore;
import org.eclipse.pde.internal.core.CoreUtility;
import org.eclipse.pde.internal.core.FileAdapter;
import org.eclipse.pde.internal.core.IFileAdapterFactory;
import org.eclipse.pde.internal.core.ModelEntry;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PluginModelManager;

public class SearchablePluginsManager
implements IFileAdapterFactory {
    private IJavaProject proxyProject;
    private PluginModelManager manager;
    private static final String PROXY_FILE_NAME = ".searchable";
    private static final String PROXY_PROJECT_NAME = "External Plug-in Libraries";
    private static final String KEY = "searchablePlugins";
    private Listener elementListener;

    private String getProxyProjectName() {
        return PROXY_PROJECT_NAME;
    }

    public SearchablePluginsManager(PluginModelManager manager) {
        this.manager = manager;
        this.elementListener = new Listener();
    }

    public void initialize() {
        this.initializeProxyProject();
        if (this.proxyProject == null) {
            return;
        }
        IProject project = this.proxyProject.getProject();
        IFile proxyFile = project.getFile(PROXY_FILE_NAME);
        this.initializeStates(proxyFile);
        JavaCore.addElementChangedListener((IElementChangedListener)this.elementListener);
    }

    public void shutdown() {
        JavaCore.removeElementChangedListener((IElementChangedListener)this.elementListener);
    }

    private void initializeProxyProject() {
        IProject project = PDECore.getWorkspace().getRoot().getProject(this.getProxyProjectName());
        if (project == null) {
            return;
        }
        this.proxyProject = JavaCore.create((IProject)project);
    }

    private void initializeStates(IFile proxyFile) {
        if (!proxyFile.exists()) {
            return;
        }
        Properties properties = new Properties();
        try {
            InputStream stream = proxyFile.getContents(true);
            properties.load(stream);
            stream.close();
            String value = properties.getProperty(KEY);
            if (value == null) {
                return;
            }
            ArrayList<String> ids = new ArrayList<String>();
            StringTokenizer stok = new StringTokenizer(value, ",");
            while (stok.hasMoreTokens()) {
                ids.add(stok.nextToken());
            }
            this.initializeStates(ids);
        }
        catch (IOException iOException) {
        }
        catch (CoreException coreException) {}
    }

    private void initializeStates(ArrayList ids) {
        int i = 0;
        while (i < ids.size()) {
            String id = (String)ids.get(i);
            ModelEntry entry = this.manager.findEntry(id, null, 0);
            if (entry != null) {
                entry.setInJavaSearch(true);
            }
            ++i;
        }
    }

    public void persistStates(boolean useContainers, IProgressMonitor monitor) throws CoreException {
        ModelEntry[] entries = this.manager.getEntries();
        StringBuffer buffer = new StringBuffer();
        monitor.beginTask("Saving...", 3);
        int counter = 0;
        int i = 0;
        while (i < entries.length) {
            ModelEntry entry = entries[i];
            if (entry.isInJavaSearch()) {
                if (counter++ > 0) {
                    buffer.append(",");
                }
                buffer.append(entry.getId());
            }
            ++i;
        }
        this.createProxyProject(monitor);
        if (this.proxyProject == null) {
            return;
        }
        monitor.worked(1);
        IFile file = this.proxyProject.getProject().getFile(PROXY_FILE_NAME);
        this.persistStates(file, buffer.toString(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        monitor.worked(1);
        this.computeClasspath(entries, useContainers, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        monitor.worked(1);
    }

    private void computeClasspath(ModelEntry[] entries, boolean useContainers, IProgressMonitor monitor) throws CoreException {
        Vector result = new Vector();
        int i = 0;
        while (i < entries.length) {
            IPluginModelBase model;
            ModelEntry entry = entries[i];
            if (entry.isInJavaSearch() && entry.getWorkspaceModel() == null && (model = entries[i].getExternalModel()) != null) {
                Vector modelResult = new Vector();
                ClasspathUtilCore.addLibraries(model, false, !useContainers, modelResult);
                this.addUniqueEntries(result, modelResult);
            }
            ++i;
        }
        IClasspathEntry[] classpathEntries = result.toArray(new IClasspathEntry[result.size()]);
        try {
            this.proxyProject.setRawClasspath(classpathEntries, monitor);
        }
        catch (JavaModelException e) {
            this.throwCoreException(e);
        }
    }

    private void addUniqueEntries(Vector result, Vector localResult) {
        Vector resultCopy = (Vector)result.clone();
        int i = 0;
        while (i < localResult.size()) {
            IClasspathEntry localEntry = (IClasspathEntry)localResult.get(i);
            boolean duplicate = false;
            int j = 0;
            while (j < resultCopy.size()) {
                IClasspathEntry entry = (IClasspathEntry)resultCopy.get(j);
                if (entry.getEntryKind() == localEntry.getEntryKind() && entry.getContentKind() == localEntry.getContentKind() && entry.getPath().equals((Object)localEntry.getPath())) {
                    duplicate = true;
                    break;
                }
                ++j;
            }
            if (!duplicate) {
                result.add(localEntry);
            }
            ++i;
        }
    }

    private void persistStates(IFile file, String value, IProgressMonitor monitor) throws CoreException {
        Properties properties = new Properties();
        properties.setProperty(KEY, value);
        try {
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            properties.store(outStream, "");
            outStream.flush();
            outStream.close();
            ByteArrayInputStream inStream = new ByteArrayInputStream(outStream.toByteArray());
            if (file.exists()) {
                file.setContents((InputStream)inStream, true, false, monitor);
            } else {
                file.create((InputStream)inStream, true, monitor);
            }
            inStream.close();
        }
        catch (IOException e) {
            this.throwCoreException(e);
        }
    }

    private void throwCoreException(Throwable e) throws CoreException {
        Status status = new Status(4, "org.eclipse.pde.core", 0, e.getMessage(), e);
        throw new CoreException((IStatus)status);
    }

    private void createProxyProject(IProgressMonitor monitor) {
        IProject project = PDECore.getWorkspace().getRoot().getProject(this.getProxyProjectName());
        if (project.exists()) {
            return;
        }
        try {
            project.create(monitor);
            project.open(monitor);
            CoreUtility.addNatureToProject(project, "org.eclipse.jdt.core.javanature", monitor);
            this.proxyProject = JavaCore.create((IProject)project);
            this.proxyProject.setOutputLocation(project.getFullPath(), monitor);
        }
        catch (CoreException coreException) {}
    }

    private boolean handleDelta(IJavaElementDelta delta) {
        IJavaProject project;
        IJavaElement element = delta.getElement();
        if (element instanceof IJavaModel) {
            IJavaElementDelta[] projectDeltas = delta.getAffectedChildren();
            int i = 0;
            while (i < projectDeltas.length) {
                if (this.handleDelta(projectDeltas[i])) break;
                ++i;
            }
            return true;
        }
        if (delta.getElement() instanceof IJavaProject && (project = (IJavaProject)delta.getElement()).equals(this.proxyProject) && delta.getKind() == 2) {
            this.manager.searchablePluginsRemoved();
            this.proxyProject = null;
            return true;
        }
        return false;
    }

    public Object createAdapterChild(FileAdapter parent, File file) {
        IPackageFragmentRoot root;
        String name;
        if (!file.isDirectory() && (name = file.getName().toLowerCase()).endsWith(".jar") && (root = this.findPackageFragmentRoot(file.getAbsolutePath())) != null) {
            return root;
        }
        return new FileAdapter(parent, file, this);
    }

    private IPackageFragmentRoot findPackageFragmentRoot(String absolutePath) {
        if (this.proxyProject == null) {
            return null;
        }
        Path jarPath = new Path(absolutePath);
        try {
            IPackageFragmentRoot[] roots = this.proxyProject.getAllPackageFragmentRoots();
            int i = 0;
            while (i < roots.length) {
                IPackageFragmentRoot root = roots[i];
                IPath path = root.getPath();
                if (path.equals((Object)jarPath)) {
                    return root;
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {}
        return null;
    }

    class Listener
    implements IElementChangedListener {
        Listener() {
        }

        public void elementChanged(ElementChangedEvent e) {
            if (e.getType() == 1) {
                SearchablePluginsManager.this.handleDelta(e.getDelta());
            }
        }
    }
}

