/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.pde.core.IExternalModelManager;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.IModelProviderEvent;
import org.eclipse.pde.core.IModelProviderListener;
import org.eclipse.pde.core.IWorkspaceModelManager;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.IFileAdapterFactory;
import org.eclipse.pde.internal.core.IPluginModelListener;
import org.eclipse.pde.internal.core.ModelEntry;
import org.eclipse.pde.internal.core.PluginModelDelta;
import org.eclipse.pde.internal.core.RequiredPluginsClasspathContainer;
import org.eclipse.pde.internal.core.SearchablePluginsManager;

public class PluginModelManager
implements IAdaptable {
    private static final String OSGI_RUNTIME = "org.eclipse.core.runtime.compatibility";
    private IModelProviderListener providerListener = new IModelProviderListener(){

        public void modelsChanged(IModelProviderEvent e) {
            if (PluginModelManager.this.entries != null) {
                PluginModelManager.this.handleModelsChanged(e);
            }
        }
    };
    private IExternalModelManager externalManager;
    private IWorkspaceModelManager workspaceManager;
    private SearchablePluginsManager searchablePluginsManager;
    private ArrayList listeners = new ArrayList();
    private boolean osgiRuntime;
    private TreeMap entries;

    public PluginModelManager() {
        this.searchablePluginsManager = new SearchablePluginsManager(this);
    }

    public boolean isOSGiRuntime() {
        if (this.entries == null) {
            this.initializeTable();
        }
        return this.osgiRuntime;
    }

    public Object getAdapter(Class key) {
        return null;
    }

    public void addPluginModelListener(IPluginModelListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removePluginModelListener(IPluginModelListener listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    public boolean isEmpty() {
        if (this.entries == null) {
            this.initializeTable();
        }
        if (this.entries == null) {
            return true;
        }
        return this.entries.isEmpty();
    }

    public ModelEntry[] getEntries() {
        if (this.entries == null) {
            this.initializeTable();
        }
        if (this.entries == null) {
            return new ModelEntry[0];
        }
        Collection values = this.entries.values();
        return values.toArray(new ModelEntry[values.size()]);
    }

    public IPluginModelBase[] getPlugins() {
        if (this.entries == null) {
            this.initializeTable();
        }
        if (this.entries == null) {
            return new IPluginModelBase[0];
        }
        Collection values = this.entries.values();
        IPluginModelBase[] plugins = new IPluginModelBase[values.size()];
        int i = 0;
        Iterator iter = values.iterator();
        while (iter.hasNext()) {
            ModelEntry entry = (ModelEntry)((Object)iter.next());
            plugins[i++] = entry.getActiveModel();
        }
        return plugins;
    }

    public ModelEntry findEntry(IProject project) {
        if (this.entries == null) {
            this.initializeTable();
        }
        if (this.entries == null) {
            return null;
        }
        IModel model = this.workspaceManager.getWorkspaceModel(project);
        if (model == null) {
            return null;
        }
        if (!(model instanceof IPluginModelBase)) {
            return null;
        }
        IPluginModelBase modelBase = (IPluginModelBase)model;
        String id = modelBase.getPluginBase().getId();
        return (ModelEntry)((Object)this.entries.get(id));
    }

    public ModelEntry findEntry(String id) {
        return this.findEntry(id, null);
    }

    public ModelEntry findEntry(String id, String version) {
        return this.findEntry(id, version, 3);
    }

    public ModelEntry findEntry(String id, String version, int match) {
        if (this.entries == null) {
            this.initializeTable();
        }
        if (this.entries == null) {
            return null;
        }
        return (ModelEntry)((Object)this.entries.get(id));
    }

    public IPluginModelBase findPlugin(String id, String version, int match) {
        ModelEntry entry;
        if (this.entries == null) {
            this.initializeTable();
        }
        if ((entry = this.findEntry(id, version, match)) == null) {
            return null;
        }
        return entry.getActiveModel();
    }

    private void handleModelsChanged(IModelProviderEvent e) {
        IPluginBase plugin;
        IPluginModelBase model;
        int i;
        PluginModelDelta delta = new PluginModelDelta();
        ArrayList<IPluginBase> changedPlugins = new ArrayList<IPluginBase>();
        if ((e.getEventTypes() & 2) != 0) {
            IModel[] removed = e.getRemovedModels();
            i = 0;
            while (i < removed.length) {
                if (removed[i] instanceof IPluginModelBase) {
                    model = (IPluginModelBase)removed[i];
                    plugin = model.getPluginBase();
                    this.updateTable(plugin.getId(), model, false, delta);
                    changedPlugins.add(plugin);
                }
                ++i;
            }
        }
        if ((e.getEventTypes() & 1) != 0) {
            IModel[] added = e.getAddedModels();
            i = 0;
            while (i < added.length) {
                if (added[i] instanceof IPluginModelBase) {
                    model = (IPluginModelBase)added[i];
                    plugin = model.getPluginBase();
                    this.updateTable(plugin.getId(), model, true, delta);
                    changedPlugins.add(plugin);
                }
                ++i;
            }
        }
        if ((e.getEventTypes() & 4) != 0) {
            IModel[] changed = e.getChangedModels();
            i = 0;
            while (i < changed.length) {
                if (changed[i] instanceof IPluginModelBase) {
                    model = (IPluginModelBase)changed[i];
                    plugin = model.getPluginBase();
                    ModelEntry entry = (ModelEntry)((Object)this.entries.get(plugin.getId()));
                    delta.addEntry(entry, 4);
                    changedPlugins.add(plugin);
                }
                ++i;
            }
        }
        this.updateAffectedEntries(changedPlugins.toArray(new IPluginBase[changedPlugins.size()]));
        this.fireDelta(delta);
    }

    private void updateTable(String id, IPluginModelBase model, boolean added, PluginModelDelta delta) {
        boolean workspace;
        boolean bl = workspace = model.getUnderlyingResource() != null;
        if (id == null) {
            return;
        }
        ModelEntry entry = (ModelEntry)((Object)this.entries.get(id));
        int kind = 0;
        if (added && entry == null) {
            entry = new ModelEntry(this, id);
            this.entries.put(id, entry);
            if (id.equals(OSGI_RUNTIME)) {
                this.osgiRuntime = true;
            }
            kind = 1;
            try {
                entry.updateClasspathContainer(false, true);
            }
            catch (CoreException coreException) {}
        }
        if (added) {
            if (workspace) {
                entry.setWorkspaceModel(model);
            } else {
                entry.setExternalModel(model);
            }
        } else if (entry != null) {
            if (workspace) {
                entry.setWorkspaceModel(null);
            } else {
                entry.setExternalModel(null);
            }
            if (entry.isEmpty()) {
                this.entries.remove(id);
                kind = 2;
                if (id.equals(OSGI_RUNTIME)) {
                    this.osgiRuntime = false;
                }
            }
        }
        if (kind == 0) {
            kind = 4;
        }
        delta.addEntry(entry, kind);
    }

    private void updateAffectedEntries(IPluginBase[] changedPlugins) {
        ModelEntry[] entries = this.getEntries();
        HashMap<IJavaProject, RequiredPluginsClasspathContainer> map = new HashMap<IJavaProject, RequiredPluginsClasspathContainer>();
        int i = 0;
        while (i < entries.length) {
            ModelEntry entry = entries[i];
            if (entry.isAffected(changedPlugins)) {
                try {
                    if (entry.shouldUpdateClasspathContainer(true, true)) {
                        IProject proj = entry.getWorkspaceModel().getUnderlyingResource().getProject();
                        map.put(JavaCore.create((IProject)proj), entry.getClasspathContainer());
                    }
                }
                catch (CoreException coreException) {}
            }
            ++i;
        }
        if (map.size() > 0) {
            try {
                IJavaProject[] jProjects = map.keySet().toArray(new IJavaProject[map.size()]);
                IClasspathContainer[] containers = map.values().toArray(new IClasspathContainer[map.size()]);
                JavaCore.setClasspathContainer((IPath)new Path("org.eclipse.pde.core.requiredPlugins"), (IJavaProject[])jProjects, (IClasspathContainer[])containers, null);
            }
            catch (JavaModelException javaModelException) {}
        }
    }

    private void initializeTable() {
        if (this.workspaceManager.isLocked()) {
            return;
        }
        this.entries = new TreeMap();
        IPluginModelBase[] models = this.workspaceManager.getAllModels();
        this.addToTable(models, true);
        models = this.externalManager.getAllModels();
        this.addToTable(models, false);
        this.searchablePluginsManager.initialize();
    }

    private void addToTable(IPluginModelBase[] pmodels, boolean workspace) {
        int i = 0;
        while (i < pmodels.length) {
            this.addToTable(pmodels[i], workspace);
            ++i;
        }
    }

    private void addToTable(IPluginModelBase model, boolean workspace) {
        String id = model.getPluginBase().getId();
        if (id == null) {
            return;
        }
        ModelEntry entry = (ModelEntry)((Object)this.entries.get(id));
        if (entry == null) {
            entry = new ModelEntry(this, id);
            this.entries.put(id, entry);
        }
        if (workspace) {
            entry.setWorkspaceModel(model);
        } else {
            entry.setExternalModel(model);
        }
        if (id.equals(OSGI_RUNTIME)) {
            this.osgiRuntime = true;
        }
    }

    private void fireDelta(PluginModelDelta delta) {
        Object[] entries = this.listeners.toArray();
        int i = 0;
        while (i < entries.length) {
            ((IPluginModelListener)entries[i]).modelsChanged(delta);
            ++i;
        }
    }

    public void connect(IWorkspaceModelManager wm, IExternalModelManager em) {
        this.externalManager = em;
        this.workspaceManager = wm;
        this.externalManager.addModelProviderListener(this.providerListener);
        this.workspaceManager.addModelProviderListener(this.providerListener);
    }

    public void shutdown() {
        if (this.workspaceManager != null) {
            this.workspaceManager.removeModelProviderListener(this.providerListener);
        }
        if (this.externalManager != null) {
            this.externalManager.removeModelProviderListener(this.providerListener);
        }
        this.searchablePluginsManager.shutdown();
    }

    public void setInJavaSearch(ModelEntry[] entries, boolean value, boolean useContainers, IProgressMonitor monitor) throws CoreException {
        PluginModelDelta delta = new PluginModelDelta();
        int i = 0;
        while (i < entries.length) {
            ModelEntry entry = entries[i];
            if (entry.isInJavaSearch() != value) {
                entry.setInJavaSearch(value);
                delta.addEntry(entry, 4);
            }
            ++i;
        }
        if (delta.getKind() != 0) {
            this.searchablePluginsManager.persistStates(useContainers, monitor);
            this.fireDelta(delta);
        }
    }

    void searchablePluginsRemoved() {
        ModelEntry[] entries = this.getEntries();
        PluginModelDelta delta = new PluginModelDelta();
        int i = 0;
        while (i < entries.length) {
            ModelEntry entry = entries[i];
            if (entry.isInJavaSearch()) {
                entry.setInJavaSearch(false);
                delta.addEntry(entry, 4);
            }
            ++i;
        }
        if (delta.getKind() != 0) {
            this.fireDelta(delta);
        }
    }

    public IFileAdapterFactory getFileAdapterFactory() {
        return this.searchablePluginsManager;
    }
}

