/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.boot.BootLoader;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.service.resolver.PlatformAdmin;
import org.eclipse.pde.core.IAlternativeRuntimeSupport;
import org.eclipse.pde.core.IExternalModelManager;
import org.eclipse.pde.core.IWorkspaceModelManager;
import org.eclipse.pde.core.plugin.IFragment;
import org.eclipse.pde.core.plugin.IPlugin;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.ExternalModelManager;
import org.eclipse.pde.internal.core.IEnvironmentVariables;
import org.eclipse.pde.internal.core.PluginModelManager;
import org.eclipse.pde.internal.core.SourceAttachmentManager;
import org.eclipse.pde.internal.core.SourceLocationManager;
import org.eclipse.pde.internal.core.TempFileManager;
import org.eclipse.pde.internal.core.TracingOptionsManager;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.schema.SchemaRegistry;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class PDECore
extends Plugin
implements IEnvironmentVariables {
    public static final String PLUGIN_ID = "org.eclipse.pde.core";
    public static final String ARG_PDELAUNCH = "-pdelaunch";
    public static final String BINARY_PROJECT_VALUE = "binary";
    public static final String BINARY_REPOSITORY_PROVIDER = "org.eclipse.pde.core.BinaryRepositoryProvider";
    public static final String CLASSPATH_CONTAINER_ID = "org.eclipse.pde.core.requiredPlugins";
    public static final String ECLIPSE_HOME_VARIABLE = "ECLIPSE_HOME";
    public static final QualifiedName EXTERNAL_PROJECT_PROPERTY = new QualifiedName("org.eclipse.pde.core", "imported");
    public static final String EXTERNAL_PROJECT_VALUE = "external";
    private static PDECore inst;
    public static final String SITEBUILD_DIR = ".sitebuild";
    public static final String SITEBUILD_PROPERTIES = "sitebuild.xml";
    public static final String SITEBUILD_FILE = ".sitebuild/sitebuild.xml";
    public static final String SITEBUILD_LOG = "build.log";
    public static final String SITEBUILD_SCRIPTS = "scripts";
    public static final String SITEBUILD_TEMP_FOLDER = "temp.folder";
    private IAlternativeRuntimeSupport runtimeSupport;
    private boolean launchedInstance = false;
    private PluginModelManager modelManager;
    private boolean modelsLocked = false;
    private ResourceBundle resourceBundle;
    private SchemaRegistry schemaRegistry;
    private SourceAttachmentManager sourceAttachmentManager;
    private SourceLocationManager sourceLocationManager;
    private TempFileManager tempFileManager;
    private TracingOptionsManager tracingOptionsManager;
    private BundleContext context;
    private ServiceTracker tracker;
    static /* synthetic */ Class class$0;

    public static boolean compare(String id1, String version1, String id2, String version2, int match) {
        if (!id1.equals(id2)) {
            return false;
        }
        if (version1 == null) {
            return true;
        }
        if (version2 == null) {
            return false;
        }
        PluginVersionIdentifier pid1 = null;
        PluginVersionIdentifier pid2 = null;
        try {
            pid1 = new PluginVersionIdentifier(version1);
            pid2 = new PluginVersionIdentifier(version2);
        }
        catch (RuntimeException runtimeException) {
            return version2.equals(version1);
        }
        switch (match) {
            case 0: 
            case 2: {
                if (!pid2.isCompatibleWith(pid1)) break;
                return true;
            }
            case 1: {
                if (!pid2.isEquivalentTo(pid1)) break;
                return true;
            }
            case 3: {
                if (!pid2.isPerfect(pid1)) break;
                return true;
            }
            case 4: {
                if (!pid2.isGreaterOrEqualTo(pid1)) break;
                return true;
            }
        }
        return false;
    }

    public static PDECore getDefault() {
        return inst;
    }

    public static String getFormattedMessage(String key, String arg) {
        String text = PDECore.getResourceString(key);
        return MessageFormat.format(text, arg);
    }

    public static String getFormattedMessage(String key, String[] args) {
        String text = PDECore.getResourceString(key);
        return MessageFormat.format(text, args);
    }

    static IPath getInstallLocation() {
        return new Path(inst.getDescriptor().getInstallURL().getFile());
    }

    public static String getPluginId() {
        return inst.getDescriptor().getUniqueIdentifier();
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = inst.getResourceBundle();
        if (bundle != null) {
            try {
                String bundleString = bundle.getString(key);
                return bundleString;
            }
            catch (MissingResourceException missingResourceException) {}
        }
        return key;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static boolean inLaunchedInstance() {
        return PDECore.getDefault().isLaunchedInstance();
    }

    public static void log(IStatus status) {
        ResourcesPlugin.getPlugin().getLog().log(status);
    }

    public static void log(Throwable e) {
        if (e instanceof InvocationTargetException) {
            e = ((InvocationTargetException)e).getTargetException();
        }
        Object status = null;
        status = e instanceof CoreException ? ((CoreException)e).getStatus() : new Status(4, PDECore.getPluginId(), 0, e.getMessage(), e);
        PDECore.log(status);
    }

    public static void logErrorMessage(String message) {
        PDECore.log((IStatus)new Status(4, PDECore.getPluginId(), 4, message, null));
    }

    public static void logException(Throwable e) {
        PDECore.logException(e, null);
    }

    public static void logException(Throwable e, String message) {
        if (e instanceof InvocationTargetException) {
            e = ((InvocationTargetException)e).getTargetException();
        }
        IStatus status = null;
        if (e instanceof CoreException) {
            status = ((CoreException)e).getStatus();
        } else {
            if (message == null) {
                message = e.getMessage();
            }
            if (message == null) {
                message = e.toString();
            }
            status = new Status(4, PDECore.getPluginId(), 0, message, e);
        }
        ResourcesPlugin.getPlugin().getLog().log(status);
    }

    public PDECore(IPluginDescriptor descriptor) {
        super(descriptor);
        inst = this;
        try {
            this.resourceBundle = ResourceBundle.getBundle("org.eclipse.pde.internal.core.pderesources");
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
        this.initializeLaunchedInstanceFlag();
    }

    public IPluginExtensionPoint findExtensionPoint(String fullID) {
        if (fullID == null || fullID.length() == 0) {
            return null;
        }
        int lastDot = fullID.lastIndexOf(46);
        if (lastDot == -1) {
            return null;
        }
        String pluginID = fullID.substring(0, lastDot);
        IPlugin plugin = this.findPlugin(pluginID);
        if (plugin == null) {
            return null;
        }
        String pointID = fullID.substring(lastDot + 1);
        IPluginExtensionPoint[] points = plugin.getExtensionPoints();
        int i = 0;
        while (i < points.length) {
            IPluginExtensionPoint point = points[i];
            if (point.getId().equals(pointID)) {
                return point;
            }
            ++i;
        }
        return null;
    }

    private IFeature findFeature(IFeatureModel[] models, String id, String version, int match) {
        if (this.modelsLocked) {
            return null;
        }
        int i = 0;
        while (i < models.length) {
            String pversion;
            IFeatureModel model = models[i];
            IFeature feature = model.getFeature();
            String pid = feature.getId();
            if (PDECore.compare(id, version, pid, pversion = feature.getVersion(), match)) {
                return feature;
            }
            ++i;
        }
        return null;
    }

    public IFeature findFeature(String id) {
        return this.findFeature(id, null, 0);
    }

    public IFeature findFeature(String id, String version, int match) {
        if (this.modelsLocked) {
            return null;
        }
        IWorkspaceModelManager manager = this.getWorkspaceModelManager();
        return this.findFeature(manager.getFeatureModels(), id, version, match);
    }

    public IFragment[] findFragmentsFor(String id, String version) {
        if (this.modelsLocked) {
            return new IFragment[0];
        }
        HashMap<String, IFragment> result = new HashMap<String, IFragment>();
        IFragment[] extFragments = this.getExternalModelManager().getFragmentsFor(id, version);
        int i = 0;
        while (i < extFragments.length) {
            if (extFragments[i].getPluginModel().isEnabled()) {
                result.put(extFragments[i].getId(), extFragments[i]);
            }
            ++i;
        }
        IFragment[] wFragments = this.getWorkspaceModelManager().getFragmentsFor(id, version);
        int i2 = 0;
        while (i2 < wFragments.length) {
            result.put(wFragments[i2].getId(), wFragments[i2]);
            ++i2;
        }
        return result.values().toArray(new IFragment[result.size()]);
    }

    public IPlugin findPlugin(String id) {
        return this.findPlugin(id, null, 0);
    }

    public IPlugin findPlugin(String id, String version, int match) {
        if (this.modelsLocked) {
            return null;
        }
        IPluginModelBase model = this.getModelManager().findPlugin(id, version, match);
        if (model != null && model.isEnabled() && model.getPluginBase() instanceof IPlugin) {
            return (IPlugin)model.getPluginBase();
        }
        return null;
    }

    public IExternalModelManager getExternalModelManager() {
        if (this.runtimeSupport == null) {
            this.initializeModels();
        }
        return this.runtimeSupport.getExternalModelManager();
    }

    public PluginModelManager getModelManager() {
        if (this.modelManager == null) {
            this.initializeModels();
        }
        return this.modelManager;
    }

    public IAlternativeRuntimeSupport getRuntimeSupport() {
        if (this.runtimeSupport == null) {
            this.initializeModels();
        }
        return this.runtimeSupport;
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public SchemaRegistry getSchemaRegistry() {
        if (this.schemaRegistry == null) {
            this.schemaRegistry = new SchemaRegistry();
        }
        return this.schemaRegistry;
    }

    public SourceAttachmentManager getSourceAttachmentManager() {
        if (this.sourceAttachmentManager == null) {
            this.sourceAttachmentManager = new SourceAttachmentManager();
        }
        return this.sourceAttachmentManager;
    }

    public SourceLocationManager getSourceLocationManager() {
        if (this.sourceLocationManager == null) {
            this.sourceLocationManager = new SourceLocationManager();
        }
        return this.sourceLocationManager;
    }

    public TempFileManager getTempFileManager() {
        if (this.tempFileManager == null) {
            this.tempFileManager = new TempFileManager();
        }
        return this.tempFileManager;
    }

    public TracingOptionsManager getTracingOptionsManager() {
        if (this.tracingOptionsManager == null) {
            this.tracingOptionsManager = new TracingOptionsManager();
        }
        return this.tracingOptionsManager;
    }

    public IWorkspaceModelManager getWorkspaceModelManager() {
        if (this.runtimeSupport == null) {
            this.initializeModels();
        }
        return this.runtimeSupport.getWorkspaceModelManager();
    }

    protected void initializeDefaultPluginPreferences() {
        Preferences preferences = this.getPluginPreferences();
        preferences.setDefault("target_mode", PDECore.inLaunchedInstance() ? "useOther" : "useThis");
        preferences.setDefault("checkedPlugins", "[savedAll]");
        if (preferences.getString("target_mode").equals("useThis")) {
            preferences.setValue("platform_path", ExternalModelManager.computeDefaultPlatformPath());
        } else {
            preferences.setDefault("platform_path", ExternalModelManager.computeDefaultPlatformPath());
        }
        preferences.setDefault("org.eclipse.pde.ui.os", BootLoader.getOS());
        preferences.setDefault("org.eclipse.pde.ui.ws", BootLoader.getWS());
        preferences.setDefault("org.eclipse.pde.ui.nl", Locale.getDefault().toString());
        preferences.setDefault("org.eclipse.pde.ui.arch", BootLoader.getOSArch());
    }

    public static boolean isAlternativeRuntimeSupportEnabled() {
        Preferences pref = PDECore.getDefault().getPluginPreferences();
        return pref.getBoolean("enable_alt_runtime");
    }

    public void resetAlternativeRuntimeSupport() {
        if (this.modelManager != null) {
            this.modelManager.shutdown();
            this.modelManager = null;
        }
        if (this.runtimeSupport != null) {
            this.runtimeSupport.shutdown();
            this.runtimeSupport = null;
        }
    }

    private void initializeLaunchedInstanceFlag() {
        String[] args = BootLoader.getCommandLineArgs();
        int i = 0;
        while (i < args.length) {
            String arg = args[i];
            if (arg.equals(ARG_PDELAUNCH)) {
                this.launchedInstance = true;
                break;
            }
            ++i;
        }
    }

    private void initializeModels() {
        this.modelsLocked = true;
        if (this.runtimeSupport == null) {
            this.loadRuntimeSupport();
        }
        IExternalModelManager exManager = this.runtimeSupport.getExternalModelManager();
        IWorkspaceModelManager wsManager = this.runtimeSupport.getWorkspaceModelManager();
        if (this.modelManager == null) {
            this.modelManager = new PluginModelManager();
            this.modelManager.connect(wsManager, exManager);
        }
        this.modelsLocked = false;
    }

    private boolean isLaunchedInstance() {
        return this.launchedInstance;
    }

    public void releasePlatform() {
        if (this.tracker == null) {
            return;
        }
        this.tracker.close();
        this.tracker = null;
    }

    public PlatformAdmin acquirePlatform() {
        if (this.tracker == null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("[Lorg.eclipse.osgi.service.resolver.PlatformAdmin;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.tracker = new ServiceTracker(this.context, clazz.getName(), null);
            this.tracker.open();
        }
        PlatformAdmin result = (PlatformAdmin)this.tracker.getService();
        while (result == null) {
            try {
                this.tracker.waitForService(1000L);
                result = (PlatformAdmin)this.tracker.getService();
            }
            catch (InterruptedException interruptedException) {}
        }
        return result;
    }

    public void shutdown() throws CoreException {
        PDECore.getDefault().savePluginPreferences();
        if (this.schemaRegistry != null) {
            this.schemaRegistry.shutdown();
            this.schemaRegistry = null;
        }
        this.resetAlternativeRuntimeSupport();
        if (this.tempFileManager != null) {
            this.tempFileManager.shutdown();
            this.tempFileManager = null;
        }
        super.shutdown();
    }

    private void loadRuntimeSupport() {
        IConfigurationElement[] runtimes = Platform.getPluginRegistry().getConfigurationElementsFor(PLUGIN_ID, "alternativeRuntimeSupport");
        if (runtimes.length == 0) {
            return;
        }
        IConfigurationElement runtime = runtimes[0];
        if (runtimes.length > 1) {
            runtime = null;
            int i = 0;
            while (i < runtimes.length) {
                String def = runtimes[i].getAttribute("default");
                if (def != null && def.equalsIgnoreCase("true")) {
                    if (!PDECore.isAlternativeRuntimeSupportEnabled()) {
                        runtime = runtimes[i];
                        break;
                    }
                } else if (runtime == null) {
                    runtime = runtimes[i];
                    break;
                }
                ++i;
            }
        }
        if (runtime == null) {
            return;
        }
        try {
            Object cobj = runtime.createExecutableExtension("class");
            if (cobj == null) {
                PDECore.logErrorMessage("PDE Core: Failed to load runtime support.");
            } else if (cobj instanceof IAlternativeRuntimeSupport) {
                this.runtimeSupport = (IAlternativeRuntimeSupport)cobj;
            } else {
                PDECore.logErrorMessage("PDE Core: Runtime support of the wrong type: " + cobj.getClass().getName());
            }
        }
        catch (CoreException e) {
            PDECore.logException(e);
        }
    }
}

