/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.pde.core.IAlternativeRuntimeSupport;
import org.eclipse.pde.core.IExternalModelManager;
import org.eclipse.pde.core.IWorkspaceModelManager;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.ExternalModelManager;
import org.eclipse.pde.internal.core.WorkspaceModelManager;

public class DefaultRuntimeSupport
implements IAlternativeRuntimeSupport {
    IWorkspaceModelManager workspaceModelManager;
    IExternalModelManager externalModelManager;

    public IWorkspaceModelManager getWorkspaceModelManager() {
        if (this.workspaceModelManager == null) {
            this.workspaceModelManager = new WorkspaceModelManager();
        }
        return this.workspaceModelManager;
    }

    public IExternalModelManager getExternalModelManager() {
        if (this.externalModelManager == null) {
            this.externalModelManager = new ExternalModelManager();
        }
        return this.externalModelManager;
    }

    public IPath getPluginLocation(IPluginModelBase model) {
        String location = model.getInstallLocation();
        IResource resource = model.getUnderlyingResource();
        if (resource != null && resource.isLinked()) {
            location = resource.getLocation().removeLastSegments(1).addTrailingSeparator().toString();
        }
        return new Path(location).addTrailingSeparator();
    }

    public void shutdown() {
        if (this.externalModelManager != null) {
            this.externalModelManager.shutdown();
            this.externalModelManager = null;
        }
        if (this.workspaceModelManager != null) {
            this.workspaceModelManager.shutdown();
            this.workspaceModelManager = null;
        }
    }

    public IPath getTransientSitePath(IPluginModelBase model) {
        IResource resource = model.getUnderlyingResource();
        if (resource != null) {
            IPath realPath = resource.getLocation();
            return realPath.removeLastSegments(3);
        }
        Path path = new Path(model.getInstallLocation());
        return path.removeLastSegments(2);
    }

    public boolean isRelevantJavaProject(IProject project) {
        return WorkspaceModelManager.isJavaPluginProject(project);
    }
}

