/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.util.HashSet;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaModelStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.build.IBuildModel;
import org.eclipse.pde.core.plugin.IFragment;
import org.eclipse.pde.core.plugin.IPlugin;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.EclipseHomeInitializer;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.SourceLocationManager;
import org.eclipse.pde.internal.core.TargetPlatform;
import org.eclipse.pde.internal.core.WorkspaceModelManager;
import org.eclipse.pde.internal.core.build.WorkspaceBuildModel;

public class ClasspathUtilCore {
    public static void setClasspath(IPluginModelBase model, boolean useClasspathContainer, IProgressMonitor monitor) throws CoreException {
        Vector<IClasspathEntry> result = new Vector<IClasspathEntry>();
        int numUnits = 3;
        if (!useClasspathContainer) {
            numUnits += model.getPluginBase().getImports().length;
        }
        monitor.beginTask("", numUnits);
        ClasspathUtilCore.addSourceAndLibraries(model, result);
        monitor.worked(1);
        if (useClasspathContainer) {
            result.add(ClasspathUtilCore.createContainerEntry());
            monitor.worked(1);
        } else {
            ClasspathUtilCore.computePluginEntries(model, true, result, monitor);
        }
        ClasspathUtilCore.addJRE(result);
        monitor.worked(1);
        IClasspathEntry[] entries = result.toArray(new IClasspathEntry[result.size()]);
        IJavaProject javaProject = JavaCore.create((IProject)model.getUnderlyingResource().getProject());
        IJavaModelStatus validation = JavaConventions.validateClasspath((IJavaProject)javaProject, (IClasspathEntry[])entries, (IPath)javaProject.getOutputLocation());
        if (!validation.isOK()) {
            PDECore.logErrorMessage(validation.getMessage());
            throw new CoreException((IStatus)validation);
        }
        javaProject.setRawClasspath(entries, monitor);
        monitor.done();
    }

    private static void computePluginEntries(IPluginModelBase model, boolean relative, Vector result, IProgressMonitor monitor) {
        try {
            HashSet alreadyAdded = new HashSet();
            if (model.isFragmentModel()) {
                ClasspathUtilCore.addParentPlugin((IFragment)model.getPluginBase(), relative, result, alreadyAdded);
            }
            IPluginImport[] dependencies = model.getPluginBase().getImports();
            int i = 0;
            while (i < dependencies.length) {
                IPluginImport dependency = dependencies[i];
                IPlugin plugin = PDECore.getDefault().findPlugin(dependency.getId(), dependency.getVersion(), dependency.getMatch());
                if (plugin != null) {
                    ClasspathUtilCore.addDependency(plugin, dependency.isReexported(), relative, result, alreadyAdded);
                }
                if (monitor != null) {
                    monitor.worked(1);
                }
                ++i;
            }
            ClasspathUtilCore.addExtraClasspathEntries(model, result);
            ClasspathUtilCore.addImplicitDependencies(model.getPluginBase().getId(), model.getPluginBase().getSchemaVersion(), relative, result, alreadyAdded);
            if (monitor != null) {
                monitor.worked(1);
            }
        }
        catch (CoreException coreException) {}
    }

    private static void addExtraClasspathEntries(IPluginModelBase model, Vector result) throws CoreException {
        IFile buildFile;
        IBuildModel buildModel = model.getBuildModel();
        if (buildModel == null && (buildFile = model.getUnderlyingResource().getProject().getFile("build.properties")).exists()) {
            buildModel = new WorkspaceBuildModel(buildFile);
            buildModel.load();
        }
        if (buildModel == null) {
            return;
        }
        IBuildEntry entry = buildModel.getBuild().getEntry("jars.extra.classpath");
        if (entry == null) {
            return;
        }
        String[] tokens = entry.getTokens();
        int i = 0;
        while (i < tokens.length) {
            IResource resource;
            String device = new Path(tokens[i]).getDevice();
            Path path = null;
            if (device == null) {
                path = new Path(model.getUnderlyingResource().getProject().getName());
                path = path.append(tokens[i]);
            } else if (device.equals("platform:") && (path = new Path(tokens[i])).segmentCount() > 1 && path.segment(0).equals("plugin")) {
                path = path.setDevice(null);
                path = path.removeFirstSegments(1);
            }
            if (path != null && (resource = PDECore.getWorkspace().getRoot().findMember((IPath)path)) != null && resource instanceof IFile) {
                IClasspathEntry newEntry = JavaCore.newLibraryEntry((IPath)resource.getFullPath(), null, null);
                IProject project = resource.getProject();
                if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                    IJavaProject jProject = JavaCore.create((IProject)project);
                    IPackageFragmentRoot[] roots = jProject.getPackageFragmentRoots();
                    int j = 0;
                    while (j < roots.length) {
                        if (roots[j].getResource() != null && roots[j].getResource().equals((Object)resource)) {
                            IPath attPath = roots[j].getSourceAttachmentPath();
                            if (attPath == null) break;
                            newEntry = JavaCore.newLibraryEntry((IPath)resource.getFullPath(), (IPath)attPath, (IPath)roots[j].getSourceAttachmentRootPath());
                            break;
                        }
                        ++j;
                    }
                }
                if (!result.contains(newEntry)) {
                    result.add(newEntry);
                }
            }
            ++i;
        }
    }

    public static IClasspathEntry[] computePluginEntries(IPluginModelBase model) {
        Vector result = new Vector();
        ClasspathUtilCore.computePluginEntries(model, false, result, null);
        return result.toArray(new IClasspathEntry[result.size()]);
    }

    private static void addDependency(IPlugin plugin, boolean isExported, boolean relative, Vector result, HashSet alreadyAdded) throws CoreException {
        if (!alreadyAdded.add(plugin)) {
            return;
        }
        IResource resource = plugin.getModel().getUnderlyingResource();
        if (resource != null) {
            IClasspathEntry entry;
            IProject project = resource.getProject();
            if (project.hasNature("org.eclipse.jdt.core.javanature") && !result.contains(entry = JavaCore.newProjectEntry((IPath)project.getFullPath(), (boolean)isExported))) {
                result.add(entry);
            }
            return;
        }
        IPluginLibrary[] libraries = plugin.getLibraries();
        int i = 0;
        while (i < libraries.length) {
            IClasspathEntry entry;
            if (!"resource".equals(libraries[i].getType()) && libraries[i].isExported() && (entry = ClasspathUtilCore.createLibraryEntry(libraries[i], isExported, relative)) != null && !result.contains(entry)) {
                result.add(entry);
            }
            ++i;
        }
        IPluginImport[] imports = plugin.getImports();
        int i2 = 0;
        while (i2 < imports.length) {
            IPlugin importedPlugin;
            IPluginImport dependency = imports[i2];
            if (dependency.isReexported() && (importedPlugin = PDECore.getDefault().findPlugin(dependency.getId(), dependency.getVersion(), dependency.getMatch())) != null) {
                ClasspathUtilCore.addDependency(importedPlugin, isExported, relative, result, alreadyAdded);
            }
            ++i2;
        }
    }

    private static boolean isOSGiRuntime() {
        return PDECore.getDefault().getModelManager().isOSGiRuntime();
    }

    protected static void addImplicitDependencies(String id, String schemaVersion, boolean relative, Vector result, HashSet alreadyAdded) throws CoreException {
        if (ClasspathUtilCore.isOSGiRuntime() && schemaVersion != null || id.equals("org.eclipse.core.boot") || id.equals("org.apache.xerces") || id.startsWith("org.eclipse.swt")) {
            return;
        }
        if (schemaVersion == null && ClasspathUtilCore.isOSGiRuntime()) {
            IPlugin plugin;
            if (!id.equals("org.eclipse.core.runtime") && (plugin = PDECore.getDefault().findPlugin("org.eclipse.core.runtime.compatibility")) != null) {
                ClasspathUtilCore.addDependency(plugin, false, relative, result, alreadyAdded);
            }
        } else {
            IPlugin plugin = PDECore.getDefault().findPlugin("org.eclipse.core.boot");
            if (plugin != null) {
                ClasspathUtilCore.addDependency(plugin, false, relative, result, alreadyAdded);
            }
            if (!id.equals("org.eclipse.core.runtime") && (plugin = PDECore.getDefault().findPlugin("org.eclipse.core.runtime")) != null) {
                ClasspathUtilCore.addDependency(plugin, false, relative, result, alreadyAdded);
            }
        }
    }

    protected static void addJRE(Vector result) {
        result.add(JavaCore.newContainerEntry((IPath)new Path("org.eclipse.jdt.launching.JRE_CONTAINER")));
    }

    public static void addLibraries(IPluginModelBase model, boolean unconditionallyExport, boolean relative, Vector result) {
        IPluginLibrary[] libraries = model.getPluginBase().getLibraries();
        int i = 0;
        while (i < libraries.length) {
            IClasspathEntry entry = ClasspathUtilCore.createLibraryEntry(libraries[i], unconditionallyExport, relative);
            if (entry != null && !result.contains(entry)) {
                result.add(entry);
            }
            ++i;
        }
    }

    private static void addParentPlugin(IFragment fragment, boolean relative, Vector result, HashSet alreadyAdded) throws CoreException {
        IPlugin parent = PDECore.getDefault().findPlugin(fragment.getPluginId(), fragment.getPluginVersion(), fragment.getRule());
        if (parent != null) {
            ClasspathUtilCore.addDependency(parent, false, relative, result, alreadyAdded);
            IPluginImport[] imports = parent.getImports();
            int i = 0;
            while (i < imports.length) {
                IPlugin plugin;
                if (!imports[i].isReexported() && (plugin = PDECore.getDefault().findPlugin(imports[i].getId(), imports[i].getVersion(), imports[i].getMatch())) != null) {
                    ClasspathUtilCore.addDependency(plugin, false, relative, result, alreadyAdded);
                }
                ++i;
            }
        }
    }

    private static void addSourceAndLibraries(IPluginModelBase model, Vector result) throws CoreException {
        int i;
        IProject project = model.getUnderlyingResource().getProject();
        IBuildEntry[] buildEntries = ClasspathUtilCore.getBuildEntries(model, project);
        if (!WorkspaceModelManager.isBinaryPluginProject(project)) {
            IPackageFragmentRoot[] roots = JavaCore.create((IProject)project).getPackageFragmentRoots();
            i = 0;
            while (i < roots.length) {
                IClasspathEntry entry;
                IPackageFragmentRoot root = roots[i];
                if (root.getKind() == 1 && root.getPath().segmentCount() > 1 && !result.contains(entry = JavaCore.newSourceEntry((IPath)root.getPath()))) {
                    result.add(entry);
                }
                ++i;
            }
        }
        IPluginLibrary[] libraries = model.getPluginBase().getLibraries();
        i = 0;
        while (i < libraries.length) {
            IPluginLibrary library = libraries[i];
            if (!"resource".equals(library.getType())) {
                IClasspathEntry entry;
                boolean found = false;
                int j = 0;
                while (j < buildEntries.length) {
                    IBuildEntry buildEntry = buildEntries[j];
                    if (buildEntry.getName().equals("source." + library.getName())) {
                        String[] folders = buildEntry.getTokens();
                        int k = 0;
                        while (k < folders.length) {
                            IPath path = project.getFullPath().append(folders[k]);
                            if (path.toFile().exists()) {
                                IClasspathEntry entry2 = JavaCore.newSourceEntry((IPath)path);
                                if (!result.contains(entry2)) {
                                    result.add(entry2);
                                }
                            } else {
                                ClasspathUtilCore.addSourceFolder(folders[k], project, result);
                            }
                            ++k;
                        }
                        found = true;
                        break;
                    }
                    ++j;
                }
                if (!found && (entry = ClasspathUtilCore.createLibraryEntry(library, library.isExported(), true)) != null && !result.contains(entry)) {
                    result.add(entry);
                }
            }
            ++i;
        }
    }

    protected static void addSourceFolder(String name, IProject project, Vector result) throws CoreException {
        IPath path = project.getFullPath().append(name);
        ClasspathUtilCore.ensureFolderExists(project, path);
        IClasspathEntry entry = JavaCore.newSourceEntry((IPath)path);
        if (!result.contains(entry)) {
            result.add(entry);
        }
    }

    private static void ensureFolderExists(IProject project, IPath folderPath) throws CoreException {
        IWorkspace workspace = project.getWorkspace();
        int i = 1;
        while (i <= folderPath.segmentCount()) {
            IPath partialPath = folderPath.uptoSegment(i);
            if (!workspace.getRoot().exists(partialPath)) {
                IFolder folder = workspace.getRoot().getFolder(partialPath);
                folder.create(true, true, null);
            }
            ++i;
        }
    }

    public static IClasspathEntry createContainerEntry() {
        Path path = new Path("org.eclipse.pde.core.requiredPlugins");
        return JavaCore.newContainerEntry((IPath)path);
    }

    private static IClasspathEntry createLibraryEntry(IPluginLibrary library, boolean unconditionallyExport, boolean relative) {
        try {
            String expandedName = ClasspathUtilCore.expandLibraryName(library.getName());
            boolean isExported = unconditionallyExport ? true : library.isFullyExported();
            IPluginModelBase model = library.getPluginModel();
            IPath path = ClasspathUtilCore.getPath(model, expandedName);
            if (path == null) {
                if (model.isFragmentModel() || !model.getPluginBase().getId().equals("org.eclipse.swt")) {
                    return null;
                }
                model = ClasspathUtilCore.resolveLibraryInFragments(library, expandedName);
                if (model == null) {
                    return null;
                }
                path = ClasspathUtilCore.getPath(model, expandedName);
            }
            if (relative && model.getUnderlyingResource() == null) {
                return JavaCore.newVariableEntry((IPath)EclipseHomeInitializer.createEclipseRelativeHome(path.toOSString()), (IPath)ClasspathUtilCore.getSourceAnnotation(model, expandedName, true), null, (boolean)isExported);
            }
            return JavaCore.newLibraryEntry((IPath)path, (IPath)ClasspathUtilCore.getSourceAnnotation(model, expandedName, false), null, (boolean)isExported);
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public static String expandLibraryName(String source) {
        if (source == null || source.length() == 0) {
            return "";
        }
        if (source.indexOf("$ws$") != -1) {
            source = source.replaceAll("\\$ws\\$", "ws/" + TargetPlatform.getWS());
        }
        if (source.indexOf("$os$") != -1) {
            source = source.replaceAll("\\$os\\$", "os/" + TargetPlatform.getOS());
        }
        return source;
    }

    private static IBuildEntry[] getBuildEntries(IPluginModelBase model, IProject project) throws CoreException {
        IFile buildFile;
        IBuildModel buildModel = model.getBuildModel();
        if (buildModel == null && (buildFile = project.getFile("build.properties")).exists()) {
            buildModel = new WorkspaceBuildModel(buildFile);
            buildModel.load();
        }
        if (buildModel != null) {
            return buildModel.getBuild().getBuildEntries();
        }
        return new IBuildEntry[0];
    }

    private static IPath getSourceAnnotation(IPluginModelBase model, String libraryName, boolean relative) throws CoreException {
        IPath path = null;
        int dot = libraryName.lastIndexOf(46);
        if (dot != -1) {
            String zipName = String.valueOf(libraryName.substring(0, dot)) + "src.zip";
            path = ClasspathUtilCore.getPath(model, zipName);
            if (path == null) {
                IResource resource = model.getUnderlyingResource();
                SourceLocationManager manager = PDECore.getDefault().getSourceLocationManager();
                path = manager.findVariableRelativePath(model.getPluginBase(), (IPath)new Path(zipName));
                if (path != null && (!relative || resource != null && !resource.getProject().hasNature("org.eclipse.jdt.core.javanature") || resource != null && resource.isLinked())) {
                    path = JavaCore.getResolvedVariablePath((IPath)path);
                }
            } else if (relative) {
                path = EclipseHomeInitializer.createEclipseRelativeHome(path.toOSString());
            }
        }
        return path;
    }

    private static IPluginModelBase resolveLibraryInFragments(IPluginLibrary library, String libraryName) {
        IFragment[] fragments = PDECore.getDefault().findFragmentsFor(library.getPluginBase().getId(), library.getPluginBase().getVersion());
        int i = 0;
        while (i < fragments.length) {
            IPath path = ClasspathUtilCore.getPath(fragments[i].getPluginModel(), libraryName);
            if (path != null) {
                return fragments[i].getPluginModel();
            }
            ++i;
        }
        return null;
    }

    private static IPath getPath(IPluginModelBase model, String libraryName) {
        IResource resource = model.getUnderlyingResource();
        if (resource != null) {
            IResource jarFile = resource.getProject().findMember(libraryName);
            if (jarFile != null) {
                return jarFile.getFullPath();
            }
        } else {
            IPath path = new Path(model.getInstallLocation()).append(libraryName);
            if (path.toFile().exists()) {
                return path;
            }
        }
        return null;
    }
}

