/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.ui.text;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.Assert;
import org.eclipse.search.internal.core.ISearchScope;
import org.eclipse.search.internal.core.text.ITextSearchResultCollector;
import org.eclipse.search.internal.core.text.MatchLocator;
import org.eclipse.search.internal.core.text.TextSearchEngine;
import org.eclipse.search.internal.core.text.TextSearchScope;
import org.eclipse.search.internal.ui.SearchMessages;
import org.eclipse.search.internal.ui.SearchPluginImages;
import org.eclipse.search.internal.ui.text.TextSearchResultCollector;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class TextSearchOperation
extends WorkspaceModifyOperation {
    public static final int NO_PRIORITY_CHANGE = -1;
    private IWorkspace fWorkspace;
    private MatchLocator fMatchLocator;
    private ISearchScope fScope;
    private TextSearchResultCollector fCollector;
    private IStatus fStatus;

    public TextSearchOperation(IWorkspace workspace, String pattern, String options, ISearchScope scope, TextSearchResultCollector collector) {
        super(null);
        Assert.isNotNull((Object)collector);
        this.fWorkspace = workspace;
        this.fMatchLocator = new MatchLocator(pattern, options);
        this.fScope = scope;
        this.fCollector = collector;
        this.fCollector.setOperation(this);
    }

    protected void execute(IProgressMonitor monitor) {
        this.fCollector.setProgressMonitor(monitor);
        TextSearchEngine engine = new TextSearchEngine();
        this.fStatus = engine.search(this.fWorkspace, this.fScope, this.fCollector, this.fMatchLocator);
    }

    void searchInFile(IFile file, ITextSearchResultCollector collector) {
        TextSearchEngine engine = new TextSearchEngine();
        TextSearchScope scope = new TextSearchScope("");
        scope.add((IResource)file);
        scope.addExtension("*");
        this.fStatus = engine.search(this.fWorkspace, scope, collector, this.fMatchLocator);
    }

    String getSingularLabel() {
        String pattern = this.fMatchLocator.getPattern();
        if (pattern == null || pattern.length() < 1) {
            return SearchMessages.getFormattedString("FileSearchOperation.singularLabelPostfix", new String[]{this.fScope.getDescription()});
        }
        return SearchMessages.getFormattedString("TextSearchOperation.singularLabelPostfix", new String[]{this.fMatchLocator.getPattern(), this.fScope.getDescription()});
    }

    String getPluralLabelPattern() {
        String pattern = this.fMatchLocator.getPattern();
        if (pattern == null || pattern.length() < 1) {
            return SearchMessages.getFormattedString("FileSearchOperation.pluralLabelPatternPostfix", new String[]{"{0}", this.fScope.getDescription()});
        }
        return SearchMessages.getFormattedString("TextSearchOperation.pluralLabelPatternPostfix", new String[]{this.fMatchLocator.getPattern(), "{0}", this.fScope.getDescription()});
    }

    ImageDescriptor getImageDescriptor() {
        return SearchPluginImages.DESC_OBJ_TSEARCH_DPDN;
    }

    IStatus getStatus() {
        return this.fStatus;
    }

    String getPattern() {
        return this.fMatchLocator.getPattern();
    }

    boolean isRegexSearch() {
        return this.fMatchLocator.isRegExSearch();
    }
}

