/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.ui.text;

import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.search.internal.ui.SearchMessages;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.search.internal.ui.SearchResultView;
import org.eclipse.search.internal.ui.util.ListContentProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class SearchAgainConfirmationDialog
extends Dialog {
    private List fOutOfSync;
    private List fOutOfDate;

    SearchAgainConfirmationDialog(Shell shell, List outOfSync, List outOfDate) {
        super(shell);
        this.fOutOfSync = outOfSync;
        this.fOutOfDate = outOfDate;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected Control createDialogArea(Composite parent) {
        Composite result = (Composite)super.createDialogArea(parent);
        if (this.fOutOfSync.size() > 0) {
            this.createLabel(result, SearchMessages.getString("SearchAgainConfirmationDialog.outofsync.message"));
            this.createLabel(result, SearchMessages.getString("SearchAgainConfirmationDialog.outofsync.label"));
            this.createTableViewer(this.fOutOfSync, result);
        } else {
            this.createLabel(result, SearchMessages.getString("SearchAgainConfirmationDialog.stale.message"));
        }
        this.createLabel(result, SearchMessages.getString("SearchAgainConfirmationDialog.stale.label"));
        this.createTableViewer(this.fOutOfDate, result);
        return result;
    }

    private void createLabel(Composite parent, String text) {
        Label message = new Label(parent, 64);
        GridData gd = new GridData(768);
        gd.widthHint = this.convertWidthInCharsToPixels(40);
        message.setLayoutData((Object)gd);
        message.setText(text);
    }

    private TableViewer createTableViewer(List input, Composite result) {
        TableViewer viewer = new TableViewer(result);
        viewer.setContentProvider((IContentProvider)new ListContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new ProxyLabelProvider());
        viewer.setInput((Object)input);
        GridData gd = new GridData(1808);
        gd.widthHint = this.convertWidthInCharsToPixels(40);
        gd.heightHint = this.convertHeightInCharsToPixels(5);
        viewer.getControl().setLayoutData((Object)gd);
        return viewer;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(SearchMessages.getString("SearchAgainConfirmationDialog.title"));
    }

    private static class ProxyLabelProvider
    extends LabelProvider {
        private ILabelProvider fLabelProvider;

        ProxyLabelProvider() {
            SearchResultView view = (SearchResultView)SearchPlugin.getSearchResultView();
            this.fLabelProvider = view != null ? view.getLabelProvider() : null;
        }

        public Image getImage(Object element) {
            if (this.fLabelProvider != null) {
                return this.fLabelProvider.getImage(element);
            }
            return null;
        }

        public String getText(Object element) {
            if (this.fLabelProvider != null) {
                return this.fLabelProvider.getText(element);
            }
            return null;
        }
    }
}

