/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.ui;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.search.internal.ui.SearchMessages;
import org.eclipse.search.internal.ui.util.ExceptionHandler;

class SorterDescriptor {
    public static final String SORTER_TAG = "sorter";
    private static final String ID_ATTRIBUTE = "id";
    private static final String PAGE_ID_ATTRIBUTE = "pageId";
    private static final String ICON_ATTRIBUTE = "icon";
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String LABEL_ATTRIBUTE = "label";
    private static final String TOOLTIP_ATTRIBUTE = "tooltip";
    private IConfigurationElement fElement;

    public SorterDescriptor(IConfigurationElement element) {
        this.fElement = element;
    }

    public ViewerSorter createObject() {
        try {
            return (ViewerSorter)this.fElement.createExecutableExtension(CLASS_ATTRIBUTE);
        }
        catch (CoreException ex) {
            ExceptionHandler.handle(ex, SearchMessages.getString("Search.Error.createSorter.title"), SearchMessages.getString("Search.Error.createSorter.message"));
            return null;
        }
        catch (ClassCastException ex) {
            ExceptionHandler.displayMessageDialog(ex, SearchMessages.getString("Search.Error.createSorter.title"), SearchMessages.getString("Search.Error.createSorter.message"));
            return null;
        }
    }

    public String getId() {
        return this.fElement.getAttribute(ID_ATTRIBUTE);
    }

    public ImageDescriptor getImage() {
        URL url;
        String imageName = this.fElement.getAttribute(ICON_ATTRIBUTE);
        if (imageName == null) {
            return null;
        }
        try {
            url = new URL(this.fElement.getDeclaringExtension().getDeclaringPluginDescriptor().getInstallURL(), imageName);
        }
        catch (MalformedURLException ex) {
            ExceptionHandler.log(ex, SearchMessages.getString("Search.Error.createSorter.message"));
            return null;
        }
        return ImageDescriptor.createFromURL((URL)url);
    }

    public String getLabel() {
        return this.fElement.getAttribute(LABEL_ATTRIBUTE);
    }

    public String getToolTipText() {
        return this.fElement.getAttribute(TOOLTIP_ATTRIBUTE);
    }

    public String getPageId() {
        return this.fElement.getAttribute(PAGE_ID_ATTRIBUTE);
    }
}

