/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.ui;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.search.internal.ui.SearchMessages;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.search.internal.ui.util.ExceptionHandler;
import org.eclipse.swt.graphics.Image;

public class SearchPluginImages {
    private static URL fgIconLocation;
    private static final ImageRegistry PLUGIN_REGISTRY;
    public static final String T_OBJ = "obj16/";
    public static final String T_WIZBAN = "wizban/";
    public static final String T_LCL = "lcl16/";
    public static final String T_TOOL = "tool16/";
    public static final String T_VIEW = "view16/";
    private static final String NAME_PREFIX = "org.eclipse.search.ui.";
    private static final int NAME_PREFIX_LENGTH;
    public static final String IMG_TOOL_SEARCH = "org.eclipse.search.ui.search.gif";
    public static final String IMG_LCL_SEARCH_STOP = "org.eclipse.search.ui.search_stop.gif";
    public static final String IMG_LCL_SEARCH_REM = "org.eclipse.search.ui.search_rem.gif";
    public static final String IMG_LCL_SEARCH_REM_ALL = "org.eclipse.search.ui.search_remall.gif";
    public static final String IMG_LCL_SEARCH_NEXT = "org.eclipse.search.ui.search_next.gif";
    public static final String IMG_LCL_SEARCH_PREV = "org.eclipse.search.ui.search_prev.gif";
    public static final String IMG_LCL_SEARCH_GOTO = "org.eclipse.search.ui.search_goto.gif";
    public static final String IMG_LCL_SEARCH_SORT = "org.eclipse.search.ui.search_sortmatch.gif";
    public static final String IMG_LCL_SEARCH_HISTORY = "org.eclipse.search.ui.search_history.gif";
    public static final String IMG_VIEW_SEARCHRES = "org.eclipse.search.ui.searchres.gif";
    public static final String IMG_OBJ_TSEARCH = "org.eclipse.search.ui.tsearch_obj.gif";
    public static final String IMG_OBJ_TSEARCH_DPDN = "org.eclipse.search.ui.tsearch_dpdn_obj.gif";
    public static final String IMG_OBJ_SEARCHMARKER = "org.eclipse.search.ui.searchm_obj.gif";
    public static final ImageDescriptor DESC_OBJ_TSEARCH;
    public static final ImageDescriptor DESC_OBJ_TSEARCH_DPDN;
    public static final ImageDescriptor DESC_OBJ_SEARCHMARKER;

    static {
        String pathSuffix = "icons/full/";
        try {
            fgIconLocation = new URL(SearchPlugin.getDefault().getDescriptor().getInstallURL(), pathSuffix);
        }
        catch (MalformedURLException ex) {
            ExceptionHandler.log(ex, SearchMessages.getString("Search.Error.incorrectIconLocation.message"));
        }
        PLUGIN_REGISTRY = SearchPlugin.getDefault().getImageRegistry();
        NAME_PREFIX_LENGTH = NAME_PREFIX.length();
        DESC_OBJ_TSEARCH = SearchPluginImages.createManaged(T_OBJ, IMG_OBJ_TSEARCH);
        DESC_OBJ_TSEARCH_DPDN = SearchPluginImages.createManaged(T_OBJ, IMG_OBJ_TSEARCH_DPDN);
        DESC_OBJ_SEARCHMARKER = SearchPluginImages.createManaged(T_OBJ, IMG_OBJ_SEARCHMARKER);
    }

    public static Image get(String key) {
        return PLUGIN_REGISTRY.get(key);
    }

    private static ImageDescriptor createManaged(String prefix, String name) {
        ImageDescriptor result = ImageDescriptor.createFromURL((URL)SearchPluginImages.makeIconFileURL(prefix, name.substring(NAME_PREFIX_LENGTH)));
        PLUGIN_REGISTRY.put(name, result);
        return result;
    }

    private static ImageDescriptor create(String prefix, String name) {
        return ImageDescriptor.createFromURL((URL)SearchPluginImages.makeIconFileURL(prefix, name));
    }

    private static URL makeIconFileURL(String prefix, String name) {
        StringBuffer buffer = new StringBuffer(prefix);
        buffer.append(name);
        try {
            return new URL(fgIconLocation, buffer.toString());
        }
        catch (MalformedURLException ex) {
            ExceptionHandler.log(ex, SearchMessages.getString("Search.Error.incorrectIconLocation.message"));
            return null;
        }
    }

    public static void setImageDescriptors(IAction action, String type, String relPath) {
        relPath = relPath.substring(NAME_PREFIX_LENGTH);
        action.setDisabledImageDescriptor(SearchPluginImages.create("d" + type, relPath));
        action.setHoverImageDescriptor(SearchPluginImages.create("c" + type, relPath));
        action.setImageDescriptor(SearchPluginImages.create("e" + type, relPath));
    }
}

