/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.externaltools.internal.ui;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.help.WorkbenchHelp;

public class MessageDialogWithToggle
extends MessageDialog {
    private String fPreferenceKey = null;
    private String fToggleMessage = null;
    private Button fToggleButton = null;
    IPreferenceStore fStore = null;

    public MessageDialogWithToggle(Shell parentShell, String dialogTitle, Image image, String message, int dialogImageType, String[] dialogButtonLabels, int defaultIndex, String preferenceKey, String toggleMessage, IPreferenceStore store) {
        super(parentShell, dialogTitle, image, message, dialogImageType, dialogButtonLabels, defaultIndex);
        this.fStore = store;
        this.fPreferenceKey = preferenceKey;
        this.fToggleMessage = toggleMessage;
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        this.fToggleButton = this.createCheckButton(area, this.fToggleMessage);
        this.getToggleButton().setSelection(this.fStore.getBoolean(this.fPreferenceKey));
        return area;
    }

    protected Button createCheckButton(Composite parent, String label) {
        Button button = new Button(parent, 16416);
        button.setText(label);
        GridData data = new GridData(0);
        data.horizontalSpan = 2;
        data.horizontalAlignment = 2;
        button.setLayoutData((Object)data);
        button.setFont(parent.getFont());
        return button;
    }

    protected void buttonPressed(int id) {
        if (id == 0) {
            this.storePreference();
        }
        super.buttonPressed(id);
    }

    protected void storePreference() {
        this.fStore.setValue(this.fPreferenceKey, !this.getToggleButton().getSelection());
    }

    protected Button getToggleButton() {
        return this.fToggleButton;
    }

    public static boolean openConfirm(Shell parent, String title, String message, String preferenceKey, String toggleMessage, IPreferenceStore store) {
        MessageDialogWithToggle dialog = new MessageDialogWithToggle(parent, title, null, message, 3, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0, preferenceKey, toggleMessage, store);
        return dialog.open() == 0;
    }

    public static void openError(Shell parent, String title, String message, String preferenceKey, String toggleMessage, IPreferenceStore store) {
        MessageDialogWithToggle dialog = new MessageDialogWithToggle(parent, title, null, message, 1, new String[]{IDialogConstants.OK_LABEL}, 0, preferenceKey, toggleMessage, store);
        dialog.open();
    }

    public static void openInformation(Shell parent, String title, String message, String preferenceKey, String toggleMessage, IPreferenceStore store) {
        MessageDialogWithToggle dialog = new MessageDialogWithToggle(parent, title, null, message, 2, new String[]{IDialogConstants.OK_LABEL}, 0, preferenceKey, toggleMessage, store);
        dialog.open();
    }

    public static boolean openQuestion(Shell parent, String title, String message, String preferenceKey, String toggleMessage, IPreferenceStore store) {
        MessageDialogWithToggle dialog = new MessageDialogWithToggle(parent, title, null, message, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0, preferenceKey, toggleMessage, store);
        return dialog.open() == 0;
    }

    public static void openWarning(Shell parent, String title, String message, String preferenceKey, String toggleMessage, IPreferenceStore store) {
        MessageDialogWithToggle dialog = new MessageDialogWithToggle(parent, title, null, message, 4, new String[]{IDialogConstants.OK_LABEL}, 0, preferenceKey, toggleMessage, store);
        dialog.open();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        WorkbenchHelp.setHelp((Control)shell, (String)"org.eclipse.ui.externaltools.message_with_toggle_dialog_context");
    }
}

