/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.externaltools.internal.model;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.externaltools.internal.model.ExternalToolsImages;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public final class ExternalToolsPlugin
extends AbstractUIPlugin {
    public static final IStatus OK_STATUS = new Status(0, "org.eclipse.ui.externaltools", 0, "", null);
    private static ExternalToolsPlugin plugin;
    private static final String EMPTY_STRING = "";

    public ExternalToolsPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        plugin = this;
    }

    public static ExternalToolsPlugin getDefault() {
        return plugin;
    }

    public static IStatus newErrorStatus(String message, Throwable exception) {
        if (message == null) {
            message = EMPTY_STRING;
        }
        return new Status(4, "org.eclipse.ui.externaltools", 0, message, exception);
    }

    public static CoreException newError(String message, Throwable exception) {
        return new CoreException((IStatus)new Status(4, "org.eclipse.ui.externaltools", 0, message, exception));
    }

    public void log(String message, Throwable exception) {
        IStatus status = ExternalToolsPlugin.newErrorStatus(message, exception);
        this.getLog().log(status);
    }

    public void log(Throwable exception) {
        this.getLog().log(ExternalToolsPlugin.newErrorStatus("Internal error logged from External Tools UI: ", exception));
    }

    public ImageDescriptor getImageDescriptor(String path) {
        try {
            URL installURL = this.getDescriptor().getInstallURL();
            URL url = new URL(installURL, path);
            return ImageDescriptor.createFromURL((URL)url);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    protected void initializeDefaultPreferences(IPreferenceStore prefs) {
        prefs.setDefault("externaltools.builders.promptForMigration", true);
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return ExternalToolsPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow window = ExternalToolsPlugin.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getActivePage();
        }
        return null;
    }

    public static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    protected ImageRegistry createImageRegistry() {
        return ExternalToolsImages.initializeImageRegistry();
    }

    public void startup() throws CoreException {
        super.startup();
    }

    public void shutdown() throws CoreException {
        super.shutdown();
        ExternalToolsImages.disposeImageDescriptorRegistry();
    }
}

