/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.externaltools.internal.launchConfigurations;

import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.ui.RefreshTab;
import org.eclipse.ui.externaltools.internal.launchConfigurations.ExternalToolsLaunchConfigurationMessages;
import org.eclipse.ui.externaltools.internal.registry.ExternalToolMigration;

public class ExternalToolsUtil {
    private static final String LAUNCH_CONFIG_HANDLE = "LaunchConfigHandle";
    private static final char ARG_DELIMITER = ' ';
    private static final char ARG_DBL_QUOTE = '\"';
    private static final char ARG_BACKSLASH = '\\';

    private ExternalToolsUtil() {
    }

    protected static void abort(String message, Throwable exception, int code) throws CoreException {
        throw new CoreException((IStatus)new Status(4, "org.eclipse.ui.externaltools", code, message, exception));
    }

    public static IPath getLocation(ILaunchConfiguration configuration) throws CoreException {
        String location = configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", null);
        if (location == null) {
            ExternalToolsUtil.abort(MessageFormat.format(ExternalToolsLaunchConfigurationMessages.getString("ExternalToolsUtil.Location_not_specified_by_{0}_1"), configuration.getName()), null, 0);
        } else {
            String expandedLocation = ExternalToolsUtil.getStringVariableManager().performStringSubstitution(location);
            if (expandedLocation == null || expandedLocation.length() == 0) {
                String msg = MessageFormat.format(ExternalToolsLaunchConfigurationMessages.getString("ExternalToolsUtil.invalidLocation_{0}"), configuration.getName());
                ExternalToolsUtil.abort(msg, null, 0);
            } else {
                File file = new File(expandedLocation);
                if (file.isFile()) {
                    return new Path(expandedLocation);
                }
                String msg = MessageFormat.format(ExternalToolsLaunchConfigurationMessages.getString("ExternalToolsUtil.invalidLocation_{0}"), configuration.getName());
                ExternalToolsUtil.abort(msg, null, 0);
            }
        }
        return null;
    }

    public static boolean getCaptureOutput(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_CAPTURE_OUTPUT", true);
    }

    public static IPath getWorkingDirectory(ILaunchConfiguration configuration) throws CoreException {
        String expandedLocation;
        String location = configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_WORKING_DIRECTORY", null);
        if (location != null && (expandedLocation = ExternalToolsUtil.getStringVariableManager().performStringSubstitution(location)).length() > 0) {
            File path = new File(expandedLocation);
            if (path.isDirectory()) {
                return new Path(expandedLocation);
            }
            String msg = MessageFormat.format(ExternalToolsLaunchConfigurationMessages.getString("ExternalToolsUtil.invalidDirectory_{0}"), expandedLocation, configuration.getName());
            ExternalToolsUtil.abort(msg, null, 0);
        }
        return null;
    }

    public static String[] getArguments(ILaunchConfiguration configuration) throws CoreException {
        String args = configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_TOOL_ARGUMENTS", null);
        if (args != null) {
            String expanded = ExternalToolsUtil.getStringVariableManager().performStringSubstitution(args);
            return ExternalToolsUtil.parseStringIntoList(expanded);
        }
        return null;
    }

    private static IStringVariableManager getStringVariableManager() {
        return VariablesPlugin.getDefault().getStringVariableManager();
    }

    public static boolean isBuilderEnabled(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_BUILDER_ENABLED", true);
    }

    public static IResource[] getResourcesForBuildScope(ILaunchConfiguration configuration) throws CoreException {
        String scope = configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_BUILD_SCOPE", null);
        if (scope == null) {
            return null;
        }
        return RefreshTab.getRefreshResources((String)scope);
    }

    public static ILaunchConfiguration configFromBuildCommandArgs(Map commandArgs) {
        String configHandle = (String)commandArgs.get(LAUNCH_CONFIG_HANDLE);
        if (configHandle == null) {
            return ExternalToolMigration.configFromArgumentMap(commandArgs);
        }
        try {
            return DebugPlugin.getDefault().getLaunchManager().getLaunchConfiguration(configHandle);
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public static String[] parseStringIntoList(String arguments) {
        if (arguments == null || arguments.length() == 0) {
            return new String[0];
        }
        ArrayList<String> list = new ArrayList<String>(10);
        boolean inQuotes = false;
        int start = 0;
        int end = arguments.length();
        StringBuffer buffer = new StringBuffer(end);
        block5: while (start < end) {
            char ch = arguments.charAt(start);
            ++start;
            switch (ch) {
                case ' ': {
                    if (inQuotes) {
                        buffer.append(ch);
                        break;
                    }
                    if (buffer.length() <= 0) continue block5;
                    list.add(buffer.toString());
                    buffer.setLength(0);
                    break;
                }
                case '\\': {
                    if (start < end && arguments.charAt(start) == '\"') {
                        buffer.append('\"');
                        ++start;
                        break;
                    }
                    buffer.append(ch);
                    break;
                }
                case '\"': {
                    inQuotes = !inQuotes;
                    break;
                }
                default: {
                    buffer.append(ch);
                }
            }
        }
        if (buffer.length() > 0) {
            list.add(buffer.toString());
        }
        String[] results = new String[list.size()];
        list.toArray(results);
        return results;
    }
}

