/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal.browser.embedded;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import java.util.StringTokenizer;
import org.eclipse.core.boot.BootLoader;
import org.eclipse.help.ui.internal.HelpUIPlugin;
import org.eclipse.help.ui.internal.browser.embedded.EmbeddedBrowserDialog;
import org.eclipse.help.ui.internal.browser.embedded.EmbeddedBrowserResources;
import org.eclipse.help.ui.internal.browser.embedded.EmbeddedBrowserStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class EmbeddedBrowserHost
implements Runnable {
    public static final String SYS_PROPERTY_DEBUG = "debug";
    public static final String SYS_PROPERTY_LOCALE = "locale";
    public static final String SYS_PROPERTY_INSTALLURL = "installURL";
    public static final String SYS_PROPERTY_PRODUCTIMAGEURL = "windowImage";
    public static final String SYS_PROPERTY_PRODUCTNAME = "name";
    public static final String SYS_PROPERTY_STATELOCATION = "stateLocation";
    public static final String CMD_CLOSE = "close";
    public static final String CMD_DISPLAY_URL = "displayURL";
    public static final String CMD_SET_LOCATION = "setLocation";
    public static final String CMD_SET_SIZE = "setSize";
    private static final String BROWSER_X = "browser.x";
    private static final String BROWSER_Y = "browser.y";
    private static final String BROWSER_WIDTH = "browser.w";
    private static final String BROWSER_HEIGTH = "browser.h";
    private static final String BROWSER_MAXIMIZED = "browser.maximized";
    public static boolean DEBUG = false;
    private static String locale;
    private static String installURL;
    private static String productName;
    private static String productImageURL;
    private static String stateLocation;
    private Display display;
    private Image shellImage;
    Shell shell;
    Browser webBrowser;
    private EmbeddedBrowserResources ieResources;
    EmbeddedBrowserStore store;
    int x;
    int y;
    int w;
    int h;
    boolean closing = false;
    Thread inputReader;
    boolean firstopenning = true;

    public EmbeddedBrowserHost(String installURL, String productImageURL) {
        if (HelpUIPlugin.DEBUG_EMBEDDED_BROWSER) {
            DEBUG = true;
        }
        locale = BootLoader.getNL();
        EmbeddedBrowserHost.installURL = installURL;
        EmbeddedBrowserHost.productImageURL = productImageURL;
        productName = "IN-PROCESS DEBUG MODE";
        stateLocation = HelpUIPlugin.getDefault().getStateLocation().toOSString();
        this.ieResources = new EmbeddedBrowserResources(locale, installURL);
        this.store = new EmbeddedBrowserStore(new File(stateLocation, ".iestore").toString());
        this.store.restore();
        this.shellImage = this.createImage();
        this.createShell();
    }

    private EmbeddedBrowserHost() {
        this.display = new Display();
        this.ieResources = new EmbeddedBrowserResources(locale, installURL);
        this.store = new EmbeddedBrowserStore(new File(stateLocation, ".iestore").toString());
        this.store.restore();
        this.shellImage = this.createImage();
        this.createShell();
        this.inputReader = new Thread(this);
        this.inputReader.setDaemon(true);
        this.inputReader.setName("IE Command Interpreter");
        this.inputReader.start();
    }

    private void runUI() {
        while (!this.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
    }

    public static void main(String[] args) throws Throwable {
        String debug = System.getProperty(SYS_PROPERTY_DEBUG);
        if (debug != null && debug.length() >= 0) {
            DEBUG = true;
        }
        if ((locale = System.getProperty(SYS_PROPERTY_LOCALE)) == null || locale.length() <= 0) {
            System.err.println("Property locale not set, using default.");
            locale = Locale.getDefault().toString();
        }
        if ((installURL = System.getProperty(SYS_PROPERTY_INSTALLURL)) == null || installURL.length() <= 0) {
            System.err.println("Property installURL must be set.");
            return;
        }
        productImageURL = System.getProperty(SYS_PROPERTY_PRODUCTIMAGEURL);
        if (productImageURL == null) {
            System.err.println("Property windowImage must be set.");
            return;
        }
        productName = System.getProperty(SYS_PROPERTY_PRODUCTNAME);
        if (productName == null) {
            System.err.println("Property name must be set.");
            return;
        }
        stateLocation = System.getProperty(SYS_PROPERTY_STATELOCATION);
        if (stateLocation == null || stateLocation.length() <= 0) {
            System.err.println("Property stateLocation must be set.");
            return;
        }
        EmbeddedBrowserHost ie = new EmbeddedBrowserHost();
        ie.runUI();
        ie.dispose();
    }

    private Image createImage() {
        Image shellImg;
        block2: {
            shellImg = null;
            try {
                shellImg = ImageDescriptor.createFromURL((URL)new URL(productImageURL)).createImage();
            }
            catch (MalformedURLException malformedURLException) {
                if ("".equals(productImageURL)) break block2;
                System.out.println("Invalid URL of product image.");
            }
        }
        return shellImg;
    }

    private void dispose() {
        if (HelpUIPlugin.DEBUG_EMBEDDED_BROWSER_IN_PROCESS) {
            this.shell.dispose();
        } else {
            this.display.dispose();
        }
    }

    private void createShell() {
        this.shell = new Shell();
        if (this.shellImage != null) {
            this.shell.setImage(this.shellImage);
        }
        this.shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                EmbeddedBrowserHost.this.closing = true;
                EmbeddedBrowserHost.this.store.put(EmbeddedBrowserHost.BROWSER_X, Integer.toString(EmbeddedBrowserHost.this.x));
                EmbeddedBrowserHost.this.store.put(EmbeddedBrowserHost.BROWSER_Y, Integer.toString(EmbeddedBrowserHost.this.y));
                EmbeddedBrowserHost.this.store.put(EmbeddedBrowserHost.BROWSER_WIDTH, Integer.toString(EmbeddedBrowserHost.this.w));
                EmbeddedBrowserHost.this.store.put(EmbeddedBrowserHost.BROWSER_HEIGTH, Integer.toString(EmbeddedBrowserHost.this.h));
                EmbeddedBrowserHost.this.store.put(EmbeddedBrowserHost.BROWSER_MAXIMIZED, new Boolean(EmbeddedBrowserHost.this.shell.getMaximized()).toString());
                EmbeddedBrowserHost.this.store.save();
                if (!HelpUIPlugin.DEBUG_EMBEDDED_BROWSER_IN_PROCESS && EmbeddedBrowserHost.this.inputReader.isAlive() && !HelpUIPlugin.DEBUG_EMBEDDED_BROWSER_IN_PROCESS) {
                    try {
                        EmbeddedBrowserHost.this.inputReader.join(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        });
        this.shell.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
                if (!EmbeddedBrowserHost.this.shell.getMaximized()) {
                    Point location = EmbeddedBrowserHost.this.shell.getLocation();
                    EmbeddedBrowserHost.this.x = location.x;
                    EmbeddedBrowserHost.this.y = location.y;
                }
            }

            public void controlResized(ControlEvent e) {
                if (!EmbeddedBrowserHost.this.shell.getMaximized()) {
                    Point size = EmbeddedBrowserHost.this.shell.getSize();
                    EmbeddedBrowserHost.this.w = size.x;
                    EmbeddedBrowserHost.this.h = size.y;
                }
            }
        });
        this.shell.setText(productName);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        this.shell.setLayout((Layout)layout);
        this.webBrowser = new Browser((Composite)this.shell, 0);
        GridData data = new GridData(1808);
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        this.webBrowser.setLayoutData((Object)data);
        this.webBrowser.setUrl("about:blank");
        this.x = this.store.getInt(BROWSER_X);
        this.y = this.store.getInt(BROWSER_Y);
        this.w = this.store.getInt(BROWSER_WIDTH);
        this.h = this.store.getInt(BROWSER_HEIGTH);
        if (this.w == 0 || this.h == 0) {
            this.w = 800;
            this.h = 600;
        } else {
            this.shell.setLocation(this.x, this.y);
        }
        this.shell.setSize(this.w, this.h);
        if (this.store.getBoolean(BROWSER_MAXIMIZED)) {
            this.shell.setMaximized(true);
        }
        this.webBrowser.addOpenWindowListener(new OpenWindowListener(){

            public void open(WindowEvent event) {
                EmbeddedBrowserDialog workingSetManagerDialog = new EmbeddedBrowserDialog(EmbeddedBrowserHost.this.shell, productName, EmbeddedBrowserHost.this.createImage());
                event.browser = workingSetManagerDialog.getBrowser();
            }
        });
        this.shell.open();
    }

    public void run() {
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        try {
            String line;
            while (!this.closing && (line = reader.readLine()) != null) {
                if (line.length() <= 0) continue;
                this.executeCommand(line);
                while (!this.closing && System.in.available() <= 0) {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            reader.close();
        }
        catch (IOException e) {
            System.err.println(EmbeddedBrowserResources.getString("WE026", e.getMessage()));
            return;
        }
    }

    public void executeCommand(String line) {
        StringTokenizer tokenizer = new StringTokenizer(line);
        if (!tokenizer.hasMoreTokens()) {
            return;
        }
        String command = tokenizer.nextToken();
        String[] pars = new String[tokenizer.countTokens()];
        int i = 0;
        while (i < pars.length) {
            pars[i] = tokenizer.nextToken();
            ++i;
        }
        if (CMD_DISPLAY_URL.equalsIgnoreCase(command)) {
            if (pars.length >= 1 && pars[0] != null) {
                if (HelpUIPlugin.DEBUG_EMBEDDED_BROWSER_IN_PROCESS) {
                    this.webBrowser.setUrl(pars[0]);
                    if (this.firstopenning) {
                        this.firstopenning = false;
                    } else {
                        this.shell.setVisible(false);
                        this.shell.setMinimized(true);
                    }
                    this.shell.setVisible(true);
                    this.shell.setMinimized(false);
                    this.shell.moveAbove(null);
                    this.shell.forceActive();
                    return;
                }
                this.display.syncExec((Runnable)new DisplayURLCommand(pars[0]));
                this.display.syncExec((Runnable)new MakeVisible());
            }
        } else if (CMD_SET_LOCATION.equalsIgnoreCase(command)) {
            if (pars.length >= 2 && pars[0] != null && pars[1] != null) {
                try {
                    this.display.syncExec((Runnable)new SetLocationCommand(Integer.parseInt(pars[0]), Integer.parseInt(pars[1])));
                }
                catch (NumberFormatException numberFormatException) {}
            }
        } else if (CMD_SET_SIZE.equalsIgnoreCase(command)) {
            if (pars.length >= 2 && pars[0] != null && pars[1] != null) {
                try {
                    this.display.syncExec((Runnable)new SetSizeCommand(Integer.parseInt(pars[0]), Integer.parseInt(pars[1])));
                }
                catch (NumberFormatException numberFormatException) {}
            }
        } else {
            if (CMD_CLOSE.equalsIgnoreCase(command)) {
                if (HelpUIPlugin.DEBUG_EMBEDDED_BROWSER_IN_PROCESS) {
                    this.shell.dispose();
                    return;
                }
                this.display.syncExec((Runnable)new CloseCommand());
                return;
            }
            System.err.println(EmbeddedBrowserResources.getString("WE028", command));
        }
    }

    public boolean isDisposed() {
        return this.shell.isDisposed();
    }

    class SetLocationCommand
    implements Runnable {
        int newX;
        int newY;

        public SetLocationCommand(int x, int y) {
            this.newX = x;
            this.newY = y;
        }

        public void run() {
            EmbeddedBrowserHost.this.shell.setLocation(this.newX, this.newY);
        }
    }

    class SetSizeCommand
    implements Runnable {
        int newX;
        int newY;

        public SetSizeCommand(int x, int y) {
            this.newX = x;
            this.newY = y;
        }

        public void run() {
            EmbeddedBrowserHost.this.shell.setSize(this.newX, this.newY);
        }
    }

    class CloseCommand
    implements Runnable {
        CloseCommand() {
        }

        public void run() {
            EmbeddedBrowserHost.this.shell.dispose();
        }
    }

    class DisplayURLCommand
    implements Runnable {
        String url;

        public DisplayURLCommand(String url) {
            this.url = url;
        }

        public void run() {
            EmbeddedBrowserHost.this.webBrowser.setUrl(this.url);
        }
    }

    class MakeVisible
    implements Runnable {
        MakeVisible() {
        }

        public void run() {
            if (EmbeddedBrowserHost.this.firstopenning) {
                EmbeddedBrowserHost.this.firstopenning = false;
            } else {
                EmbeddedBrowserHost.this.shell.setVisible(false);
                EmbeddedBrowserHost.this.shell.setMinimized(true);
            }
            EmbeddedBrowserHost.this.shell.setVisible(true);
            EmbeddedBrowserHost.this.shell.setMinimized(false);
            EmbeddedBrowserHost.this.shell.moveAbove(null);
            EmbeddedBrowserHost.this.shell.forceActive();
        }
    }
}

