/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal.browser.embedded;

import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.CloseWindowListener;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.VisibilityWindowListener;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class EmbeddedBrowserDialog {
    private String windowTitle;
    private Image shellImg;
    Shell shell;
    Browser webBrowser;

    public EmbeddedBrowserDialog(Shell parent, String windowTitle, Image shellImage) {
        this.windowTitle = windowTitle;
        this.shellImg = shellImage;
        this.createShell(parent);
    }

    private void createShell(Shell parent) {
        this.shell = new Shell(parent, 2144);
        if (this.shellImg != null) {
            this.shell.setImage(this.shellImg);
        }
        this.shell.setText(this.windowTitle);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        this.shell.setLayout((Layout)layout);
        this.webBrowser = new Browser((Composite)this.shell, 0);
        final GridData data = new GridData(1808);
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.widthHint = parent.getSize().x;
        data.heightHint = parent.getSize().y;
        this.webBrowser.setLayoutData((Object)data);
        this.shell.pack();
        this.shell.setLocation(parent.getLocation());
        this.webBrowser.addVisibilityWindowListener(new VisibilityWindowListener(){

            public void hide(WindowEvent event) {
                EmbeddedBrowserDialog.this.shell.setVisible(false);
            }

            public void show(WindowEvent event) {
                if (event.location != null) {
                    EmbeddedBrowserDialog.this.shell.setLocation(event.location);
                }
                if (event.size != null) {
                    data.widthHint = event.size.x;
                    data.heightHint = event.size.y;
                    EmbeddedBrowserDialog.this.shell.pack();
                }
                EmbeddedBrowserDialog.this.shell.open();
            }
        });
        this.webBrowser.addOpenWindowListener(new OpenWindowListener(){

            public void open(WindowEvent event) {
                EmbeddedBrowserDialog workingSetDialog = new EmbeddedBrowserDialog(EmbeddedBrowserDialog.this.shell, EmbeddedBrowserDialog.this.windowTitle, EmbeddedBrowserDialog.this.shellImg);
                event.browser = workingSetDialog.getBrowser();
            }
        });
        this.webBrowser.addCloseWindowListener(new CloseWindowListener(){

            public void close(WindowEvent event) {
                Browser browser = (Browser)event.widget;
                browser.getShell().close();
            }
        });
    }

    public boolean isDisposed() {
        return this.shell.isDisposed();
    }

    public Browser getBrowser() {
        return this.webBrowser;
    }
}

