/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal.browser;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.help.internal.base.HelpBasePlugin;
import org.eclipse.help.internal.browser.BrowserDescriptor;
import org.eclipse.help.internal.browser.BrowserManager;
import org.eclipse.help.ui.internal.HelpUIResources;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.help.WorkbenchHelp;

public class BrowsersPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    protected Table browsersTable;
    private Label customBrowserPathLabel;
    protected Text customBrowserPath;
    private Button customBrowserBrowse;

    protected Control createContents(Composite parent) {
        Font font = parent.getFont();
        WorkbenchHelp.setHelp((Control)parent, (String)"org.eclipse.help.ui.prefPageBrowsers");
        Composite mainComposite = new Composite(parent, 0);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        mainComposite.setLayoutData((Object)data);
        mainComposite.setFont(font);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        mainComposite.setLayout((Layout)layout);
        Label description = new Label(mainComposite, 0);
        description.setFont(font);
        description.setText(HelpUIResources.getString("select_browser"));
        this.createSpacer(mainComposite);
        Label tableDescription = new Label(mainComposite, 0);
        tableDescription.setFont(font);
        tableDescription.setText(HelpUIResources.getString("current_browser"));
        this.browsersTable = new Table(mainComposite, 2080);
        GridData gd = new GridData(1808);
        gd.heightHint = this.convertHeightInCharsToPixels(6);
        this.browsersTable.setLayoutData((Object)gd);
        this.browsersTable.setFont(font);
        this.browsersTable.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selEvent) {
                if (selEvent.detail == 32) {
                    TableItem item = (TableItem)selEvent.item;
                    if (item.getChecked()) {
                        TableItem[] items = BrowsersPreferencePage.this.browsersTable.getItems();
                        int i = 0;
                        while (i < items.length) {
                            if (items[i] != item) {
                                items[i].setChecked(false);
                            }
                            ++i;
                        }
                    } else {
                        item.setChecked(true);
                    }
                    BrowsersPreferencePage.this.setEnabledCustomBrowserPath();
                }
            }

            public void widgetDefaultSelected(SelectionEvent selEvent) {
            }
        });
        BrowserDescriptor[] aDescs = BrowserManager.getInstance().getBrowserDescriptors();
        int i = 0;
        while (i < aDescs.length) {
            TableItem item = new TableItem(this.browsersTable, 0);
            item.setText(aDescs[i].getLabel());
            if (BrowserManager.getInstance().getCurrentBrowserID().equals(aDescs[i].getID())) {
                item.setChecked(true);
            } else {
                item.setChecked(false);
            }
            item.setGrayed(aDescs.length == 1);
            ++i;
        }
        this.createCustomBrowserPathPart(mainComposite);
        return mainComposite;
    }

    protected void createCustomBrowserPathPart(Composite mainComposite) {
        Font font = mainComposite.getFont();
        new Label(mainComposite, 0);
        Composite bPathComposite = new Composite(mainComposite, 0);
        WorkbenchHelp.setHelp((Control)bPathComposite, (String)"org.eclipse.help.ui.prefPageCustomBrowserPath");
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 3;
        bPathComposite.setLayout((Layout)layout);
        bPathComposite.setLayoutData((Object)new GridData(768));
        this.customBrowserPathLabel = new Label(bPathComposite, 16384);
        this.customBrowserPathLabel.setFont(font);
        this.customBrowserPathLabel.setText(HelpUIResources.getString("CustomBrowserPreferencePage.Program"));
        this.customBrowserPath = new Text(bPathComposite, 2048);
        this.customBrowserPath.setLayoutData((Object)new GridData(768));
        this.customBrowserPath.setFont(font);
        this.customBrowserPath.setText(HelpBasePlugin.getDefault().getPluginPreferences().getString("custom_browser_path"));
        this.customBrowserBrowse = new Button(bPathComposite, 0);
        this.customBrowserBrowse.setFont(font);
        this.customBrowserBrowse.setText(HelpUIResources.getString("CustomBrowserPreferencePage.Browse"));
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.heightHint = this.convertVerticalDLUsToPixels(14);
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        data.widthHint = Math.max(widthHint, this.customBrowserBrowse.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.customBrowserBrowse.setLayoutData((Object)data);
        this.customBrowserBrowse.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                FileDialog d = new FileDialog(BrowsersPreferencePage.this.getShell());
                d.setText(HelpUIResources.getString("CustomBrowserPreferencePage.Details"));
                String file = d.open();
                if (file != null) {
                    BrowsersPreferencePage.this.customBrowserPath.setText("\"" + file + "\" %1");
                }
            }
        });
        this.setEnabledCustomBrowserPath();
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        TableItem[] items = this.browsersTable.getItems();
        String defaultBrowserID = BrowserManager.getInstance().getDefaultBrowserID();
        int i = 0;
        while (i < items.length) {
            String browserID = BrowserManager.getInstance().getBrowserDescriptors()[i].getID();
            items[i].setChecked(browserID == defaultBrowserID);
            ++i;
        }
        this.customBrowserPath.setText(HelpBasePlugin.getDefault().getPluginPreferences().getDefaultString("custom_browser_path"));
        this.setEnabledCustomBrowserPath();
        super.performDefaults();
    }

    public boolean performOk() {
        Preferences pref = HelpBasePlugin.getDefault().getPluginPreferences();
        TableItem[] items = this.browsersTable.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].getChecked()) {
                String browserID = BrowserManager.getInstance().getBrowserDescriptors()[i].getID();
                BrowserManager.getInstance().setCurrentBrowserID(browserID);
                pref.setValue("default_browser", browserID);
                break;
            }
            ++i;
        }
        pref.setValue("custom_browser_path", this.customBrowserPath.getText());
        HelpBasePlugin.getDefault().savePluginPreferences();
        return true;
    }

    private void createSpacer(Composite parent) {
        Label spacer = new Label(parent, 0);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1;
        spacer.setLayoutData((Object)data);
    }

    protected void setEnabledCustomBrowserPath() {
        TableItem[] items = this.browsersTable.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].getChecked()) {
                boolean enabled = "org.eclipse.help.base.custombrowser".equals(BrowserManager.getInstance().getBrowserDescriptors()[i].getID());
                this.customBrowserPathLabel.setEnabled(enabled);
                this.customBrowserPath.setEnabled(enabled);
                this.customBrowserBrowse.setEnabled(enabled);
                break;
            }
            ++i;
        }
    }
}

