/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.help.browser.IBrowser;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.base.HelpBasePlugin;
import org.eclipse.help.internal.base.IHelpActivitySupport;
import org.eclipse.help.internal.base.util.IErrorUtil;
import org.eclipse.help.ui.internal.HelpActivitySupport;
import org.eclipse.help.ui.internal.util.ErrorUtil;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class HelpUIPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.help.ui";
    public static boolean DEBUG = false;
    public static boolean DEBUG_EMBEDDED_BROWSER = false;
    public static boolean DEBUG_EMBEDDED_BROWSER_IN_PROCESS = false;
    public static boolean DEBUG_INFOPOP = false;
    private static HelpUIPlugin plugin;

    public static synchronized void logError(String message, Throwable ex) {
        if (message == null) {
            message = "";
        }
        Status errorStatus = new Status(4, PLUGIN_ID, 0, message, ex);
        HelpPlugin.getDefault().getLog().log((IStatus)errorStatus);
    }

    public static synchronized void logWarning(String message) {
        if (HelpPlugin.DEBUG) {
            if (message == null) {
                message = "";
            }
            Status warningStatus = new Status(2, PLUGIN_ID, 0, message, null);
            HelpPlugin.getDefault().getLog().log((IStatus)warningStatus);
        }
    }

    public HelpUIPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        plugin = this;
    }

    public static HelpUIPlugin getDefault() {
        return plugin;
    }

    public void shutdown() throws CoreException {
        super.shutdown();
    }

    public void startup() {
        IWorkbench workbench;
        DEBUG = this.isDebugging();
        if (DEBUG) {
            DEBUG_EMBEDDED_BROWSER = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.help.ui/debug/embeddedBrowser"));
            DEBUG_EMBEDDED_BROWSER_IN_PROCESS = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.help.ui/debug/embeddedBrowser/inprocess"));
            DEBUG_INFOPOP = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.help.ui/debug/infopop"));
        }
        BaseHelpSystem.setDefaultErrorUtil((IErrorUtil)new ErrorUtil());
        if (PlatformUI.isWorkbenchRunning() && (workbench = PlatformUI.getWorkbench()) != null) {
            HelpBasePlugin.setActivitySupport((IHelpActivitySupport)new HelpActivitySupport(workbench));
        }
    }

    public IBrowser getHelpBrowser() {
        return BaseHelpSystem.getHelpBrowser();
    }
}

