/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal;

import java.net.URL;
import org.eclipse.help.IContext;
import org.eclipse.help.IHelpResource;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.ui.internal.HelpUIPlugin;
import org.eclipse.help.ui.internal.HelpUIResources;
import org.eclipse.help.ui.internal.HyperlinkAdapter;
import org.eclipse.help.ui.internal.HyperlinkHandler;
import org.eclipse.help.ui.internal.HyperlinkLabel;
import org.eclipse.help.ui.internal.StyledLineWrapper;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.help.WorkbenchHelp;

public class ContextHelpDialog {
    private static ImageRegistry imgRegistry = null;
    private Color backgroundColour = null;
    private IContext context;
    private Color foregroundColour = null;
    private Color linkColour = null;
    private static HyperlinkHandler linkManager = new HyperlinkHandler();
    protected Shell shell;
    protected String infopopText;

    ContextHelpDialog(IContext context, int x, int y) {
        this.context = context;
        Display display = Display.getCurrent();
        this.backgroundColour = display.getSystemColor(29);
        this.foregroundColour = display.getSystemColor(28);
        this.linkColour = display.getSystemColor(9);
        this.shell = new Shell(display.getActiveShell(), 0);
        if (HelpUIPlugin.DEBUG_INFOPOP) {
            System.out.println("ContextHelpDialog.ContextHelpDialog(): Shell is:" + this.shell.toString());
        }
        WorkbenchHelp.setHelp((Control)this.shell, (String)"org.eclipse.help.ui.f1Shell");
        this.shell.addListener(27, new Listener(){

            public void handleEvent(Event e) {
                if (HelpUIPlugin.DEBUG_INFOPOP) {
                    System.out.println("ContextHelpDialog shell deactivate listener: SWT.Deactivate called. ");
                }
                ContextHelpDialog.this.close();
            }
        });
        this.shell.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2) {
                    if (HelpUIPlugin.DEBUG_INFOPOP) {
                        System.out.println("ContextHelpDialog: shell traverse listener: SWT.TRAVERSE_ESCAPE called. ");
                    }
                    e.doit = true;
                }
            }
        });
        this.shell.addControlListener((ControlListener)new ControlAdapter(){

            public void controlMoved(ControlEvent e) {
                if (HelpUIPlugin.DEBUG_INFOPOP) {
                    System.out.println("ContextHelpDialog: shell control adapter called.");
                }
                Rectangle clientArea = ContextHelpDialog.this.shell.getClientArea();
                ContextHelpDialog.this.shell.redraw(clientArea.x, clientArea.y, clientArea.width, clientArea.height, true);
                ContextHelpDialog.this.shell.update();
            }
        });
        if (HelpUIPlugin.DEBUG_INFOPOP) {
            System.out.println("ContextHelpDialog.ContextHelpDialog(): Focus owner is: " + Display.getCurrent().getFocusControl().toString());
        }
        linkManager.setHyperlinkUnderlineMode(3);
        this.createContents((Composite)this.shell);
        this.shell.pack();
        int width = this.shell.getBounds().width;
        int height = this.shell.getBounds().height;
        x = x >= 0 ? x : 0;
        y = y >= 0 ? y : 0;
        Rectangle screen = display.getClientArea();
        x = x + width <= screen.width ? x : screen.width - width;
        y = y + height <= screen.height ? y : screen.height - height;
        this.shell.setLocation(x, y);
        this.initAccessible((Control)this.shell);
    }

    public synchronized void close() {
        try {
            if (HelpUIPlugin.DEBUG_INFOPOP) {
                System.out.println("ContextHelpDialog.close()");
            }
            if (this.shell != null) {
                this.shell.close();
                if (!this.shell.isDisposed()) {
                    this.shell.dispose();
                }
                this.shell = null;
            }
        }
        catch (Throwable throwable) {}
    }

    protected Control createContents(Composite contents) {
        this.initAccessible((Control)contents);
        contents.setBackground(this.backgroundColour);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        contents.setLayout((Layout)layout);
        contents.setLayoutData((Object)new GridData(1808));
        this.createInfoArea(contents);
        Control c = this.createLinksArea(contents);
        if (c != null) {
            contents.setTabList(new Control[]{c});
        }
        return contents;
    }

    private Control createInfoArea(Composite parent) {
        String styledText = this.context.getText();
        if (styledText == null) {
            styledText = HelpUIResources.getString("WW002");
        }
        Description text = new Description(parent, 10);
        text.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2) {
                    if (HelpUIPlugin.DEBUG_INFOPOP) {
                        System.out.println("ContextHelpDialog text TraverseListener.handleEvent(): SWT.TRAVERSE_ESCAPE.");
                    }
                    e.doit = true;
                }
            }
        });
        text.getCaret().setVisible(false);
        text.setBackground(this.backgroundColour);
        text.setForeground(this.foregroundColour);
        text.setFont(parent.getFont());
        StyledLineWrapper content = new StyledLineWrapper(styledText);
        text.setContent(content);
        text.setStyleRanges(content.getStyles());
        this.infopopText = text.getText();
        this.initAccessible((Control)text);
        return text;
    }

    private Control createLink(Composite parent, IHelpResource topic) {
        Label image = new Label(parent, 0);
        image.setImage(this.getImage());
        image.setBackground(this.backgroundColour);
        GridData data = new GridData();
        data.horizontalAlignment = 32;
        data.verticalAlignment = 2;
        image.setLayoutData((Object)data);
        HyperlinkLabel link = new HyperlinkLabel(parent, 0);
        link.setText(topic.getLabel());
        link.setBackground(this.backgroundColour);
        link.setForeground(this.linkColour);
        link.setFont(parent.getFont());
        linkManager.registerHyperlink((Control)link, new LinkListener(topic));
        return link;
    }

    private Control createLinksArea(Composite parent) {
        IHelpResource[] relatedTopics = this.context.getRelatedTopics();
        if (relatedTopics == null) {
            return null;
        }
        Composite composite = new Composite(parent, 0);
        this.initAccessible((Control)composite);
        composite.setBackground(this.backgroundColour);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 2;
        layout.marginWidth = 0;
        layout.verticalSpacing = 3;
        layout.horizontalSpacing = 2;
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        composite.setFont(parent.getFont());
        GridData data = new GridData(1844);
        composite.setLayoutData((Object)data);
        Label label = new Label(composite, 258);
        label.setBackground(this.backgroundColour);
        label.setForeground(this.foregroundColour);
        data = new GridData(802);
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        int i = 0;
        while (i < relatedTopics.length) {
            this.createLink(composite, relatedTopics[i]);
            ++i;
        }
        return composite;
    }

    protected void launchLinks(IHelpResource selectedTopic) {
        this.close();
        if (HelpUIPlugin.DEBUG_INFOPOP) {
            System.out.println("ContextHelpDialog.launchLinks(): closed shell");
        }
        BaseHelpSystem.getHelpDisplay().displayHelp(this.context, selectedTopic);
    }

    public synchronized void open() {
        try {
            this.shell.open();
            if (HelpUIPlugin.DEBUG_INFOPOP) {
                System.out.println("ContextHelpDialog.open(): Focus owner after open is: " + Display.getCurrent().getFocusControl().toString());
            }
        }
        catch (Throwable e) {
            HelpUIPlugin.logError(HelpUIResources.getString("ContextHelpDialog.open"), e);
        }
    }

    private Image getImage() {
        if (imgRegistry == null) {
            imgRegistry = HelpUIPlugin.getDefault().getImageRegistry();
            imgRegistry.put("f1_topic_icon", ImageDescriptor.createFromURL((URL)HelpUIResources.getImagePath("topic.gif")));
        }
        return imgRegistry.get("f1_topic_icon");
    }

    public boolean isShowing() {
        return this.shell != null && !this.shell.isDisposed() && this.shell.isVisible();
    }

    private void initAccessible(final Control control) {
        Accessible accessible = control.getAccessible();
        accessible.addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = ContextHelpDialog.this.infopopText;
            }

            public void getHelp(AccessibleEvent e) {
                e.result = control.getToolTipText();
            }
        });
        accessible.addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getChildAtPoint(AccessibleControlEvent e) {
                Point pt = control.toControl(new Point(e.x, e.y));
                e.childID = control.getBounds().contains(pt) ? -3 : -2;
            }

            public void getLocation(AccessibleControlEvent e) {
                Rectangle location = control.getBounds();
                Point pt = control.toDisplay(new Point(location.x, location.y));
                e.x = pt.x;
                e.y = pt.y;
                e.width = location.width;
                e.height = location.height;
            }

            public void getChildCount(AccessibleControlEvent e) {
                e.detail = 1;
            }

            public void getRole(AccessibleControlEvent e) {
                e.detail = 41;
            }

            public void getState(AccessibleControlEvent e) {
                e.detail = 64;
            }
        });
    }

    class LinkListener
    extends HyperlinkAdapter {
        IHelpResource topic;

        public LinkListener(IHelpResource topic) {
            this.topic = topic;
        }

        public void linkActivated(Control c) {
            ContextHelpDialog.this.launchLinks(this.topic);
        }
    }

    public class Description
    extends StyledText {
        public Description(Composite parent, int style) {
            super(parent, style);
        }

        public boolean setFocus() {
            return false;
        }

        public boolean isFocusControl() {
            return false;
        }
    }
}

