/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.wizards.datatransfer;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.dialogs.FileSystemElement;
import org.eclipse.ui.dialogs.WizardResourceImportPage;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.ide.dialogs.IElementFilter;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.wizards.datatransfer.DataTransferMessages;
import org.eclipse.ui.wizards.datatransfer.FileSystemStructureProvider;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;
import org.eclipse.ui.wizards.datatransfer.MinimizedFileSystemElement;

class WizardFileSystemResourceImportPage1
extends WizardResourceImportPage
implements Listener {
    protected Combo sourceNameField;
    protected Button overwriteExistingResourcesCheckbox;
    protected Button createContainerStructureButton;
    protected Button createOnlySelectedButton;
    protected Button sourceBrowseButton;
    protected Button selectTypesButton;
    protected Button selectAllButton;
    protected Button deselectAllButton;
    private boolean entryChanged = false;
    private static final String STORE_SOURCE_NAMES_ID = "WizardFileSystemResourceImportPage1.STORE_SOURCE_NAMES_ID";
    private static final String STORE_OVERWRITE_EXISTING_RESOURCES_ID = "WizardFileSystemResourceImportPage1.STORE_OVERWRITE_EXISTING_RESOURCES_ID";
    private static final String STORE_CREATE_CONTAINER_STRUCTURE_ID = "WizardFileSystemResourceImportPage1.STORE_CREATE_CONTAINER_STRUCTURE_ID";
    private static final String SELECT_TYPES_TITLE = DataTransferMessages.getString("DataTransfer.selectTypes");
    private static final String SELECT_ALL_TITLE = DataTransferMessages.getString("DataTransfer.selectAll");
    private static final String DESELECT_ALL_TITLE = DataTransferMessages.getString("DataTransfer.deselectAll");
    private static final String SELECT_SOURCE_TITLE = DataTransferMessages.getString("FileImport.selectSourceTitle");
    private static final String SELECT_SOURCE_MESSAGE = DataTransferMessages.getString("FileImport.selectSource");
    protected static final String SOURCE_EMPTY_MESSAGE = DataTransferMessages.getString("FileImport.sourceEmpty");

    protected WizardFileSystemResourceImportPage1(String name, IWorkbench aWorkbench, IStructuredSelection selection) {
        super(name, selection);
    }

    public WizardFileSystemResourceImportPage1(IWorkbench aWorkbench, IStructuredSelection selection) {
        this("fileSystemImportPage1", aWorkbench, selection);
        this.setTitle(DataTransferMessages.getString("DataTransfer.fileSystemTitle"));
        this.setDescription(DataTransferMessages.getString("FileImport.importFileSystem"));
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        ++((GridLayout)parent.getLayout()).numColumns;
        Button button = new Button(parent, 8);
        button.setFont(parent.getFont());
        GridData buttonData = new GridData(768);
        button.setLayoutData((Object)buttonData);
        button.setData((Object)new Integer(id));
        button.setText(label);
        if (defaultButton) {
            Shell shell = parent.getShell();
            if (shell != null) {
                shell.setDefaultButton(button);
            }
            button.setFocus();
        }
        return button;
    }

    protected final void createButtonsGroup(Composite parent) {
        Composite buttonComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = true;
        buttonComposite.setLayout((Layout)layout);
        buttonComposite.setFont(parent.getFont());
        GridData buttonData = new GridData(272);
        buttonData.horizontalSpan = 2;
        buttonComposite.setLayoutData((Object)buttonData);
        this.selectTypesButton = this.createButton(buttonComposite, 20, SELECT_TYPES_TITLE, false);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WizardFileSystemResourceImportPage1.this.handleTypesEditButtonPressed();
            }
        };
        this.selectTypesButton.addSelectionListener((SelectionListener)listener);
        this.setButtonLayoutData(this.selectTypesButton);
        this.selectAllButton = this.createButton(buttonComposite, 18, SELECT_ALL_TITLE, false);
        listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WizardFileSystemResourceImportPage1.this.setAllSelections(true);
            }
        };
        this.selectAllButton.addSelectionListener((SelectionListener)listener);
        this.setButtonLayoutData(this.selectAllButton);
        this.deselectAllButton = this.createButton(buttonComposite, 19, DESELECT_ALL_TITLE, false);
        listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WizardFileSystemResourceImportPage1.this.setAllSelections(false);
            }
        };
        this.deselectAllButton.addSelectionListener((SelectionListener)listener);
        this.setButtonLayoutData(this.deselectAllButton);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.validateSourceGroup();
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)"org.eclipse.ui.file_system_import_wizard_page");
    }

    protected void createOptionsGroupButtons(Group optionsGroup) {
        this.overwriteExistingResourcesCheckbox = new Button((Composite)optionsGroup, 32);
        this.overwriteExistingResourcesCheckbox.setFont(optionsGroup.getFont());
        this.overwriteExistingResourcesCheckbox.setText(DataTransferMessages.getString("FileImport.overwriteExisting"));
        this.createContainerStructureButton = new Button((Composite)optionsGroup, 16);
        this.createContainerStructureButton.setFont(optionsGroup.getFont());
        this.createContainerStructureButton.setText(DataTransferMessages.getString("FileImport.createComplete"));
        this.createContainerStructureButton.setSelection(false);
        this.createOnlySelectedButton = new Button((Composite)optionsGroup, 16);
        this.createOnlySelectedButton.setFont(optionsGroup.getFont());
        this.createOnlySelectedButton.setText(DataTransferMessages.getString("FileImport.createSelectedFolders"));
        this.createOnlySelectedButton.setSelection(true);
    }

    protected void createRootDirectoryGroup(Composite parent) {
        Composite sourceContainerGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        sourceContainerGroup.setLayout((Layout)layout);
        sourceContainerGroup.setFont(parent.getFont());
        sourceContainerGroup.setLayoutData((Object)new GridData(768));
        Label groupLabel = new Label(sourceContainerGroup, 0);
        groupLabel.setText(this.getSourceLabel());
        groupLabel.setFont(parent.getFont());
        this.sourceNameField = new Combo(sourceContainerGroup, 2048);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.sourceNameField.setLayoutData((Object)data);
        this.sourceNameField.setFont(parent.getFont());
        this.sourceNameField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WizardFileSystemResourceImportPage1.this.updateFromSourceField();
            }
        });
        this.sourceNameField.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                WizardFileSystemResourceImportPage1.this.entryChanged = true;
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.sourceNameField.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                if (WizardFileSystemResourceImportPage1.this.entryChanged) {
                    WizardFileSystemResourceImportPage1.this.entryChanged = false;
                    WizardFileSystemResourceImportPage1.this.updateFromSourceField();
                }
            }
        });
        this.sourceBrowseButton = new Button(sourceContainerGroup, 8);
        this.sourceBrowseButton.setText(DataTransferMessages.getString("DataTransfer.browse"));
        this.sourceBrowseButton.addListener(13, (Listener)this);
        this.sourceBrowseButton.setLayoutData((Object)new GridData(256));
        this.sourceBrowseButton.setFont(parent.getFont());
        this.setButtonLayoutData(this.sourceBrowseButton);
    }

    private void updateFromSourceField() {
        this.setSourceName(this.sourceNameField.getText());
        this.updateWidgetEnablements();
    }

    protected MinimizedFileSystemElement createRootElement(Object fileSystemObject, IImportStructureProvider provider) {
        boolean isContainer = provider.isFolder(fileSystemObject);
        String elementLabel = provider.getLabel(fileSystemObject);
        MinimizedFileSystemElement dummyParent = new MinimizedFileSystemElement("", null, true);
        dummyParent.setPopulated();
        MinimizedFileSystemElement result = new MinimizedFileSystemElement(elementLabel, dummyParent, isContainer);
        result.setFileSystemObject(fileSystemObject);
        result.getFiles(provider);
        return dummyParent;
    }

    protected void createSourceGroup(Composite parent) {
        this.createRootDirectoryGroup(parent);
        this.createFileSelectionGroup(parent);
        this.createButtonsGroup(parent);
    }

    protected void enableButtonGroup(boolean enable) {
        this.selectTypesButton.setEnabled(enable);
        this.selectAllButton.setEnabled(enable);
        this.deselectAllButton.setEnabled(enable);
    }

    protected boolean ensureSourceIsValid() {
        if (new File(this.getSourceDirectoryName()).isDirectory()) {
            return true;
        }
        this.displayErrorDialog(DataTransferMessages.getString("FileImport.invalidSource"));
        this.sourceNameField.setFocus();
        return false;
    }

    protected boolean executeImportOperation(ImportOperation op) {
        this.initializeOperation(op);
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            this.displayErrorDialog(e.getTargetException());
            return false;
        }
        IStatus status = op.getStatus();
        if (!status.isOK()) {
            ErrorDialog.openError((Shell)this.getContainer().getShell(), (String)DataTransferMessages.getString("FileImport.importProblems"), null, (IStatus)status);
            return false;
        }
        return true;
    }

    public boolean finish() {
        if (!this.ensureSourceIsValid()) {
            return false;
        }
        this.saveWidgetValues();
        Iterator resourcesEnum = this.getSelectedResources().iterator();
        ArrayList<Object> fileSystemObjects = new ArrayList<Object>();
        while (resourcesEnum.hasNext()) {
            fileSystemObjects.add(((FileSystemElement)resourcesEnum.next()).getFileSystemObject());
        }
        if (fileSystemObjects.size() > 0) {
            return this.importResources(fileSystemObjects);
        }
        MessageDialog.openInformation((Shell)this.getContainer().getShell(), (String)DataTransferMessages.getString("DataTransfer.information"), (String)DataTransferMessages.getString("FileImport.noneSelected"));
        return false;
    }

    protected ITreeContentProvider getFileProvider() {
        return new WorkbenchContentProvider(){

            public Object[] getChildren(Object o) {
                if (o instanceof MinimizedFileSystemElement) {
                    MinimizedFileSystemElement element = (MinimizedFileSystemElement)((Object)o);
                    return element.getFiles(FileSystemStructureProvider.INSTANCE).getChildren((Object)element);
                }
                return new Object[0];
            }
        };
    }

    protected MinimizedFileSystemElement getFileSystemTree() {
        File sourceDirectory = this.getSourceDirectory();
        if (sourceDirectory == null) {
            return null;
        }
        return this.selectFiles(sourceDirectory, FileSystemStructureProvider.INSTANCE);
    }

    protected ITreeContentProvider getFolderProvider() {
        return new WorkbenchContentProvider(){

            public Object[] getChildren(Object o) {
                if (o instanceof MinimizedFileSystemElement) {
                    MinimizedFileSystemElement element = (MinimizedFileSystemElement)((Object)o);
                    return element.getFolders(FileSystemStructureProvider.INSTANCE).getChildren((Object)element);
                }
                return new Object[0];
            }

            public boolean hasChildren(Object o) {
                if (o instanceof MinimizedFileSystemElement) {
                    MinimizedFileSystemElement element = (MinimizedFileSystemElement)((Object)o);
                    if (element.isPopulated()) {
                        return this.getChildren((Object)element).length > 0;
                    }
                    return true;
                }
                return false;
            }
        };
    }

    protected File getSourceDirectory() {
        return this.getSourceDirectory(this.sourceNameField.getText());
    }

    private File getSourceDirectory(String path) {
        File sourceDirectory = new File(this.getSourceDirectoryName(path));
        if (!sourceDirectory.exists() || !sourceDirectory.isDirectory()) {
            return null;
        }
        return sourceDirectory;
    }

    private String getSourceDirectoryName() {
        return this.getSourceDirectoryName(this.sourceNameField.getText());
    }

    private String getSourceDirectoryName(String sourceName) {
        Path result = new Path(sourceName.trim());
        result = result.getDevice() != null && result.segmentCount() == 0 ? result.addTrailingSeparator() : result.removeTrailingSeparator();
        return result.toOSString();
    }

    protected String getSourceLabel() {
        return DataTransferMessages.getString("FileImport.fromDirectory");
    }

    public void handleEvent(Event event) {
        if (event.widget == this.sourceBrowseButton) {
            this.handleSourceBrowseButtonPressed();
        }
        super.handleEvent(event);
    }

    protected void handleSourceBrowseButtonPressed() {
        String currentSource = this.sourceNameField.getText();
        DirectoryDialog dialog = new DirectoryDialog(this.sourceNameField.getShell(), 8192);
        dialog.setText(SELECT_SOURCE_TITLE);
        dialog.setMessage(SELECT_SOURCE_MESSAGE);
        dialog.setFilterPath(this.getSourceDirectoryName(currentSource));
        String selectedDirectory = dialog.open();
        if (selectedDirectory != null) {
            if (this.getSourceDirectory(selectedDirectory) == null || selectedDirectory.equals(currentSource)) {
                return;
            }
            this.setErrorMessage(null);
            this.setSourceName(selectedDirectory);
            this.selectionGroup.setFocus();
        }
    }

    protected void handleTypesEditButtonPressed() {
        super.handleTypesEditButtonPressed();
    }

    protected boolean importResources(List fileSystemObjects) {
        ImportOperation operation = new ImportOperation(this.getContainerFullPath(), this.getSourceDirectory(), FileSystemStructureProvider.INSTANCE, this, fileSystemObjects);
        operation.setContext(this.getShell());
        return this.executeImportOperation(operation);
    }

    protected void initializeOperation(ImportOperation op) {
        op.setCreateContainerStructure(this.createContainerStructureButton.getSelection());
        op.setOverwriteResources(this.overwriteExistingResourcesCheckbox.getSelection());
    }

    protected boolean isExportableExtension(String extension) {
        if (this.selectedTypes == null) {
            return true;
        }
        Iterator iterator = this.selectedTypes.iterator();
        while (iterator.hasNext()) {
            if (!extension.equalsIgnoreCase((String)iterator.next())) continue;
            return true;
        }
        return false;
    }

    protected void resetSelection() {
        MinimizedFileSystemElement currentRoot = this.getFileSystemTree();
        this.selectionGroup.setRoot((Object)currentRoot);
    }

    protected void restoreWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] sourceNames = settings.getArray(STORE_SOURCE_NAMES_ID);
            if (sourceNames == null) {
                return;
            }
            int i = 0;
            while (i < sourceNames.length) {
                this.sourceNameField.add(sourceNames[i]);
                ++i;
            }
            this.overwriteExistingResourcesCheckbox.setSelection(settings.getBoolean(STORE_OVERWRITE_EXISTING_RESOURCES_ID));
            boolean createStructure = settings.getBoolean(STORE_CREATE_CONTAINER_STRUCTURE_ID);
            this.createContainerStructureButton.setSelection(createStructure);
            this.createOnlySelectedButton.setSelection(!createStructure);
        }
    }

    protected void saveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] sourceNames = settings.getArray(STORE_SOURCE_NAMES_ID);
            if (sourceNames == null) {
                sourceNames = new String[]{};
            }
            sourceNames = this.addToHistory(sourceNames, this.getSourceDirectoryName());
            settings.put(STORE_SOURCE_NAMES_ID, sourceNames);
            settings.put(STORE_OVERWRITE_EXISTING_RESOURCES_ID, this.overwriteExistingResourcesCheckbox.getSelection());
            settings.put(STORE_CREATE_CONTAINER_STRUCTURE_ID, this.createContainerStructureButton.getSelection());
        }
    }

    protected MinimizedFileSystemElement selectFiles(final Object rootFileSystemObject, final IImportStructureProvider structureProvider) {
        final MinimizedFileSystemElement[] results = new MinimizedFileSystemElement[1];
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                results[0] = WizardFileSystemResourceImportPage1.this.createRootElement(rootFileSystemObject, structureProvider);
            }
        });
        return results[0];
    }

    protected void setAllSelections(boolean value) {
        super.setAllSelections(value);
    }

    protected void setSourceName(String path) {
        if (path.length() > 0) {
            String[] currentItems = this.sourceNameField.getItems();
            int selectionIndex = -1;
            int i = 0;
            while (i < currentItems.length) {
                if (currentItems[i].equals(path)) {
                    selectionIndex = i;
                }
                ++i;
            }
            if (selectionIndex < 0) {
                int oldLength = currentItems.length;
                String[] newItems = new String[oldLength + 1];
                System.arraycopy(currentItems, 0, newItems, 0, oldLength);
                newItems[oldLength] = path;
                this.sourceNameField.setItems(newItems);
                selectionIndex = oldLength;
            }
            this.sourceNameField.select(selectionIndex);
            this.resetSelection();
        }
    }

    protected void setupSelectionsBasedOnSelectedTypes() {
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.getContainer().getShell());
        final Hashtable selectionMap = new Hashtable();
        final IElementFilter filter = new IElementFilter(){

            public void filterElements(Collection files, IProgressMonitor monitor) throws InterruptedException {
                if (files == null) {
                    throw new InterruptedException();
                }
                Iterator filesList = files.iterator();
                while (filesList.hasNext()) {
                    if (monitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                    this.checkFile(filesList.next());
                }
            }

            public void filterElements(Object[] files, IProgressMonitor monitor) throws InterruptedException {
                if (files == null) {
                    throw new InterruptedException();
                }
                int i = 0;
                while (i < files.length) {
                    if (monitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                    this.checkFile(files[i]);
                    ++i;
                }
            }

            private void checkFile(Object fileElement) {
                MinimizedFileSystemElement file = (MinimizedFileSystemElement)((Object)fileElement);
                if (WizardFileSystemResourceImportPage1.this.isExportableExtension(file.getFileNameExtension())) {
                    List<MinimizedFileSystemElement> elements = new ArrayList<MinimizedFileSystemElement>();
                    FileSystemElement parent = file.getParent();
                    if (selectionMap.containsKey(parent)) {
                        elements = (List)selectionMap.get(parent);
                    }
                    elements.add(file);
                    selectionMap.put(parent, elements);
                }
            }
        };
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InterruptedException {
                monitor.beginTask(DataTransferMessages.getString("ImportPage.filterSelections"), -1);
                WizardFileSystemResourceImportPage1.this.getSelectedResources(filter, monitor);
            }
        };
        try {
            dialog.run(true, true, runnable);
        }
        catch (InvocationTargetException invocationTargetException) {
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        this.getShell().update();
        if (selectionMap != null) {
            this.updateSelections(selectionMap);
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.resetSelection();
        if (visible) {
            this.sourceNameField.setFocus();
        }
    }

    protected void updateSelections(Map map) {
        super.updateSelections(map);
    }

    protected void updateWidgetEnablements() {
        super.updateWidgetEnablements();
    }

    protected boolean validateSourceGroup() {
        File sourceDirectory = this.getSourceDirectory();
        if (sourceDirectory == null) {
            this.setMessage(SOURCE_EMPTY_MESSAGE);
            this.enableButtonGroup(false);
            return false;
        }
        if (this.sourceConflictsWithDestination((IPath)new Path(sourceDirectory.getPath()))) {
            this.setErrorMessage(this.getSourceConflictMessage());
            this.enableButtonGroup(false);
            return false;
        }
        this.enableButtonGroup(true);
        return true;
    }

    protected boolean sourceConflictsWithDestination(IPath sourcePath) {
        IContainer container = this.getSpecifiedContainer();
        if (container == null) {
            return false;
        }
        IPath destinationLocation = this.getSpecifiedContainer().getLocation();
        if (destinationLocation != null) {
            return destinationLocation.isPrefixOf(sourcePath);
        }
        return false;
    }
}

