/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.tasklist;

import java.net.MalformedURLException;
import java.net.URL;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.views.tasklist.IMarkerConstants;
import org.eclipse.ui.views.tasklist.TaskList;
import org.eclipse.ui.views.tasklist.TaskListMessages;

class MarkerUtil
implements IMarkerConstants {
    private static Map imageDescriptors;
    private static ImageRegistry imageRegistry;
    private static MessageFormat line;
    private static MessageFormat lineAndLocation;

    static {
        imageRegistry = new ImageRegistry();
        line = new MessageFormat(TaskListMessages.getString("TaskList.line"));
        lineAndLocation = new MessageFormat(TaskListMessages.getString("TaskList.lineAndLocation"));
        MarkerUtil.createImageDescriptors();
    }

    private MarkerUtil() {
    }

    static ImageDescriptor createImageDescriptor(String relativePath) {
        String iconPath = "icons/full/";
        try {
            URL URL_BASIC = TaskList.getPlugin().getDescriptor().getInstallURL();
            URL url = new URL(URL_BASIC, String.valueOf(iconPath) + relativePath);
            return ImageDescriptor.createFromURL((URL)url);
        }
        catch (MalformedURLException malformedURLException) {
            Assert.isTrue((boolean)false);
            return null;
        }
    }

    static void createImageDescriptors() {
        String LOCAL = "clcl16/";
        String LOCAL_GREY = "elcl16/";
        String LOCAL_DISABLED = "dlcl16/";
        String OBJ = "obj16/";
        imageDescriptors = new HashMap(51);
        imageDescriptors.put("header_complete", MarkerUtil.createImageDescriptor("obj16/header_complete.gif"));
        imageDescriptors.put("header_priority", MarkerUtil.createImageDescriptor("obj16/header_priority.gif"));
        imageDescriptors.put("task", MarkerUtil.createImageDescriptor(String.valueOf(OBJ) + "taskmrk_tsk.gif"));
        imageDescriptors.put("error", MarkerUtil.createImageDescriptor(String.valueOf(OBJ) + "error_tsk.gif"));
        imageDescriptors.put("warn", MarkerUtil.createImageDescriptor(String.valueOf(OBJ) + "warn_tsk.gif"));
        imageDescriptors.put("info", MarkerUtil.createImageDescriptor(String.valueOf(OBJ) + "info_tsk.gif"));
        imageDescriptors.put("hprio", MarkerUtil.createImageDescriptor(String.valueOf(OBJ) + "hprio_tsk.gif"));
        imageDescriptors.put("lprio", MarkerUtil.createImageDescriptor(String.valueOf(OBJ) + "lprio_tsk.gif"));
        imageDescriptors.put("complete_tsk", MarkerUtil.createImageDescriptor(String.valueOf(OBJ) + "complete_tsk.gif"));
        imageDescriptors.put("incomplete_tsk", MarkerUtil.createImageDescriptor(String.valueOf(OBJ) + "incomplete_tsk.gif"));
        imageDescriptors.put("gotoobj", MarkerUtil.createImageDescriptor(String.valueOf(LOCAL) + "gotoobj_tsk.gif"));
        imageDescriptors.put("gotoobj_grey", MarkerUtil.createImageDescriptor(String.valueOf(LOCAL_GREY) + "gotoobj_tsk.gif"));
        imageDescriptors.put("addtsk", MarkerUtil.createImageDescriptor(String.valueOf(LOCAL) + "addtsk_tsk.gif"));
        imageDescriptors.put("addtsk_grey", MarkerUtil.createImageDescriptor(String.valueOf(LOCAL_GREY) + "addtsk_tsk.gif"));
        imageDescriptors.put("addtsk_disabled", MarkerUtil.createImageDescriptor(String.valueOf(LOCAL_DISABLED) + "addtsk_tsk.gif"));
        imageDescriptors.put("showcomplete", MarkerUtil.createImageDescriptor(String.valueOf(LOCAL) + "showcomplete_tsk.gif"));
        imageDescriptors.put("selected_mode", MarkerUtil.createImageDescriptor(String.valueOf(LOCAL) + "selected_mode.gif"));
        imageDescriptors.put("selected_mode_grey", MarkerUtil.createImageDescriptor(String.valueOf(LOCAL_GREY) + "selected_mode.gif"));
        imageDescriptors.put("selected_mode_disabled", MarkerUtil.createImageDescriptor(String.valueOf(LOCAL_DISABLED) + "selected_mode.gif"));
        imageDescriptors.put("showchild_mode", MarkerUtil.createImageDescriptor(String.valueOf(LOCAL) + "showchild_mode.gif"));
        imageDescriptors.put("showchild_mode_grey", MarkerUtil.createImageDescriptor(String.valueOf(LOCAL_GREY) + "showchild_mode.gif"));
        imageDescriptors.put("showchild_mode_disabled", MarkerUtil.createImageDescriptor(String.valueOf(LOCAL_DISABLED) + "showchild_mode.gif"));
        imageDescriptors.put("showerr_grey", MarkerUtil.createImageDescriptor(String.valueOf(LOCAL_GREY) + "showerr_tsk.gif"));
        imageDescriptors.put("showerr_disabled", MarkerUtil.createImageDescriptor(String.valueOf(LOCAL_DISABLED) + "showerr_tsk.gif"));
        imageDescriptors.put("showwarn_grey", MarkerUtil.createImageDescriptor(String.valueOf(LOCAL_GREY) + "showwarn_tsk.gif"));
        imageDescriptors.put("showwarn_disabled", MarkerUtil.createImageDescriptor(String.valueOf(LOCAL_DISABLED) + "showwarn_tsk.gif"));
        imageDescriptors.put("showtsk_grey", MarkerUtil.createImageDescriptor(String.valueOf(LOCAL_GREY) + "showtsk_tsk.gif"));
        imageDescriptors.put("showtsk_disabled", MarkerUtil.createImageDescriptor(String.valueOf(LOCAL_DISABLED) + "showtsk_tsk.gif"));
        imageDescriptors.put("filter", MarkerUtil.createImageDescriptor(String.valueOf(LOCAL) + "filter_ps.gif"));
    }

    public static int getCharEnd(IMarker marker) {
        return marker.getAttribute("charEnd", -1);
    }

    public static int getCharStart(IMarker marker) {
        return marker.getAttribute("charStart", -1);
    }

    public static Image getCompleteImage(IMarker marker) {
        if (MarkerUtil.isMarkerType(marker, "org.eclipse.core.resources.taskmarker")) {
            if (MarkerUtil.isComplete(marker)) {
                return MarkerUtil.getImage("complete_tsk");
            }
            if (!MarkerUtil.isReadOnly(marker)) {
                return MarkerUtil.getImage("incomplete_tsk");
            }
        }
        return null;
    }

    public static String getCompleteText(IMarker marker) {
        if (MarkerUtil.isMarkerType(marker, "org.eclipse.core.resources.taskmarker")) {
            if (MarkerUtil.isComplete(marker)) {
                return TaskListMessages.getString("TaskList.completed");
            }
            return TaskListMessages.getString("TaskList.notCompleted");
        }
        return "";
    }

    public static String getKindText(IMarker marker) {
        if (MarkerUtil.isMarkerType(marker, "org.eclipse.core.resources.taskmarker")) {
            return TaskListMessages.getString("TaskList.task");
        }
        switch (MarkerUtil.getSeverity(marker)) {
            case 2: {
                return TaskListMessages.getString("TaskList.error");
            }
            case 1: {
                return TaskListMessages.getString("TaskList.warning");
            }
            case 0: {
                return TaskListMessages.getString("TaskList.info");
            }
        }
        return "";
    }

    public static String getContainerName(IMarker marker) {
        IPath path = marker.getResource().getFullPath();
        int n = path.segmentCount() - 1;
        if (n <= 0) {
            return "";
        }
        int len = 0;
        int i = 0;
        while (i < n) {
            len += path.segment(i).length();
            ++i;
        }
        if (n > 1) {
            len += n - 1;
        }
        StringBuffer sb = new StringBuffer(len);
        int i2 = 0;
        while (i2 < n) {
            if (i2 != 0) {
                sb.append('/');
            }
            sb.append(path.segment(i2));
            ++i2;
        }
        return sb.toString();
    }

    static Image getImage(String key) {
        ImageDescriptor desc;
        Image image = imageRegistry.get(key);
        if (image == null && (desc = MarkerUtil.getImageDescriptor(key)) != null) {
            image = desc.createImage(false);
            if (image == null) {
                System.err.println("TaskList: Error creating image for " + key);
            }
            imageRegistry.put(key, image);
        }
        return image;
    }

    public static Image getImage(IMarker marker) {
        if (MarkerUtil.isMarkerType(marker, "org.eclipse.core.resources.problemmarker")) {
            switch (MarkerUtil.getSeverity(marker)) {
                case 2: {
                    return MarkerUtil.getImage("error");
                }
                case 1: {
                    return MarkerUtil.getImage("warn");
                }
                case 0: {
                    return MarkerUtil.getImage("info");
                }
            }
        } else if (MarkerUtil.isMarkerType(marker, "org.eclipse.core.resources.taskmarker")) {
            return MarkerUtil.getImage("task");
        }
        return null;
    }

    static ImageDescriptor getImageDescriptor(String key) {
        ImageDescriptor desc = (ImageDescriptor)imageDescriptors.get(key);
        if (desc == null) {
            System.err.println("TaskList: No image descriptor for " + key);
        }
        return desc;
    }

    public static String getLineAndLocation(IMarker marker) {
        int lineNumber = MarkerUtil.getLineNumber(marker);
        String location = MarkerUtil.getLocation(marker);
        return MarkerUtil.getLineAndLocation(lineNumber, location);
    }

    public static String getLineAndLocation(int lineNumber, String location) {
        if (lineNumber == -1) {
            if (location.equals("")) {
                return "";
            }
            return location;
        }
        if (location.equals("")) {
            return line.format(new Object[]{Integer.toString(lineNumber)});
        }
        return lineAndLocation.format(new Object[]{Integer.toString(lineNumber), location});
    }

    public static int getLineNumber(IMarker marker) {
        return marker.getAttribute("lineNumber", -1);
    }

    public static String getLocation(IMarker marker) {
        return marker.getAttribute("location", "");
    }

    public static String getMessage(IMarker marker) {
        return marker.getAttribute("message", "");
    }

    public static int getNumericValue(String value) {
        boolean negative = false;
        int i = 0;
        int len = value.length();
        if (i < len && value.charAt(i) == '#') {
            ++i;
        }
        if (i < len && value.charAt(i) == '-') {
            negative = true;
            ++i;
        }
        int result = 0;
        while (i < len) {
            int digit;
            if ((digit = Character.digit(value.charAt(i++), 10)) < 0) {
                return result;
            }
            result = result * 10 + digit;
        }
        if (negative) {
            result = -result;
        }
        return result;
    }

    public static int getPriority(IMarker marker) {
        return marker.getAttribute("priority", 1);
    }

    public static Image getPriorityImage(IMarker marker) {
        switch (MarkerUtil.getPriority(marker)) {
            case 2: {
                return MarkerUtil.getImage("hprio");
            }
            case 1: {
                return null;
            }
            case 0: {
                return MarkerUtil.getImage("lprio");
            }
        }
        return null;
    }

    public static String getPriorityText(IMarker marker) {
        if (!MarkerUtil.isMarkerType(marker, "org.eclipse.core.resources.taskmarker")) {
            return "";
        }
        switch (MarkerUtil.getPriority(marker)) {
            case 2: {
                return TaskListMessages.getString("TaskList.high");
            }
            case 1: {
                return TaskListMessages.getString("TaskList.normal");
            }
            case 0: {
                return TaskListMessages.getString("TaskList.low");
            }
        }
        return "";
    }

    public static Object getProperty(Object object, String key) {
        IMarker marker = (IMarker)object;
        if ("org.eclipse.jface.image" == key) {
            return MarkerUtil.getImage(marker);
        }
        if ("org.eclipse.ui.tasklist.completeImage" == key) {
            return MarkerUtil.getCompleteImage(marker);
        }
        if ("org.eclipse.ui.tasklist.priorityImage" == key) {
            return MarkerUtil.getPriorityImage(marker);
        }
        if ("message" == key) {
            return MarkerUtil.getMessage(marker);
        }
        if ("org.eclipse.ui.tasklist.resourceName" == key) {
            return MarkerUtil.getResourceName(marker);
        }
        if ("org.eclipse.ui.tasklist.containerName" == key) {
            return MarkerUtil.getContainerName(marker);
        }
        if ("org.eclipse.ui.tasklist.lineAndLocation" == key) {
            return MarkerUtil.getLineAndLocation(marker);
        }
        if ("priority" == key) {
            return new Integer(2 - MarkerUtil.getPriority(marker));
        }
        if ("done" == key) {
            return MarkerUtil.isComplete(marker) ? Boolean.TRUE : Boolean.FALSE;
        }
        if ("org.eclipse.jface.text" == key) {
            return MarkerUtil.getMessage(marker);
        }
        return null;
    }

    public static String getResourceName(IMarker marker) {
        return marker.getResource().getName();
    }

    public static int getSeverity(IMarker marker) {
        return marker.getAttribute("severity", 1);
    }

    public static boolean isComplete(IMarker marker) {
        return marker.getAttribute("done", false);
    }

    public static boolean isEditable(IMarker marker) {
        return MarkerUtil.isMarkerType(marker, "org.eclipse.core.resources.taskmarker") && !MarkerUtil.isReadOnly(marker);
    }

    public static boolean isMarkerType(IMarker marker, String type) {
        try {
            return marker.isSubtypeOf(type);
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public static boolean isReadOnly(IMarker marker) {
        return !marker.getAttribute("userEditable", true);
    }

    public static String getCreationTime(IMarker marker) {
        try {
            return DateFormat.getDateTimeInstance(1, 2).format(new Date(marker.getCreationTime()));
        }
        catch (CoreException coreException) {
            return null;
        }
    }
}

