/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.navigator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ResourceWorkingSetFilter;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.part.PluginTransfer;
import org.eclipse.ui.part.ResourceTransfer;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.views.framelist.FrameList;
import org.eclipse.ui.views.framelist.TreeFrame;
import org.eclipse.ui.views.navigator.FiltersContentProvider;
import org.eclipse.ui.views.navigator.IResourceNavigator;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;
import org.eclipse.ui.views.navigator.MainActionGroup;
import org.eclipse.ui.views.navigator.NavigatorDragAdapter;
import org.eclipse.ui.views.navigator.NavigatorDropAdapter;
import org.eclipse.ui.views.navigator.NavigatorFrameSource;
import org.eclipse.ui.views.navigator.ResourceNavigatorActionGroup;
import org.eclipse.ui.views.navigator.ResourceNavigatorMessages;
import org.eclipse.ui.views.navigator.ResourcePatternFilter;
import org.eclipse.ui.views.navigator.ResourceSorter;

public class ResourceNavigator
extends ViewPart
implements ISetSelectionTarget,
IResourceNavigator {
    private TreeViewer viewer;
    private IDialogSettings settings;
    private IMemento memento;
    private FrameList frameList;
    private ResourceNavigatorActionGroup actionGroup;
    private ResourcePatternFilter patternFilter = new ResourcePatternFilter();
    private ResourceWorkingSetFilter workingSetFilter = new ResourceWorkingSetFilter();
    private boolean linkingEnabled;
    private boolean dragDetected;
    private Listener dragDetectListener;
    private static final String STORE_SECTION = "ResourceNavigator";
    private static final String STORE_SORT_TYPE = "ResourceViewer.STORE_SORT_TYPE";
    private static final String STORE_WORKING_SET = "ResourceWorkingSetFilter.STORE_WORKING_SET";
    public static final String NAVIGATOR_VIEW_HELP_ID = "org.eclipse.ui.resource_view_context";
    private static final String TAG_SORTER = "sorter";
    private static final String TAG_FILTERS = "filters";
    private static final String TAG_FILTER = "filter";
    private static final String TAG_SELECTION = "selection";
    private static final String TAG_EXPANDED = "expanded";
    private static final String TAG_ELEMENT = "element";
    private static final String TAG_IS_ENABLED = "isEnabled";
    private static final String TAG_PATH = "path";
    private static final String TAG_CURRENT_FRAME = "currentFrame";
    private IPartListener partListener = new IPartListener(){

        public void partActivated(IWorkbenchPart part) {
            if (part instanceof IEditorPart) {
                ResourceNavigator.this.editorActivated((IEditorPart)part);
            }
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
        }
    };
    private IPropertyChangeListener propertyChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            String property = event.getProperty();
            Object newValue = event.getNewValue();
            Object oldValue = event.getOldValue();
            IWorkingSet filterWorkingSet = ResourceNavigator.this.workingSetFilter.getWorkingSet();
            if ("workingSetRemove".equals(property) && oldValue == filterWorkingSet) {
                ResourceNavigator.this.setWorkingSet(null);
            } else if ("workingSetNameChange".equals(property) && newValue == filterWorkingSet) {
                ResourceNavigator.this.updateTitle();
            } else if ("workingSetContentChange".equals(property) && newValue == filterWorkingSet) {
                ResourceNavigator.this.getViewer().refresh();
            }
        }
    };
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public ResourceNavigator() {
        IDialogSettings viewsSettings = this.getPlugin().getDialogSettings();
        this.settings = viewsSettings.getSection(STORE_SECTION);
        if (this.settings == null) {
            this.settings = viewsSettings.addNewSection(STORE_SECTION);
            this.migrateDialogSettings();
        }
        this.initLinkingEnabled();
    }

    private StructuredSelection convertSelection(ISelection selection) {
        ArrayList<IResource> list = new ArrayList<IResource>();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)selection;
            Iterator i = ssel.iterator();
            while (i.hasNext()) {
                Object o = i.next();
                IResource resource = null;
                if (o instanceof IResource) {
                    resource = (IResource)o;
                } else if (o instanceof IAdaptable) {
                    IAdaptable iAdaptable = (IAdaptable)o;
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("[Lorg.eclipse.core.resources.IResource;").getComponentType();
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    resource = (IResource)iAdaptable.getAdapter((Class)clazz);
                }
                if (resource == null) continue;
                list.add(resource);
            }
        }
        return new StructuredSelection(list);
    }

    public void createPartControl(Composite parent) {
        TreeViewer viewer;
        this.viewer = viewer = this.createViewer(parent);
        if (this.memento != null) {
            this.restoreFilters();
            this.restoreLinkingEnabled();
        }
        this.frameList = this.createFrameList();
        this.initDragAndDrop();
        this.updateTitle();
        this.initContextMenu();
        this.initResourceSorter();
        this.initWorkingSetFilter();
        viewer.setInput((Object)this.getInitialInput());
        this.makeActions();
        this.getActionGroup().fillActionBars(this.getViewSite().getActionBars());
        this.updateActionBars((IStructuredSelection)viewer.getSelection());
        this.getSite().setSelectionProvider((ISelectionProvider)viewer);
        this.getSite().getPage().addPartListener(this.partListener);
        IWorkingSetManager workingSetManager = this.getPlugin().getWorkbench().getWorkingSetManager();
        workingSetManager.addPropertyChangeListener(this.propertyChangeListener);
        if (this.memento != null) {
            this.restoreState(this.memento);
        }
        this.memento = null;
        WorkbenchHelp.setHelp((Control)viewer.getControl(), (String)this.getHelpContextId());
    }

    protected String getHelpContextId() {
        return NAVIGATOR_VIEW_HELP_ID;
    }

    protected void initContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ResourceNavigator.this.fillContextMenu(manager);
            }
        });
        TreeViewer viewer = this.getTreeViewer();
        Menu menu = menuMgr.createContextMenu((Control)viewer.getTree());
        viewer.getTree().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)viewer);
    }

    protected TreeViewer createViewer(Composite parent) {
        TreeViewer viewer = new TreeViewer(parent, 770);
        viewer.setUseHashlookup(true);
        this.initContentProvider(viewer);
        this.initLabelProvider(viewer);
        this.initFilters(viewer);
        this.initListeners(viewer);
        return viewer;
    }

    protected void initContentProvider(TreeViewer viewer) {
        viewer.setContentProvider((IContentProvider)new WorkbenchContentProvider());
    }

    protected void initLabelProvider(TreeViewer viewer) {
        viewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)new WorkbenchLabelProvider(), this.getPlugin().getWorkbench().getDecoratorManager().getLabelDecorator()));
    }

    protected void initFilters(TreeViewer viewer) {
        viewer.addFilter((ViewerFilter)this.patternFilter);
        viewer.addFilter((ViewerFilter)this.workingSetFilter);
    }

    private void initLinkingEnabled() {
        String setting = this.settings.get("LINK_NAVIGATOR_TO_EDITOR");
        if (setting != null) {
            this.linkingEnabled = setting.equals("true");
            return;
        }
        AbstractUIPlugin uiPlugin = (AbstractUIPlugin)Platform.getPlugin((String)"org.eclipse.ui");
        this.linkingEnabled = uiPlugin.getPreferenceStore().getBoolean("LINK_NAVIGATOR_TO_EDITOR");
    }

    protected void initListeners(TreeViewer viewer) {
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ResourceNavigator.this.handleSelectionChanged(event);
            }
        });
        viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ResourceNavigator.this.handleDoubleClick(event);
            }
        });
        viewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                ResourceNavigator.this.handleOpen(event);
            }
        });
        viewer.getControl().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent event) {
                ResourceNavigator.this.handleKeyPressed(event);
            }

            public void keyReleased(KeyEvent event) {
                ResourceNavigator.this.handleKeyReleased(event);
            }
        });
    }

    public void dispose() {
        this.getSite().getPage().removePartListener(this.partListener);
        IWorkingSetManager workingSetManager = this.getPlugin().getWorkbench().getWorkingSetManager();
        workingSetManager.removePropertyChangeListener(this.propertyChangeListener);
        if (this.getActionGroup() != null) {
            this.getActionGroup().dispose();
        }
        Control control = this.viewer.getControl();
        if (this.dragDetectListener != null && control != null && !control.isDisposed()) {
            control.removeListener(29, this.dragDetectListener);
        }
        super.dispose();
    }

    protected void editorActivated(IEditorPart editor) {
        if (!this.isLinkingEnabled()) {
            return;
        }
        IEditorInput input = editor.getEditorInput();
        if (input instanceof IFileEditorInput) {
            IFileEditorInput fileInput = (IFileEditorInput)input;
            IFile file = fileInput.getFile();
            StructuredSelection newSelection = new StructuredSelection((Object)file);
            if (this.getTreeViewer().getSelection().equals(newSelection)) {
                this.getTreeViewer().getTree().showSelection();
            } else {
                this.getTreeViewer().setSelection((ISelection)newSelection, true);
            }
        }
    }

    protected void fillContextMenu(IMenuManager menu) {
        IStructuredSelection selection = (IStructuredSelection)this.getViewer().getSelection();
        this.getActionGroup().setContext(new ActionContext((ISelection)selection));
        this.getActionGroup().fillContextMenu(menu);
    }

    public FrameList getFrameList() {
        return this.frameList;
    }

    protected IAdaptable getInitialInput() {
        IAdaptable input = this.getSite().getPage().getInput();
        if (input != null) {
            IResource resource = null;
            if (input instanceof IResource) {
                resource = (IResource)input;
            } else {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("[Lorg.eclipse.core.resources.IResource;").getComponentType();
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                resource = (IResource)input.getAdapter((Class)clazz);
            }
            if (resource != null) {
                switch (resource.getType()) {
                    case 1: {
                        return resource.getParent();
                    }
                    case 2: 
                    case 4: 
                    case 8: {
                        return (IContainer)resource;
                    }
                }
            }
        }
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public ResourcePatternFilter getPatternFilter() {
        return this.patternFilter;
    }

    public IWorkingSet getWorkingSet() {
        return this.workingSetFilter.getWorkingSet();
    }

    public AbstractUIPlugin getPlugin() {
        return (AbstractUIPlugin)Platform.getPlugin((String)"org.eclipse.ui.ide");
    }

    public ResourceSorter getSorter() {
        return (ResourceSorter)this.getTreeViewer().getSorter();
    }

    public TreeViewer getViewer() {
        return this.viewer;
    }

    public TreeViewer getTreeViewer() {
        return this.viewer;
    }

    public Shell getShell() {
        return this.getViewSite().getShell();
    }

    protected String getStatusLineMessage(IStructuredSelection selection) {
        if (selection.size() == 1) {
            Object o = selection.getFirstElement();
            if (o instanceof IResource) {
                return ((IResource)o).getFullPath().makeRelative().toString();
            }
            return ResourceNavigatorMessages.getString("ResourceNavigator.oneItemSelected");
        }
        if (selection.size() > 1) {
            return ResourceNavigatorMessages.format("ResourceNavigator.statusLine", new Object[]{new Integer(selection.size())});
        }
        return "";
    }

    String getFrameName(Object element) {
        if (element instanceof IResource) {
            return ((IResource)element).getName();
        }
        return ((ILabelProvider)this.getTreeViewer().getLabelProvider()).getText(element);
    }

    String getFrameToolTipText(Object element) {
        if (element instanceof IResource) {
            IPath path = ((IResource)element).getFullPath();
            if (path.isRoot()) {
                return ResourceNavigatorMessages.getString("ResourceManager.toolTip");
            }
            return path.makeRelative().toString();
        }
        return ((ILabelProvider)this.getTreeViewer().getLabelProvider()).getText(element);
    }

    protected void handleOpen(OpenEvent event) {
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        this.getActionGroup().runDefaultAction(selection);
    }

    protected void handleDoubleClick(DoubleClickEvent event) {
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        Object element = selection.getFirstElement();
        TreeViewer viewer = this.getTreeViewer();
        if (viewer.isExpandable(element)) {
            viewer.setExpandedState(element, !viewer.getExpandedState(element));
        }
    }

    protected void handleSelectionChanged(SelectionChangedEvent event) {
        final IStructuredSelection sel = (IStructuredSelection)event.getSelection();
        this.updateStatusLine(sel);
        this.updateActionBars(sel);
        this.dragDetected = false;
        if (this.isLinkingEnabled()) {
            this.getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (!ResourceNavigator.this.dragDetected) {
                        ResourceNavigator.this.linkToEditor(sel);
                    }
                }
            });
        }
    }

    protected void handleKeyPressed(KeyEvent event) {
        this.getActionGroup().handleKeyPressed(event);
    }

    protected void handleKeyReleased(KeyEvent event) {
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.memento = memento;
    }

    protected void initDragAndDrop() {
        int ops = 3;
        Transfer[] transfers = new Transfer[]{LocalSelectionTransfer.getInstance(), ResourceTransfer.getInstance(), FileTransfer.getInstance(), PluginTransfer.getInstance()};
        TreeViewer viewer = this.getTreeViewer();
        viewer.addDragSupport(ops, transfers, (DragSourceListener)new NavigatorDragAdapter((ISelectionProvider)viewer));
        NavigatorDropAdapter adapter = new NavigatorDropAdapter((StructuredViewer)viewer);
        adapter.setFeedbackEnabled(false);
        viewer.addDropSupport(ops | 0x10, transfers, (DropTargetListener)adapter);
        this.dragDetectListener = new Listener(){

            public void handleEvent(Event event) {
                ResourceNavigator.this.dragDetected = true;
            }
        };
        viewer.getControl().addListener(29, this.dragDetectListener);
    }

    protected FrameList createFrameList() {
        NavigatorFrameSource frameSource = new NavigatorFrameSource(this);
        FrameList frameList = new FrameList(frameSource);
        frameSource.connectTo(frameList);
        return frameList;
    }

    protected void initResourceSorter() {
        int sortType = 1;
        try {
            int sortInt = 0;
            if (this.memento != null) {
                String sortStr = this.memento.getString(TAG_SORTER);
                if (sortStr != null) {
                    sortInt = new Integer(sortStr);
                }
            } else {
                sortInt = this.settings.getInt(STORE_SORT_TYPE);
            }
            if (sortInt == 1 || sortInt == 2) {
                sortType = sortInt;
            }
        }
        catch (NumberFormatException numberFormatException) {}
        this.setSorter(new ResourceSorter(sortType));
    }

    void initWorkingSetFilter() {
        IWorkingSetManager workingSetManager;
        IWorkingSet workingSet;
        String workingSetName = this.settings.get(STORE_WORKING_SET);
        if (workingSetName != null && !workingSetName.equals("") && (workingSet = (workingSetManager = this.getPlugin().getWorkbench().getWorkingSetManager()).getWorkingSet(workingSetName)) != null) {
            this.workingSetFilter.setWorkingSet(workingSet);
        }
    }

    public boolean isLinkingEnabled() {
        return this.linkingEnabled;
    }

    protected void linkToEditor(IStructuredSelection selection) {
        Object obj = selection.getFirstElement();
        if (obj instanceof IFile && selection.size() == 1) {
            IFile file = (IFile)obj;
            IWorkbenchPage page = this.getSite().getPage();
            IEditorPart editor = page.findEditor((IEditorInput)new FileEditorInput(file));
            if (editor != null) {
                page.bringToTop((IWorkbenchPart)editor);
                return;
            }
        }
    }

    protected void makeActions() {
        this.setActionGroup(new MainActionGroup(this));
    }

    private void migrateDialogSettings() {
        AbstractUIPlugin uiPlugin = (AbstractUIPlugin)Platform.getPlugin((String)"org.eclipse.ui");
        IDialogSettings uiSettings = uiPlugin.getDialogSettings();
        if ((uiSettings = uiSettings.getSection(STORE_SECTION)) != null) {
            String sortType;
            String workingSetName = uiSettings.get(STORE_WORKING_SET);
            if (workingSetName != null && workingSetName.length() > 0) {
                this.settings.put(STORE_WORKING_SET, workingSetName);
                uiSettings.put(STORE_WORKING_SET, "");
            }
            if ((sortType = uiSettings.get(STORE_SORT_TYPE)) != null && sortType.length() > 0) {
                this.settings.put(STORE_SORT_TYPE, sortType);
                uiSettings.put(STORE_SORT_TYPE, "");
            }
        }
    }

    private void restoreFilters() {
        IMemento filtersMem = this.memento.getChild(TAG_FILTERS);
        if (filtersMem != null) {
            IMemento[] children = filtersMem.getChildren(TAG_FILTER);
            if (children.length > 0 && children[0].getString(TAG_IS_ENABLED) != null) {
                ArrayList<String> selectedFilters = new ArrayList<String>();
                ArrayList<String> unSelectedFilters = new ArrayList<String>();
                int i = 0;
                while (i < children.length) {
                    if (children[i].getString(TAG_IS_ENABLED).equals(String.valueOf(true))) {
                        selectedFilters.add(children[i].getString(TAG_ELEMENT));
                    } else {
                        unSelectedFilters.add(children[i].getString(TAG_ELEMENT));
                    }
                    ++i;
                }
                List pluginFilters = FiltersContentProvider.getDefaultFilters();
                Iterator iter = pluginFilters.iterator();
                while (iter.hasNext()) {
                    String element = (String)iter.next();
                    if (selectedFilters.contains(element) || unSelectedFilters.contains(element)) continue;
                    selectedFilters.add(element);
                }
                String[] patternArray = new String[selectedFilters.size()];
                selectedFilters.toArray(patternArray);
                this.getPatternFilter().setPatterns(patternArray);
            } else {
                String[] filters = new String[children.length];
                int i = 0;
                while (i < children.length) {
                    filters[i] = children[i].getString(TAG_ELEMENT);
                    ++i;
                }
                this.getPatternFilter().setPatterns(filters);
            }
        } else {
            this.getPatternFilter().setPatterns(new String[0]);
        }
    }

    protected void restoreState(IMemento memento) {
        TreeViewer viewer = this.getTreeViewer();
        IMemento frameMemento = memento.getChild(TAG_CURRENT_FRAME);
        if (frameMemento != null) {
            TreeFrame frame = new TreeFrame((AbstractTreeViewer)viewer);
            frame.restoreState(frameMemento);
            frame.setName(this.getFrameName(frame.getInput()));
            frame.setToolTipText(this.getFrameToolTipText(frame.getInput()));
            viewer.setSelection((ISelection)new StructuredSelection(frame.getInput()));
            this.frameList.gotoFrame(frame);
        } else {
            IResource element;
            int i;
            IMemento[] elementMem;
            IWorkspaceRoot container = ResourcesPlugin.getWorkspace().getRoot();
            IMemento childMem = memento.getChild(TAG_EXPANDED);
            if (childMem != null) {
                ArrayList<IResource> elements = new ArrayList<IResource>();
                elementMem = childMem.getChildren(TAG_ELEMENT);
                i = 0;
                while (i < elementMem.length) {
                    element = container.findMember(elementMem[i].getString(TAG_PATH));
                    if (element != null) {
                        elements.add(element);
                    }
                    ++i;
                }
                viewer.setExpandedElements(elements.toArray());
            }
            if ((childMem = memento.getChild(TAG_SELECTION)) != null) {
                ArrayList<IResource> list = new ArrayList<IResource>();
                elementMem = childMem.getChildren(TAG_ELEMENT);
                i = 0;
                while (i < elementMem.length) {
                    element = container.findMember(elementMem[i].getString(TAG_PATH));
                    if (element != null) {
                        list.add(element);
                    }
                    ++i;
                }
                viewer.setSelection((ISelection)new StructuredSelection(list));
            }
        }
    }

    private void restoreLinkingEnabled() {
        Integer val = this.memento.getInteger("LINK_NAVIGATOR_TO_EDITOR");
        if (val != null) {
            this.linkingEnabled = val != 0;
        }
    }

    public void saveState(IMemento memento) {
        TreeViewer viewer = this.getTreeViewer();
        if (viewer == null) {
            if (this.memento != null) {
                memento.putMemento(this.memento);
            }
            return;
        }
        memento.putInteger(TAG_SORTER, this.getSorter().getCriteria());
        String[] filters = this.getPatternFilter().getPatterns();
        List<String> selectedFilters = Arrays.asList(filters);
        List allFilters = FiltersContentProvider.getDefinedFilters();
        IMemento filtersMem = memento.createChild(TAG_FILTERS);
        Iterator iter = allFilters.iterator();
        while (iter.hasNext()) {
            String element = (String)iter.next();
            IMemento child = filtersMem.createChild(TAG_FILTER);
            child.putString(TAG_ELEMENT, element);
            child.putString(TAG_IS_ENABLED, String.valueOf(selectedFilters.contains(element)));
        }
        if (this.frameList.getCurrentIndex() > 0) {
            TreeFrame currentFrame = (TreeFrame)this.frameList.getCurrentFrame();
            IMemento frameMemento = memento.createChild(TAG_CURRENT_FRAME);
            currentFrame.saveState(frameMemento);
        } else {
            Object[] elements;
            Object[] expandedElements = viewer.getVisibleExpandedElements();
            if (expandedElements.length > 0) {
                IMemento expandedMem = memento.createChild(TAG_EXPANDED);
                int i = 0;
                while (i < expandedElements.length) {
                    IMemento elementMem = expandedMem.createChild(TAG_ELEMENT);
                    elementMem.putString(TAG_PATH, ((IResource)expandedElements[i]).getFullPath().toString());
                    ++i;
                }
            }
            if ((elements = ((IStructuredSelection)viewer.getSelection()).toArray()).length > 0) {
                IMemento selectionMem = memento.createChild(TAG_SELECTION);
                int i = 0;
                while (i < elements.length) {
                    IMemento elementMem = selectionMem.createChild(TAG_ELEMENT);
                    elementMem.putString(TAG_PATH, ((IResource)elements[i]).getFullPath().toString());
                    ++i;
                }
            }
        }
        this.saveLinkingEnabled(memento);
    }

    private void saveLinkingEnabled(IMemento memento) {
        memento.putInteger("LINK_NAVIGATOR_TO_EDITOR", this.linkingEnabled ? 1 : 0);
    }

    public void selectReveal(ISelection selection) {
        StructuredSelection ssel = this.convertSelection(selection);
        if (!ssel.isEmpty()) {
            this.getViewer().getControl().setRedraw(false);
            this.getViewer().setSelection((ISelection)ssel, true);
            this.getViewer().getControl().setRedraw(true);
        }
    }

    public void setFiltersPreference(String[] patterns) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < patterns.length) {
            if (i != 0) {
                sb.append(",");
            }
            sb.append(patterns[i]);
            ++i;
        }
        this.getPlugin().getPreferenceStore().setValue("resourceFilters", sb.toString());
        IPreferenceStore preferenceStore = IDEWorkbenchPlugin.getDefault().getPreferenceStore();
        String storedPatterns = preferenceStore.getString("resourceFilters");
        if (storedPatterns.length() > 0) {
            preferenceStore.setValue("resourceFilters", "");
        }
    }

    public void setFocus() {
        this.getTreeViewer().getTree().setFocus();
    }

    public void setLabelDecorator(ILabelDecorator decorator) {
    }

    public void setLinkingEnabled(boolean enabled) {
        IEditorPart editor;
        this.linkingEnabled = enabled;
        this.settings.put("LINK_NAVIGATOR_TO_EDITOR", enabled);
        if (enabled && (editor = this.getSite().getPage().getActiveEditor()) != null) {
            this.editorActivated(editor);
        }
    }

    public void setSorter(ResourceSorter sorter) {
        TreeViewer viewer = this.getTreeViewer();
        ViewerSorter viewerSorter = viewer.getSorter();
        viewer.getControl().setRedraw(false);
        if (viewerSorter == sorter) {
            viewer.refresh();
        } else {
            viewer.setSorter((ViewerSorter)sorter);
        }
        viewer.getControl().setRedraw(true);
        this.settings.put(STORE_SORT_TYPE, sorter.getCriteria());
        this.updateActionBars((IStructuredSelection)viewer.getSelection());
    }

    public void setWorkingSet(IWorkingSet workingSet) {
        TreeViewer treeViewer = this.getTreeViewer();
        Object[] expanded = treeViewer.getExpandedElements();
        ISelection selection = treeViewer.getSelection();
        this.workingSetFilter.setWorkingSet(workingSet);
        if (workingSet != null) {
            this.settings.put(STORE_WORKING_SET, workingSet.getName());
        } else {
            this.settings.put(STORE_WORKING_SET, "");
        }
        this.updateTitle();
        treeViewer.refresh();
        treeViewer.setExpandedElements(expanded);
        if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            treeViewer.reveal(structuredSelection.getFirstElement());
        }
    }

    protected void updateActionBars(IStructuredSelection selection) {
        ResourceNavigatorActionGroup group = this.getActionGroup();
        if (group != null) {
            group.setContext(new ActionContext((ISelection)selection));
            group.updateActionBars();
        }
    }

    protected void updateStatusLine(IStructuredSelection selection) {
        String msg = this.getStatusLineMessage(selection);
        this.getViewSite().getActionBars().getStatusLineManager().setMessage(msg);
    }

    public void updateTitle() {
        Object input = this.getViewer().getInput();
        String viewName = this.getConfigurationElement().getAttribute("name");
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkingSet workingSet = this.workingSetFilter.getWorkingSet();
        if (input == null || input.equals(workspace) || input.equals(workspace.getRoot())) {
            this.setTitle(viewName);
            if (workingSet != null) {
                this.setTitleToolTip(ResourceNavigatorMessages.format("ResourceNavigator.workingSetToolTip", new Object[]{workingSet.getName()}));
            } else {
                this.setTitleToolTip("");
            }
        } else {
            ILabelProvider labelProvider = (ILabelProvider)this.getTreeViewer().getLabelProvider();
            String inputToolTip = this.getFrameToolTipText(input);
            this.setTitle(ResourceNavigatorMessages.format("ResourceNavigator.title", new Object[]{viewName, labelProvider.getText(input)}));
            if (workingSet != null) {
                this.setTitleToolTip(ResourceNavigatorMessages.format("ResourceNavigator.workingSetInputToolTip", new Object[]{inputToolTip, workingSet.getName()}));
            } else {
                this.setTitleToolTip(inputToolTip);
            }
        }
    }

    protected ResourceNavigatorActionGroup getActionGroup() {
        return this.actionGroup;
    }

    protected void setActionGroup(ResourceNavigatorActionGroup actionGroup) {
        this.actionGroup = actionGroup;
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("[Lorg.eclipse.ui.part.IShowInSource;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz) {
            return this.getShowInSource();
        }
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("[Lorg.eclipse.ui.part.IShowInTarget;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz2) {
            return this.getShowInTarget();
        }
        return null;
    }

    protected IShowInSource getShowInSource() {
        return new IShowInSource(){

            public ShowInContext getShowInContext() {
                return new ShowInContext(ResourceNavigator.this.getViewer().getInput(), ResourceNavigator.this.getViewer().getSelection());
            }
        };
    }

    protected IShowInTarget getShowInTarget() {
        return new IShowInTarget(){

            public boolean show(ShowInContext context) {
                Object input;
                Object o;
                ArrayList toSelect = new ArrayList();
                ISelection sel = context.getSelection();
                if (sel instanceof IStructuredSelection) {
                    IStructuredSelection ssel = (IStructuredSelection)sel;
                    Iterator i = ssel.iterator();
                    while (i.hasNext()) {
                        IResource r;
                        o = i.next();
                        if (o instanceof IResource) {
                            toSelect.add(o);
                            continue;
                        }
                        if (o instanceof IMarker) {
                            IResource r2 = ((IMarker)o).getResource();
                            if (r2.getType() == 8) continue;
                            toSelect.add(r2);
                            continue;
                        }
                        if (!(o instanceof IAdaptable)) continue;
                        IAdaptable adaptable = (IAdaptable)o;
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = Class.forName("[Lorg.eclipse.core.resources.IResource;").getComponentType();
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if ((o = adaptable.getAdapter((Class)clazz)) instanceof IResource) {
                            toSelect.add(o);
                            continue;
                        }
                        Class<?> clazz2 = class$3;
                        if (clazz2 == null) {
                            try {
                                clazz2 = Class.forName("[Lorg.eclipse.core.resources.IMarker;").getComponentType();
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (!((o = adaptable.getAdapter((Class)clazz2)) instanceof IMarker) || (r = ((IMarker)o).getResource()).getType() == 8) continue;
                        toSelect.add(r);
                    }
                }
                if (toSelect.isEmpty() && (input = context.getInput()) instanceof IAdaptable) {
                    IAdaptable adaptable = (IAdaptable)input;
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("[Lorg.eclipse.core.resources.IResource;").getComponentType();
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((o = adaptable.getAdapter((Class)clazz)) instanceof IResource) {
                        toSelect.add(o);
                    }
                }
                if (!toSelect.isEmpty()) {
                    ResourceNavigator.this.selectReveal((ISelection)new StructuredSelection(toSelect));
                    return true;
                }
                return false;
            }
        };
    }
}

