/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.navigator;

import java.util.List;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.AddBookmarkAction;
import org.eclipse.ui.actions.AddTaskAction;
import org.eclipse.ui.actions.ExportResourcesAction;
import org.eclipse.ui.actions.ImportResourcesAction;
import org.eclipse.ui.actions.NewWizardMenu;
import org.eclipse.ui.actions.WorkingSetFilterActionGroup;
import org.eclipse.ui.dialogs.PropertyDialogAction;
import org.eclipse.ui.ide.IDEActionFactory;
import org.eclipse.ui.views.navigator.CollapseAllAction;
import org.eclipse.ui.views.navigator.GotoActionGroup;
import org.eclipse.ui.views.navigator.IResourceNavigator;
import org.eclipse.ui.views.navigator.OpenActionGroup;
import org.eclipse.ui.views.navigator.RefactorActionGroup;
import org.eclipse.ui.views.navigator.ResourceNavigatorActionGroup;
import org.eclipse.ui.views.navigator.ResourceNavigatorMessages;
import org.eclipse.ui.views.navigator.ResourceSelectionUtil;
import org.eclipse.ui.views.navigator.SortAndFilterActionGroup;
import org.eclipse.ui.views.navigator.ToggleLinkingAction;
import org.eclipse.ui.views.navigator.WorkspaceActionGroup;

public class MainActionGroup
extends ResourceNavigatorActionGroup {
    protected AddBookmarkAction addBookmarkAction;
    protected AddTaskAction addTaskAction;
    protected PropertyDialogAction propertyDialogAction;
    protected ImportResourcesAction importAction;
    protected ExportResourcesAction exportAction;
    protected CollapseAllAction collapseAllAction;
    protected ToggleLinkingAction toggleLinkingAction;
    protected GotoActionGroup gotoGroup;
    protected OpenActionGroup openGroup;
    protected RefactorActionGroup refactorGroup;
    protected WorkingSetFilterActionGroup workingSetGroup;
    protected SortAndFilterActionGroup sortAndFilterGroup;
    protected WorkspaceActionGroup workspaceGroup;
    private IResourceChangeListener resourceChangeListener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            MainActionGroup.this.handleResourceChanged(event);
        }
    };

    public MainActionGroup(IResourceNavigator navigator) {
        super(navigator);
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener, 1);
        this.makeSubGroups();
    }

    protected void handleResourceChanged(IResourceChangeEvent event) {
        ActionContext context = this.getContext();
        if (context == null) {
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)context.getSelection();
        if (!ResourceSelectionUtil.allResourcesAreOfType(selection, 4)) {
            return;
        }
        List sel = selection.toList();
        IResourceDelta delta = event.getDelta();
        if (delta == null) {
            return;
        }
        IResourceDelta[] projDeltas = delta.getAffectedChildren(4);
        int i = 0;
        while (i < projDeltas.length) {
            IResourceDelta projDelta = projDeltas[i];
            if ((projDelta.getFlags() & 0x4000) != 0 && sel.contains(projDelta.getResource())) {
                this.addTaskAction.selectionChanged(selection);
                this.gotoGroup.updateActionBars();
                this.refactorGroup.updateActionBars();
                this.workspaceGroup.updateActionBars();
                return;
            }
            ++i;
        }
    }

    protected void makeActions() {
        Shell shell = this.navigator.getSite().getShell();
        this.addBookmarkAction = new AddBookmarkAction(shell);
        this.addTaskAction = new AddTaskAction(shell);
        this.propertyDialogAction = new PropertyDialogAction(shell, (ISelectionProvider)this.navigator.getViewer());
        this.importAction = new ImportResourcesAction(this.navigator.getSite().getWorkbenchWindow());
        this.importAction.setDisabledImageDescriptor(this.getImageDescriptor("dtool16/import_wiz.gif"));
        this.importAction.setImageDescriptor(this.getImageDescriptor("etool16/import_wiz.gif"));
        this.importAction.setHoverImageDescriptor(this.getImageDescriptor("ctool16/import_wiz.gif"));
        this.exportAction = new ExportResourcesAction(this.navigator.getSite().getWorkbenchWindow());
        this.exportAction.setDisabledImageDescriptor(this.getImageDescriptor("dtool16/export_wiz.gif"));
        this.exportAction.setImageDescriptor(this.getImageDescriptor("etool16/export_wiz.gif"));
        this.exportAction.setHoverImageDescriptor(this.getImageDescriptor("ctool16/export_wiz.gif"));
        this.collapseAllAction = new CollapseAllAction(this.navigator, ResourceNavigatorMessages.getString("CollapseAllAction.title"));
        this.collapseAllAction.setToolTipText(ResourceNavigatorMessages.getString("CollapseAllAction.toolTip"));
        this.collapseAllAction.setImageDescriptor(this.getImageDescriptor("elcl16/collapseall.gif"));
        this.collapseAllAction.setHoverImageDescriptor(this.getImageDescriptor("clcl16/collapseall.gif"));
        this.toggleLinkingAction = new ToggleLinkingAction(this.navigator, ResourceNavigatorMessages.getString("ToggleLinkingAction.text"));
        this.toggleLinkingAction.setToolTipText(ResourceNavigatorMessages.getString("ToggleLinkingAction.toolTip"));
        this.toggleLinkingAction.setImageDescriptor(this.getImageDescriptor("elcl16/synced.gif"));
        this.toggleLinkingAction.setHoverImageDescriptor(this.getImageDescriptor("clcl16/synced.gif"));
    }

    protected void makeSubGroups() {
        this.gotoGroup = new GotoActionGroup(this.navigator);
        this.openGroup = new OpenActionGroup(this.navigator);
        this.refactorGroup = new RefactorActionGroup(this.navigator);
        IPropertyChangeListener workingSetUpdater = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                String property = event.getProperty();
                if ("changeWorkingSet".equals(property)) {
                    IResourceNavigator navigator = MainActionGroup.this.getNavigator();
                    Object newValue = event.getNewValue();
                    if (newValue instanceof IWorkingSet) {
                        navigator.setWorkingSet((IWorkingSet)newValue);
                    } else if (newValue == null) {
                        navigator.setWorkingSet(null);
                    }
                }
            }
        };
        TreeViewer treeView = this.navigator.getViewer();
        Shell shell = treeView.getControl().getShell();
        this.workingSetGroup = new WorkingSetFilterActionGroup(shell, workingSetUpdater);
        this.workingSetGroup.setWorkingSet(this.navigator.getWorkingSet());
        this.sortAndFilterGroup = new SortAndFilterActionGroup(this.navigator);
        this.workspaceGroup = new WorkspaceActionGroup(this.navigator);
    }

    public void setContext(ActionContext context) {
        super.setContext(context);
        this.gotoGroup.setContext(context);
        this.openGroup.setContext(context);
        this.refactorGroup.setContext(context);
        this.sortAndFilterGroup.setContext(context);
        this.workspaceGroup.setContext(context);
    }

    public void fillContextMenu(IMenuManager menu) {
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        boolean onlyFilesSelected = !selection.isEmpty() && ResourceSelectionUtil.allResourcesAreOfType(selection, 1);
        MenuManager newMenu = new MenuManager(ResourceNavigatorMessages.getString("ResourceNavigator.new"));
        menu.add((IContributionItem)newMenu);
        new NewWizardMenu((IMenuManager)newMenu, this.navigator.getSite().getWorkbenchWindow(), false);
        this.gotoGroup.fillContextMenu(menu);
        this.openGroup.fillContextMenu(menu);
        menu.add((IContributionItem)new Separator());
        this.refactorGroup.fillContextMenu(menu);
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.importAction);
        menu.add((IAction)this.exportAction);
        this.importAction.selectionChanged(selection);
        this.exportAction.selectionChanged(selection);
        menu.add((IContributionItem)new Separator());
        if (onlyFilesSelected) {
            this.addBookmarkAction.selectionChanged(selection);
            menu.add((IAction)this.addBookmarkAction);
        }
        menu.add((IContributionItem)new Separator());
        this.workspaceGroup.fillContextMenu(menu);
        menu.add((IContributionItem)new Separator("additions"));
        menu.add((IContributionItem)new Separator("additions-end"));
        menu.add((IContributionItem)new Separator());
        if (selection.size() == 1) {
            this.propertyDialogAction.selectionChanged(selection);
            menu.add((IAction)this.propertyDialogAction);
        }
    }

    public void fillActionBars(IActionBars actionBars) {
        actionBars.setGlobalActionHandler(ActionFactory.PROPERTIES.getId(), (IAction)this.propertyDialogAction);
        actionBars.setGlobalActionHandler(IDEActionFactory.BOOKMARK.getId(), (IAction)this.addBookmarkAction);
        actionBars.setGlobalActionHandler(IDEActionFactory.ADD_TASK.getId(), (IAction)this.addTaskAction);
        this.gotoGroup.fillActionBars(actionBars);
        this.openGroup.fillActionBars(actionBars);
        this.refactorGroup.fillActionBars(actionBars);
        this.workingSetGroup.fillActionBars(actionBars);
        this.sortAndFilterGroup.fillActionBars(actionBars);
        this.workspaceGroup.fillActionBars(actionBars);
        IMenuManager menu = actionBars.getMenuManager();
        menu.add((IAction)this.toggleLinkingAction);
        IToolBarManager toolBar = actionBars.getToolBarManager();
        toolBar.add((IContributionItem)new Separator());
        toolBar.add((IAction)this.collapseAllAction);
        toolBar.add((IAction)this.toggleLinkingAction);
    }

    public void updateActionBars() {
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        this.propertyDialogAction.setEnabled(selection.size() == 1);
        this.addBookmarkAction.selectionChanged(selection);
        this.addTaskAction.selectionChanged(selection);
        this.gotoGroup.updateActionBars();
        this.openGroup.updateActionBars();
        this.refactorGroup.updateActionBars();
        this.workingSetGroup.updateActionBars();
        this.sortAndFilterGroup.updateActionBars();
        this.workspaceGroup.updateActionBars();
    }

    public void runDefaultAction(IStructuredSelection selection) {
        this.openGroup.runDefaultAction(selection);
    }

    public void handleKeyPressed(KeyEvent event) {
        this.refactorGroup.handleKeyPressed(event);
        this.workspaceGroup.handleKeyPressed(event);
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
        this.gotoGroup.dispose();
        this.openGroup.dispose();
        this.refactorGroup.dispose();
        this.workingSetGroup.dispose();
        this.sortAndFilterGroup.dispose();
        this.workspaceGroup.dispose();
        super.dispose();
    }
}

