/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.views.markers.internal.DeferredQueue;
import org.eclipse.ui.views.markers.internal.Messages;
import org.eclipse.ui.views.markers.internal.RestartableJob;
import org.eclipse.ui.views.markers.internal.TableSorter;

class TableContentProvider
implements IStructuredContentProvider {
    private static final String TABLE_SYNCHRONIZATION = Messages.getString("TableContentProvider.TableSynchronization");
    private static final String UPDATING_TABLE_WIDGET = Messages.getString("TableContentProvider.Updating");
    private String description = "";
    private TableSorter sortOrder = null;
    private DeferredQueue queues;
    private Job disableUpdatesJob = new UIJob(TABLE_SYNCHRONIZATION){

        public IStatus runInUIThread(IProgressMonitor monitor) {
            if (TableContentProvider.this.controlExists()) {
                TableContentProvider.this.getViewer().getTable().setRedraw(false);
            }
            return Status.OK_STATUS;
        }
    };
    private Job enableUpdatesJob = new UIJob(TABLE_SYNCHRONIZATION){

        public IStatus runInUIThread(IProgressMonitor monitor) {
            if (TableContentProvider.this.controlExists()) {
                TableContentProvider.this.getViewer().getTable().setRedraw(true);
            }
            return Status.OK_STATUS;
        }
    };
    WidgetRefreshJob uiJob = new WidgetRefreshJob(UPDATING_TABLE_WIDGET);
    RestartableJob updateJob = new RestartableJob(TABLE_SYNCHRONIZATION, new IRunnableWithProgress(){

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            TableContentProvider.this.doUpdate(monitor);
        }
    });
    private ILock lock;

    public TableContentProvider(TableViewer viewer, String description) {
        this.queues = new DeferredQueue(viewer);
        this.description = description;
        this.uiJob.setPriority(30);
        this.uiJob.setSystem(true);
        this.lock = Platform.getJobManager().newLock();
    }

    public void setSorter(TableSorter c) {
        if (this.sortOrder != c) {
            this.sortOrder = c;
            this.scheduleUpdate();
        }
    }

    public Object[] getElements(Object inputElement) {
        return this.queues.getVisibleItems();
    }

    public void dispose() {
    }

    public void inputChanged(Viewer inputViewer, Object oldInput, Object newInput) {
        this.scheduleUpdate();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void set(Collection newVisibleItems, IProgressMonitor mon) {
        this.lock.acquire();
        try {
            this.queues.set(newVisibleItems, mon);
            this.scheduleUpdate();
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.lock.release();
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.lock.release();
    }

    private void resync() {
        int count;
        if (this.controlExists() && (count = this.queues.getViewer().getTable().getItemCount()) != this.queues.countVisibleItems()) {
            this.queues.getViewer().refresh();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void change(Collection changes) {
        this.lock.acquire();
        try {
            this.queues.change(changes);
            this.scheduleUpdate();
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.lock.release();
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        this.lock.release();
    }

    private TableViewer getViewer() {
        return this.queues.getViewer();
    }

    private boolean controlExists() {
        Control control = this.getViewer().getControl();
        return control != null && !control.isDisposed();
    }

    public boolean hasPendingChanges() {
        return this.queues.hasPendingChanges() || this.sortOrder != this.queues.getSorter();
    }

    private int totalWork() {
        return this.queues.workRemaining() + 1;
    }

    private void scheduleUpdate() {
        if (this.hasPendingChanges()) {
            this.updateJob.schedule();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void cancelPendingChanges() {
        this.updateJob.cancel();
        this.lock.acquire();
        try {
            this.queues.cancelPending();
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.lock.release();
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        this.lock.release();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doUpdate(IProgressMonitor monitor) throws InterruptedException {
        int remainingWorkUnits = 100000;
        monitor.beginTask(this.description, remainingWorkUnits);
        this.disableUpdatesJob.schedule();
        this.disableUpdatesJob.join();
        try {
            while (this.hasPendingChanges() && !monitor.isCanceled()) {
                try {
                    Object var5_6;
                    int totalWork;
                    this.lock.acquire();
                    try {
                        totalWork = this.totalWork();
                        if (this.sortOrder != this.queues.getSorter()) {
                            this.queues.setComparator(this.sortOrder);
                        }
                        SubProgressMonitor sub = new SubProgressMonitor(monitor, 0);
                        this.queues.refreshQueues((IProgressMonitor)sub);
                    }
                    catch (Throwable throwable) {
                        var5_6 = null;
                        this.lock.release();
                        throw throwable;
                    }
                    {
                        var5_6 = null;
                    }
                    this.lock.release();
                    this.uiJob.schedule();
                    this.uiJob.join();
                    int consumedUnits = this.uiJob.lastWorked * remainingWorkUnits / totalWork;
                    monitor.worked(consumedUnits);
                    remainingWorkUnits -= consumedUnits;
                }
                catch (InterruptedException interruptedException) {
                    monitor.setCanceled(true);
                }
                if (this.uiJob.controlExists) continue;
                break;
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.enableUpdatesJob.schedule();
            this.enableUpdatesJob.join();
            monitor.done();
            throw throwable;
        }
        {
            Object var7_10 = null;
        }
        this.enableUpdatesJob.schedule();
        this.enableUpdatesJob.join();
        monitor.done();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int updateViewer() {
        int result;
        this.lock.acquire();
        try {
            if (this.getViewer().getSorter() != null) {
                this.getViewer().setSorter(null);
            }
            this.resync();
            result = this.queues.nextUpdate();
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.lock.release();
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        this.lock.release();
        return result;
    }

    private class WidgetRefreshJob
    extends UIJob {
        int lastWorked = 0;
        boolean controlExists = true;

        WidgetRefreshJob(String title) {
            super(title);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public IStatus runInUIThread(IProgressMonitor monitor) {
            if (TableContentProvider.this.lock.getDepth() > 0) {
                this.lastWorked = 0;
                return Status.OK_STATUS;
            }
            TableContentProvider.this.lock.acquire();
            try {
                if (!PlatformUI.isWorkbenchRunning()) {
                    this.controlExists = false;
                } else {
                    this.controlExists = TableContentProvider.this.controlExists();
                    if (this.controlExists) {
                        this.lastWorked = TableContentProvider.this.updateViewer();
                    }
                }
                Object var2_4 = null;
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                TableContentProvider.this.lock.release();
                throw throwable;
            }
            TableContentProvider.this.lock.release();
            return Status.OK_STATUS;
        }
    }
}

