/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.internal.ide.StatusUtil;

public final class RestartableJob {
    IRunnableWithProgress runnable;
    Job theJob;
    boolean restartNeeded = false;
    private Object lock = new Object();
    private IProgressMonitor currentMonitor = null;

    public RestartableJob(String name, IRunnableWithProgress newRunnable) {
        this.runnable = newRunnable;
        this.createJob(name);
        this.theJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent e) {
                Object object = RestartableJob.this.lock;
                synchronized (object) {
                    RestartableJob.this.currentMonitor = null;
                    if (RestartableJob.this.restartNeeded) {
                        RestartableJob.this.theJob.schedule();
                    }
                }
            }
        });
    }

    private void createJob(String name) {
        this.theJob = new Job(name){

            protected IStatus run(IProgressMonitor innerMonitor) {
                try {
                    Object object = RestartableJob.this.lock;
                    synchronized (object) {
                        RestartableJob.this.restartNeeded = false;
                        RestartableJob.this.currentMonitor = innerMonitor;
                    }
                    RestartableJob.this.runnable.run(innerMonitor);
                }
                catch (InvocationTargetException e) {
                    return StatusUtil.newStatus(4, e.toString(), e.getTargetException());
                }
                catch (InterruptedException interruptedException) {
                    return Status.CANCEL_STATUS;
                }
                if (innerMonitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
    }

    public void restart() {
        Object object = this.lock;
        synchronized (object) {
            if (this.currentMonitor == null) {
                this.theJob.schedule();
            } else if (!this.restartNeeded) {
                this.restartNeeded = true;
                this.theJob.cancel();
            }
        }
    }

    public void schedule() {
        Object object = this.lock;
        synchronized (object) {
            if (this.currentMonitor == null) {
                this.theJob.schedule();
            } else if (this.currentMonitor.isCanceled()) {
                this.restartNeeded = true;
            }
        }
    }

    public void cancel() {
        Object object = this.lock;
        synchronized (object) {
            this.theJob.cancel();
            this.restartNeeded = false;
        }
    }
}

