/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.views.markers.internal.BookmarkMarker;
import org.eclipse.ui.views.markers.internal.ConcreteMarker;
import org.eclipse.ui.views.markers.internal.MarkerFilter;
import org.eclipse.ui.views.markers.internal.ProblemMarker;
import org.eclipse.ui.views.markers.internal.TaskMarker;

public class MarkerList {
    private int[] markerCounts = null;
    private ConcreteMarker[] markers;

    public MarkerList() {
        this(new ConcreteMarker[0]);
    }

    public MarkerList(Collection markers) {
        this(markers.toArray(new ConcreteMarker[markers.size()]));
    }

    public MarkerList(ConcreteMarker[] markers) {
        this.markers = markers;
    }

    public static ConcreteMarker createMarker(IMarker marker) throws CoreException {
        if (marker.isSubtypeOf("org.eclipse.core.resources.taskmarker")) {
            return new TaskMarker(marker);
        }
        if (marker.isSubtypeOf("org.eclipse.core.resources.bookmark")) {
            return new BookmarkMarker(marker);
        }
        if (marker.isSubtypeOf("org.eclipse.core.resources.problemmarker")) {
            return new ProblemMarker(marker);
        }
        return new ConcreteMarker(marker);
    }

    public static ConcreteMarker[] createMarkers(Collection ofIMarker) throws CoreException {
        return MarkerList.createMarkers(ofIMarker.toArray(new IMarker[ofIMarker.size()]));
    }

    public static Collection createMarkersIgnoringErrors(Collection ofIMarker) {
        ArrayList<ConcreteMarker> result = new ArrayList<ConcreteMarker>(ofIMarker.size());
        Iterator iter = ofIMarker.iterator();
        while (iter.hasNext()) {
            IMarker next = (IMarker)iter.next();
            try {
                result.add(MarkerList.createMarker(next));
            }
            catch (CoreException coreException) {}
        }
        return result;
    }

    public static ConcreteMarker[] createMarkers(IMarker[] source) throws CoreException {
        ConcreteMarker[] result = new ConcreteMarker[source.length];
        int idx = 0;
        while (idx < source.length) {
            result[idx] = MarkerList.createMarker(source[idx]);
            ++idx;
        }
        return result;
    }

    public static MarkerList compute(MarkerFilter filter, IProgressMonitor mon, boolean ignoreExceptions) throws CoreException {
        return new MarkerList(filter.findMarkers(mon, ignoreExceptions));
    }

    public static IMarker[] compute(String[] types) throws CoreException {
        ArrayList<IMarker> result = new ArrayList<IMarker>();
        IWorkspaceRoot input = ResourcesPlugin.getWorkspace().getRoot();
        int i = 0;
        while (i < types.length) {
            IMarker[] newMarkers = input.findMarkers(types[i], true, 2);
            result.addAll(Arrays.asList(newMarkers));
            ++i;
        }
        return result.toArray(new IMarker[result.size()]);
    }

    public ConcreteMarker[] toArray() {
        return this.markers;
    }

    public int getItemCount() {
        return this.markers.length;
    }

    public int getErrors() {
        return this.getMarkerCounts()[2];
    }

    public int getInfos() {
        return this.getMarkerCounts()[0];
    }

    public int getWarnings() {
        return this.getMarkerCounts()[1];
    }

    private int[] getMarkerCounts() {
        if (this.markerCounts == null) {
            this.markerCounts = new int[3];
            int idx = 0;
            while (idx < this.markers.length) {
                int severity;
                ConcreteMarker marker = this.markers[idx];
                if (marker instanceof ProblemMarker && (severity = ((ProblemMarker)this.markers[idx]).getSeverity()) >= 0 && severity <= 2) {
                    int n = severity;
                    this.markerCounts[n] = this.markerCounts[n] + 1;
                }
                ++idx;
            }
        }
        return this.markerCounts;
    }
}

