/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IWorkingSetSelectionDialog;
import org.eclipse.ui.views.markers.internal.MarkerFilter;
import org.eclipse.ui.views.markers.internal.MarkerType;
import org.eclipse.ui.views.markers.internal.Messages;

public class DialogMarkerFilter
extends Dialog {
    static final int RESET_ID = 1024;
    static final int SELECT_WORKING_SET_ID = 1025;
    static final int SELECT_ALL_ID = 1026;
    static final int DESELECT_ALL_ID = 1027;
    private MarkerFilter filter;
    private CheckboxTableViewer typesViewer;
    private Button filterEnabledButton;
    private Button filterOnMarkerLimit;
    private Button anyResourceButton;
    private Button anyResourceInSameProjectButton;
    private Button selectedResourceButton;
    private Button selectedResourceAndChildrenButton;
    private Button selectAllButton;
    private Button deselectAllButton;
    private WorkingSetGroup workingSetGroup;
    private Text markerLimit;
    private boolean dirty = false;
    protected SelectionListener selectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            DialogMarkerFilter.this.widgetSelected(e);
        }
    };
    protected ICheckStateListener checkStateListener = new ICheckStateListener(){

        public void checkStateChanged(CheckStateChangedEvent event) {
            DialogMarkerFilter.this.checkStateChanged(event);
        }
    };

    DialogMarkerFilter(Shell parentShell, MarkerFilter filter) {
        super(parentShell);
        this.filter = filter;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 1024) {
            this.resetPressed();
            this.markDirty();
        } else if (buttonId == 1025) {
            this.workingSetGroup.selectPressed();
        } else if (buttonId == 1026) {
            this.typesViewer.setAllChecked(true);
        } else if (buttonId == 1027) {
            this.typesViewer.setAllChecked(false);
        } else {
            super.buttonPressed(buttonId);
        }
    }

    void checkStateChanged(CheckStateChangedEvent event) {
        this.updateEnabledState();
        this.markDirty();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.getString("filtersDialog.title"));
    }

    protected void createResetArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(128));
        Button reset = new Button(composite, 8);
        reset.setText(Messages.getString("restoreDefaults.text"));
        reset.setData((Object)new Integer(1024));
        reset.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DialogMarkerFilter.this.buttonPressed((Integer)event.widget.getData());
            }
        });
        reset.setFont(composite.getFont());
        this.setButtonLayoutData(reset);
    }

    protected Button createCheckbox(Composite parent, String text, boolean grabRow) {
        Button button = new Button(parent, 32);
        if (grabRow) {
            GridData gridData = new GridData(768);
            button.setLayoutData((Object)gridData);
        }
        button.setText(text);
        button.addSelectionListener(this.selectionListener);
        button.setFont(parent.getFont());
        return button;
    }

    protected Combo createCombo(Composite parent, String[] items, int selectionIndex) {
        Combo combo = new Combo(parent, 12);
        combo.setLayoutData((Object)new GridData(768));
        combo.setFont(parent.getFont());
        combo.setItems(items);
        combo.select(selectionIndex);
        combo.addSelectionListener(this.selectionListener);
        return combo;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.createOnOffArea(composite);
        this.createMarkerLimitArea(composite);
        this.createTypesArea(composite);
        this.createResourceArea(composite);
        this.createAttributesArea(composite);
        this.createResetArea(composite);
        this.createSeparatorLine(composite);
        this.updateUIFromFilter();
        return composite;
    }

    protected void createSeparatorLine(Composite parent) {
        Label separator = new Label(parent, 258);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 1;
        separator.setLayoutData((Object)gd);
    }

    protected Button createRadioButton(Composite parent, String text) {
        Button button = new Button(parent, 16);
        button.setText(text);
        button.setFont(parent.getFont());
        button.addSelectionListener(this.selectionListener);
        return button;
    }

    protected void createResourceArea(Composite parent) {
        Composite group = new Composite(parent, 0);
        group.setLayoutData((Object)new GridData(768));
        group.setLayout((Layout)new GridLayout());
        group.setFont(parent.getFont());
        this.anyResourceButton = this.createRadioButton(group, Messages.getString("filtersDialog.anyResource"));
        this.anyResourceInSameProjectButton = this.createRadioButton(group, Messages.getString("filtersDialog.anyResourceInSameProject"));
        this.selectedResourceButton = this.createRadioButton(group, Messages.getString("filtersDialog.selectedResource"));
        this.selectedResourceAndChildrenButton = this.createRadioButton(group, Messages.getString("filtersDialog.selectedAndChildren"));
        this.workingSetGroup = new WorkingSetGroup(group);
    }

    protected void createTypesArea(Composite parent) {
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        Label label = new Label(composite, 0);
        label.setText(Messages.getString("filtersDialog.showItemsOfType"));
        label.setFont(font);
        Table table = new Table(composite, 68386);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnPixelData(150, true));
        TableColumn tc = new TableColumn(table, 0, 0);
        tc.setText(Messages.getString("filtersDialog.type.columnHeader"));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnPixelData(224, true));
        tc = new TableColumn(table, 0, 1);
        tc.setText(Messages.getString("filtersDialog.superTypecolumnHeader"));
        this.typesViewer = new CheckboxTableViewer(table);
        GridData gridData = new GridData(768);
        gridData.heightHint = 105;
        gridData.widthHint = 350;
        this.typesViewer.getTable().setFont(font);
        this.typesViewer.getControl().setLayoutData((Object)gridData);
        this.typesViewer.setContentProvider((IContentProvider)this.getContentProvider());
        this.typesViewer.setLabelProvider((IBaseLabelProvider)this.getLabelProvider());
        this.typesViewer.setSorter(this.getSorter());
        this.typesViewer.addCheckStateListener(this.checkStateListener);
        this.typesViewer.setInput((Object)this.filter.getRootTypes().toArray());
        Composite buttonComposite = new Composite(composite, 0);
        GridLayout buttonLayout = new GridLayout();
        buttonLayout.marginWidth = 0;
        buttonComposite.setLayout((Layout)buttonLayout);
        this.selectAllButton = this.createButton(buttonComposite, 1026, Messages.getString("filtersDialog.selectAll"), false);
        this.deselectAllButton = this.createButton(buttonComposite, 1027, Messages.getString("filtersDialog.deselectAll"), false);
    }

    private IStructuredContentProvider getContentProvider() {
        return new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                List roots = DialogMarkerFilter.this.filter.getRootTypes();
                ArrayList elements = new ArrayList();
                int i = 0;
                while (i < roots.size()) {
                    Object obj = roots.get(i);
                    if (obj instanceof MarkerType) {
                        elements.add(obj);
                        MarkerType[] subTypes = ((MarkerType)obj).getAllSubTypes();
                        int j = 0;
                        while (j < subTypes.length) {
                            MarkerType subType = subTypes[j];
                            if (!elements.contains(subType)) {
                                elements.add(subType);
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
                return elements.toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        };
    }

    protected void createOnOffArea(Composite parent) {
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(768));
        composite.setFont(font);
        composite.setLayout((Layout)new GridLayout());
        this.filterEnabledButton = this.createCheckbox(composite, Messages.getString("filtersDialog.onOff"), false);
        this.filterEnabledButton.setFont(composite.getFont());
        this.filterEnabledButton.setLayoutData((Object)new GridData());
        this.filterEnabledButton.addSelectionListener(this.selectionListener);
    }

    protected void createMarkerLimitArea(Composite parent) {
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(768));
        composite.setFont(font);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        this.filterOnMarkerLimit = this.createCheckbox(composite, Messages.getString("filtersDialog.limitVisibleMarkersTo"), false);
        this.filterOnMarkerLimit.setFont(composite.getFont());
        this.filterOnMarkerLimit.setLayoutData((Object)new GridData());
        this.filterOnMarkerLimit.addSelectionListener(this.selectionListener);
        this.markerLimit = new Text(composite, 2052);
        this.markerLimit.setTextLimit(6);
        GridData gridData = new GridData();
        gridData.widthHint = this.convertWidthInCharsToPixels(10);
        this.markerLimit.setLayoutData((Object)gridData);
        this.markerLimit.setFont(font);
        this.markerLimit.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DialogMarkerFilter.this.markDirty();
            }
        });
    }

    protected void createAttributesArea(Composite parent) {
    }

    private ILabelProvider getLabelProvider() {
        return new TypesLabelProvider();
    }

    protected List getSelectedTypes() {
        return Arrays.asList(this.typesViewer.getCheckedElements());
    }

    protected ViewerSorter getSorter() {
        return new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                MarkerType t1 = (MarkerType)e1;
                MarkerType t2 = (MarkerType)e2;
                return this.collator.compare(t1.getLabel(), t2.getLabel());
            }
        };
    }

    protected void okPressed() {
        block3: {
            try {
                int markerLimit = Integer.parseInt(this.markerLimit.getText());
                if (markerLimit < 1) {
                    throw new NumberFormatException();
                }
                this.updateFilterFromUI();
                super.okPressed();
            }
            catch (NumberFormatException numberFormatException) {
                MessageBox messageBox = new MessageBox(this.getShell(), 65569);
                messageBox.setText(Messages.getString("filtersDialog.titleMarkerLimitInvalid"));
                messageBox.setMessage(Messages.getString("filtersDialog.messageMarkerLimitInvalid"));
                messageBox.open();
                if (!this.markerLimit.forceFocus()) break block3;
                this.markerLimit.setSelection(0, this.markerLimit.getCharCount());
                this.markerLimit.showSelection();
            }
        }
    }

    protected void resetPressed() {
        this.filterEnabledButton.setSelection(true);
        this.filterOnMarkerLimit.setSelection(true);
        this.markerLimit.setText(String.valueOf(300));
        this.typesViewer.setAllChecked(true);
        int onResource = 0;
        this.anyResourceButton.setSelection(onResource == 0);
        this.anyResourceInSameProjectButton.setSelection(onResource == 3);
        this.selectedResourceButton.setSelection(onResource == 1);
        this.selectedResourceAndChildrenButton.setSelection(onResource == 2);
        this.workingSetGroup.setSelection(onResource == 4);
        this.updateEnabledState();
    }

    void setSelectedTypes(List markerTypes) {
        this.typesViewer.setCheckedElements(new Object[0]);
        int i = 0;
        while (i < markerTypes.size()) {
            Object obj = markerTypes.get(i);
            if (obj instanceof MarkerType) {
                this.typesViewer.setChecked(obj, true);
            }
            ++i;
        }
    }

    protected void updateEnabledState() {
        this.filterOnMarkerLimit.setEnabled(this.isFilterEnabled());
        this.markerLimit.setEnabled(this.isFilterEnabled() && this.filterOnMarkerLimit.getSelection());
        this.typesViewer.getTable().setEnabled(this.isFilterEnabled());
        this.selectAllButton.setEnabled(this.isFilterEnabled() && this.typesViewer.getTable().getItemCount() > 0);
        this.deselectAllButton.setEnabled(this.isFilterEnabled() && this.typesViewer.getTable().getItemCount() > 0);
        this.anyResourceButton.setEnabled(this.isFilterEnabled());
        this.anyResourceInSameProjectButton.setEnabled(this.isFilterEnabled());
        this.selectedResourceButton.setEnabled(this.isFilterEnabled());
        this.selectedResourceAndChildrenButton.setEnabled(this.isFilterEnabled());
        this.workingSetGroup.setEnabled(this.isFilterEnabled());
    }

    protected void updateFilterFromUI() {
        this.filter.setEnabled(this.filterEnabledButton.getSelection());
        this.filter.setSelectedTypes(this.getSelectedTypes());
        if (this.selectedResourceButton.getSelection()) {
            this.filter.setOnResource(1);
        } else if (this.selectedResourceAndChildrenButton.getSelection()) {
            this.filter.setOnResource(2);
        } else if (this.anyResourceInSameProjectButton.getSelection()) {
            this.filter.setOnResource(3);
        } else if (this.workingSetGroup.getSelection()) {
            this.filter.setOnResource(4);
        } else {
            this.filter.setOnResource(0);
        }
        this.filter.setWorkingSet(this.workingSetGroup.getWorkingSet());
        int markerLimit = 300;
        try {
            markerLimit = Integer.parseInt(this.markerLimit.getText());
        }
        catch (NumberFormatException numberFormatException) {}
        this.filter.setMarkerLimit(markerLimit);
        this.filter.setFilterOnMarkerLimit(this.filterOnMarkerLimit.getSelection());
    }

    protected void updateUIFromFilter() {
        this.filterEnabledButton.setSelection(this.filter.isEnabled());
        this.setSelectedTypes(this.filter.getSelectedTypes());
        int on = this.filter.getOnResource();
        this.anyResourceButton.setSelection(on == 0);
        this.anyResourceInSameProjectButton.setSelection(on == 3);
        this.selectedResourceButton.setSelection(on == 1);
        this.selectedResourceAndChildrenButton.setSelection(on == 2);
        this.workingSetGroup.setSelection(on == 4);
        this.workingSetGroup.setWorkingSet(this.filter.getWorkingSet());
        this.markerLimit.setText("" + this.filter.getMarkerLimit());
        this.filterOnMarkerLimit.setSelection(this.filter.getFilterOnMarkerLimit());
        this.updateEnabledState();
    }

    protected void widgetSelected(SelectionEvent e) {
        this.updateEnabledState();
        this.markDirty();
    }

    boolean isDirty() {
        return this.dirty;
    }

    void markDirty() {
        this.dirty = true;
    }

    public void setFilter(MarkerFilter newFilter) {
        this.filter = newFilter;
        this.updateUIFromFilter();
    }

    public MarkerFilter getFilter() {
        return this.filter;
    }

    protected boolean isFilterEnabled() {
        return this.filterEnabledButton == null || this.filterEnabledButton.getSelection();
    }

    private class TypesLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        TypesLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (!(element instanceof MarkerType)) {
                return "";
            }
            MarkerType type = (MarkerType)element;
            if (columnIndex == 0) {
                return type.getLabel();
            }
            if (columnIndex == 1) {
                String superTypes = "";
                MarkerType[] supers = type.getSupertypes();
                int i = 0;
                while (i < supers.length) {
                    superTypes = String.valueOf(superTypes) + supers[i].getLabel();
                    if (i < supers.length - 1) {
                        superTypes = String.valueOf(superTypes) + "; ";
                    }
                    ++i;
                }
                return superTypes;
            }
            return "";
        }
    }

    private class WorkingSetGroup {
        private Button button;
        private Button selectButton;

        WorkingSetGroup(Composite parent) {
            this.button = DialogMarkerFilter.this.createRadioButton(parent, Messages.getString("filtersDialog.noWorkingSet"));
            GridData data = new GridData(768);
            this.button.setLayoutData((Object)data);
            Composite composite = new Composite(parent, 0);
            composite.setFont(parent.getFont());
            GridLayout layout = new GridLayout();
            Button radio = new Button(parent, 16);
            layout.marginWidth = radio.computeSize((int)-1, (int)-1).x;
            layout.marginHeight = 0;
            radio.dispose();
            composite.setLayout((Layout)layout);
            this.selectButton = DialogMarkerFilter.this.createButton(composite, 1025, Messages.getString("filtersDialog.workingSetSelect"), false);
        }

        boolean getSelection() {
            return this.button.getSelection();
        }

        IWorkingSet getWorkingSet() {
            return (IWorkingSet)this.button.getData();
        }

        void setSelection(boolean selected) {
            this.button.setSelection(selected);
            if (selected) {
                DialogMarkerFilter.this.anyResourceButton.setSelection(false);
                DialogMarkerFilter.this.anyResourceInSameProjectButton.setSelection(false);
                DialogMarkerFilter.this.selectedResourceButton.setSelection(false);
                DialogMarkerFilter.this.selectedResourceAndChildrenButton.setSelection(false);
            }
        }

        void selectPressed() {
            IWorkingSetSelectionDialog dialog = PlatformUI.getWorkbench().getWorkingSetManager().createWorkingSetSelectionDialog(DialogMarkerFilter.this.getShell(), false);
            IWorkingSet workingSet = this.getWorkingSet();
            if (workingSet != null) {
                dialog.setSelection(new IWorkingSet[]{workingSet});
            }
            if (dialog.open() == 0) {
                DialogMarkerFilter.this.markDirty();
                IWorkingSet[] result = dialog.getSelection();
                if (result != null && result.length > 0) {
                    this.setWorkingSet(result[0]);
                } else {
                    this.setWorkingSet(null);
                }
                if (!this.getSelection()) {
                    this.setSelection(true);
                }
            }
        }

        void setWorkingSet(IWorkingSet workingSet) {
            this.button.setData((Object)workingSet);
            if (workingSet != null) {
                this.button.setText(Messages.format("filtersDialog.workingSet", new Object[]{workingSet.getName()}));
            } else {
                this.button.setText(Messages.getString("filtersDialog.noWorkingSet"));
            }
        }

        void setEnabled(boolean enabled) {
            this.button.setEnabled(enabled);
            this.selectButton.setEnabled(enabled);
        }
    }
}

