/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.views.markers.internal.Util;

public class ConcreteMarker {
    private String description;
    private String resourceName;
    private String inFolder;
    private int line;
    private long creationTime;
    private String type;
    private IMarker marker;

    public ConcreteMarker(IMarker toCopy) {
        this.description = Util.getProperty("message", toCopy);
        this.resourceName = toCopy.getResource().getName();
        this.inFolder = Util.getContainerName(toCopy);
        this.line = toCopy.getAttribute("lineNumber", -1);
        try {
            this.creationTime = toCopy.getCreationTime();
        }
        catch (CoreException coreException) {
            this.creationTime = 0L;
        }
        try {
            this.type = toCopy.getType();
        }
        catch (CoreException coreException) {
            this.type = "";
        }
        this.marker = toCopy;
    }

    public IResource getResource() {
        return this.marker.getResource();
    }

    public String getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public int getLine() {
        return this.line;
    }

    public String getFolder() {
        return this.inFolder;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public IMarker getMarker() {
        return this.marker;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ConcreteMarker)) {
            return false;
        }
        ConcreteMarker other = (ConcreteMarker)object;
        return other.getMarker().equals((Object)this.getMarker());
    }

    public int hashCode() {
        return this.getMarker().hashCode();
    }
}

