/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.eclipse.ui.views.markers.TaskView;
import org.eclipse.ui.views.markers.internal.ConcreteMarker;
import org.eclipse.ui.views.markers.internal.MarkerList;
import org.eclipse.ui.views.markers.internal.Messages;
import org.eclipse.ui.views.markers.internal.TaskMarker;

public class ActionDeleteCompleted
extends SelectionProviderAction {
    private TaskView part;

    public ActionDeleteCompleted(TaskView part, ISelectionProvider provider) {
        super(provider, Messages.getString("deleteCompletedAction.title"));
        this.setEnabled(false);
    }

    public void run() {
        final List completed = this.getCompletedTasks();
        if (completed.size() == 0) {
            MessageDialog.openInformation((Shell)this.part.getSite().getShell(), (String)Messages.getString("deleteCompletedTasks.dialogTitle"), (String)Messages.getString("deleteCompletedTasks.noneCompleted"));
            return;
        }
        String message = completed.size() == 1 ? Messages.getString("deleteCompletedTasks.permanentSingular") : Messages.format("deleteCompletedTasks.permanentPlural", new Object[]{new Integer(completed.size())});
        if (!MessageDialog.openConfirm((Shell)this.part.getSite().getShell(), (String)Messages.getString("deleteCompletedTasks.dialogTitle"), (String)message)) {
            return;
        }
        try {
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) {
                    int i = 0;
                    while (i < completed.size()) {
                        IMarker marker = (IMarker)completed.get(i);
                        try {
                            marker.delete();
                        }
                        catch (CoreException coreException) {}
                        ++i;
                    }
                }
            }, null);
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)this.part.getSite().getShell(), (String)Messages.getString("deleteCompletedTasks.errorMessage"), null, (IStatus)e.getStatus());
        }
    }

    private List getCompletedTasks() {
        ArrayList<IMarker> completed = new ArrayList<IMarker>();
        this.getSelectionProvider();
        MarkerList markerList = this.part.getVisibleMarkers();
        ConcreteMarker[] markers = markerList.toArray();
        int i = 0;
        while (i < markers.length) {
            TaskMarker taskMarker;
            ConcreteMarker marker = markers[i];
            if (marker instanceof TaskMarker && (taskMarker = (TaskMarker)marker).getDone() == 1) {
                completed.add(taskMarker.getMarker());
            }
            ++i;
        }
        return completed;
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(!selection.isEmpty());
    }
}

